
#ifndef DEEPINFER_CAMERA_IOS_H_
#define DEEPINFER_CAMERA_IOS_H_

#include <vector>
#include <string>
#include "base/image.h"
#include "interfaces/base_io.h"


namespace waytous {
namespace deepinfer {
namespace ios {


class CameraSrcIn: public interfaces::BaseIO{
public:
    CameraSrcIn(cv::Mat* img): cv_img_(img){};
    cv::Mat* cv_img_;
};
using CameraSrcInPtr = std::shared_ptr<CameraSrcIn>;


class CameraSrcOut: public interfaces::BaseIO{
public:
    CameraSrcOut(base::Image8UPtr img): img_ptr_(img){};
    base::Image8UPtr img_ptr_;
};
using CameraSrcOutPtr = std::shared_ptr<CameraSrcOut>;


}  // namespace ios
}  // namespace deepinfer
}  // namespace waytous

#endif
