#ifndef DEEPINFER_INTERFACES_BASE_UNIT_H_
#define DEEPINFER_INTERFACES_BASE_UNIT_H_

#include <string>
#include <vector>
#include <memory>
#include <yaml-cpp/yaml.h>
#include <opencv2/opencv.hpp>

#include "base/blob.h"
#include "common/log.h"
#include "common/register.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {


class BaseUnit{

public:
    BaseUnit() = default;
    virtual ~BaseUnit() = default;
    
    virtual bool Init(YAML::Node& node);

    virtual bool Exec() = 0;

    virtual std::string Name(){
        return "BaseUnit";
    }

public:
    std::vector<std::string> inputNames;
    std::vector<std::string> outputNames;

};
using BaseUnitPtr = std::shared_ptr<BaseUnit>;

DEEPINFER_REGISTER_REGISTERER(BaseUnit);
#define DEEPINFER_REGISTER_UNIT(name) \
  DEEPINFER_REGISTER_CLASS(BaseUnit, name)

}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous


#endif
