
#include <cuda_runtime.h>

#include "common/file.h"
#include "common/common.h"
#include "common/log.h"

#include "interfaces/base_task.h"

namespace waytous{
namespace deepinfer{
namespace interfaces{


bool BaseTask::Init(std::string& taskConfigPath){
    if(!waytous::deepinfer::common::PathExists(taskConfigPath)){
        LOG_WARN << "config_file " << taskConfigPath << " not exist.";
        return false;
    }
    taskNode = YAML::LoadFile(taskConfigPath);
    if (taskNode.IsNull()) {
        LOG_WARN << "Load " << taskConfigPath << " failed! please check!";
        return false;
    }
    if(!taskNode["configRootPath"].IsDefined()){
        LOG_WARN << "Forget set root path?";
        return false;
    }
    std::string configRootPath = taskNode["configRootPath"].as<std::string>();
    common::ConfigRoot::SetRootPath(configRootPath);
    LOG_INFO << "Set root path " << common::ConfigRoot::GetRootPath() << ": " << configRootPath;
    int device = 0;
    if(taskNode["device"].IsDefined() && !taskNode["device"].IsNull()){
		device = taskNode["device"].as<int>();
        LOG_INFO << "Using device id: " << device;
    } else{
        LOG_INFO << "Using default device 0.";
    }
    CUDA_CHECK(cudaSetDevice(device));
    return true;
}


cv::Scalar BaseTask::get_color(int idx)
{
	idx += 3;
	return cv::Scalar(37 * idx % 255, 17 * idx % 255, 29 * idx % 255);
}

} //namespace task
} //namspace deepinfer
} //namespace waytous





