
#include "interfaces/base_io.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {

// cudafree global variable -> cuda_error 29
BaseIOMap &GlobalBaseIOMap(){
    static BaseIOMap GlobalIOMap;
    return GlobalIOMap;
}


BaseIOPtr GetIOPtr(std::string& ioName){
    auto& gmap = GlobalBaseIOMap();
    auto iter = gmap.find(ioName);
    if (iter == gmap.end()) {
        return nullptr;
    }
    return iter->second;
}


void SetIOPtr(std::string& ioName, BaseIOPtr src){
    auto& gmap = GlobalBaseIOMap();
    gmap[ioName] = src;
}


}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous


