
#ifndef WAYTOUS_DEEPINFER_COMMON_FILES_H_
#define WAYTOUS_DEEPINFER_COMMON_FILES_H_

#pragma once
#include <string>
#include <memory>
#include <sys/stat.h>
#include <unistd.h>

#include "common/log.h"

namespace waytous{
namespace deepinfer{
namespace common{


class ConfigRoot{
public:
    static std::shared_ptr<ConfigRoot> instance;

public:
    std::string rootPath;
    
    static const std::string GetRootPath();

    static void SetRootPath(const std::string path);
};



inline std::string GetCurrentPath() {
    char tmp[4096];
    return getcwd(tmp, sizeof(tmp)) ? std::string(tmp) : std::string("");
}


inline std::string GetAbsolutePath(const std::string &prefix,
                            const std::string &relative_path) {
    if (relative_path.empty()) {
        return prefix;
    }
    // If prefix is empty or relative_path is already absolute.
    if (prefix.empty() || relative_path.front() == '/') {
        return relative_path;
    }

    if (prefix.back() == '/') {
        return prefix + relative_path;
    }
    return prefix + "/" + relative_path;
}


inline bool PathExists(const std::string &path) {
    struct stat info;
    return stat(path.c_str(), &info) == 0;
}



} //namespace common
} //namspace deepinfer
} //namespace waytous

#endif