#ifndef DEEPINFER_COMMON_H_
#define DEEPINFER_COMMON_H_


#include <cublas_v2.h>
#include <cuda_runtime.h>
#include <iostream>
#include <sstream>
#include <iomanip>
#include <cmath>
#include <assert.h>

#define BLOCK 512
#define iMAX(a, b) ((a) > (b) ? (a) : (b))
#define iMIN(a, b) ((a) > (b) ? (b) : (a))

#ifndef CUDA_CHECK
#define CUDA_CHECK(callstr)                                                                    \
    {                                                                                          \
        cudaError_t error_code = callstr;                                                      \
        if (error_code != cudaSuccess) {                                                       \
            std::cerr << "CUDA error " << error_code << " at " << __FILE__ << ":" << __LINE__; \
            assert(0);                                                                         \
        }                                                                                      \
    }
#endif

#ifndef PI
#define PI 3.1415926
#endif

namespace waytous{
namespace deepinfer{
namespace common{

inline dim3 cudaGridSize(uint n, uint block)
{
    uint k = (n - 1) / block + 1;
    uint x = k ;
    uint y = 1 ;
    if (x > 65535 )
    {
        x = ceil(sqrt(x));
        y = (n - 1 )/(x * block) + 1;
    }
    dim3 d = {x, y, 1} ;
    return d;
}


inline std::string formatValue(float val, int fixed) {
    std::ostringstream oss;
    oss << std::setprecision(fixed) << val;
    return oss.str();
}


inline float euclidean(float x1, float y1, float x2, float y2){
    return std::sqrt(std::pow((x2 - x1), 2) + std::pow((y2 - y1), 2));
}


inline void softmax(float *x, int length){
    float max = x[0];
    float sum = 0.0;
    for(int i=0; i<length; i++){
        if(max < x[i]){
            max = x[i];
        }
    }
    for(int i=0; i<length; i++){
        x[i] = std::exp(x[i] - max);
        sum += x[i];
    }
    for(int i=0; i<length; i++){
        x[i] /= sum;
    }
    
}


} //namespace common
} //namspace deepinfer
} //namespace waytous


#endif



