
#include "tasks/task_fusion.h"

namespace waytous{
namespace deepinfer{
namespace task{


bool TaskFusion::Init(std::string& taskConfigPath){
    if(!interfaces::BaseTask::Init(taskConfigPath)){
        LOG_ERROR << "Init task detect error";
        return false;
    };
    std::string detectorName = taskNode["detectorName"].as<std::string>();
    std::string detectorConfigPath = taskNode["detectorConfigPath"].as<std::string>();

    model.reset(interfaces::BaseModelRegisterer::GetInstanceByName(detectorName));
    if(!model->Init(detectorConfigPath)){
        LOG_ERROR << detectorName << " detector init problem";
        return false;
    };
    return true;
}


bool TaskFusion::Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs){
    if(!model->Exec(inputs, outputs)){
        LOG_ERROR << "Task Detect Exec error";
        return false;
    };
    return true;
}


void TaskFusion::Visualize(cv::Mat* image, interfaces::BaseIOPtr outs){
    auto detections = std::dynamic_pointer_cast<ios::Detection2Ds>(outs)->detections;
    for(auto &obj : detections){
        // LOG_INFO << "box: " << obj->x1 << " " << obj->x2 << " " << obj->y1 << " " << obj->y2;
        cv::Scalar color = get_color(obj->class_label);
        cv::rectangle(*image, cv::Rect(int(obj->x1), int(obj->y1), int(obj->x2 - obj->x1), int(obj->y2 - obj->y1)), color, 2);
        cv::putText(*image, common::formatValue(obj->confidence, 2) + ":" + 
                    std::to_string(obj->track_id) + "." + obj->class_name, 
                    cv::Point(int(obj->x1), int(obj->y1) - 5), cv::FONT_HERSHEY_SIMPLEX, 0.5, color, 1);
    }
}


std::string TaskFusion::Name(){
    return "TaskFusion";
}


} //namespace task
} //namspace deepinfer
} //namespace waytous









