
#ifndef WAYTOUS_DEEPINFER_TASK_DMS_H_
#define WAYTOUS_DEEPINFER_TASK_DMS_H_

#include "interfaces/base_task.h"
#include "models/camera_model.h"
#include "libs/ios/detection.h"
#include "libs/ios/head_pose.h"
#include "libs/ios/landmark.h"

namespace waytous{
namespace deepinfer{
namespace task{

enum class DMSMsg{
    DMS_NONE = 0, // 正常
    DMS_NOD = 10, // 打瞌睡(闭眼/打哈欠)
    DMS_NOD_EYE = 11,
    DMS_NOD_MOUTH = 12,
    DMS_CALL = 20, // 打电话
    DMS_INATTENTION = 30, // 注意力不集中(抬头/低头/左顾右盼)
    DMS_NODRIVER = 40, // 司机不在
    DMS_UNMASK = 50 // 未带口罩
};


class DMSResult: public interfaces::BaseIO{
public:
    ios::Det2DPtr faceBBox;
    cv::Rect2i faceSquare;
    ios::HeadPosePtr headPose;
    ios::LandmarksPtr face_landmarks;
    DMSMsg msg = DMSMsg::DMS_NONE;
};
using DMSResultPtr = std::shared_ptr<DMSResult>;



class TaskDMS: public interfaces::BaseTask{
public:

    bool Init(std::string& taskConfigPath) override;

    bool Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs) override;
    void Visualize(cv::Mat* image, interfaces::BaseIOPtr outs) override;
    std::string Name() override;

private:
    
    float accOrganAspectRatio(int* indices);

    void resetCounter();

    void drawAxis(cv::Mat& img, float& pitch_, float& yaw_, float& roll_, int cx, int cy, int size);


public:
    std::shared_ptr<interfaces::BaseModel> faceDetector;
    std::shared_ptr<interfaces::BaseModel> landmarkDetector;
    std::shared_ptr<interfaces::BaseModel> headposeDetector;

    int eyeLandmarkIndices[2][6] = {{36, 37, 38, 39, 40, 41}, {42, 43, 44, 45, 46, 47}}; // eye indices: left and right
    int mouthLandmarkIndices[6] = {48, 48 + 2, 48 + 4, 48 + 6, 48 + 8, 48 + 10};//mouth indicies from 48 to 68, but interested 6 points

    float mouthARThreshold = 0.75; //嘴巴横纵比的阈值
    float eyeARThreshold = 0.25; //眼睛横纵比的阈值
    int eyeARConsecFrames = 15; //触发警报，即眼睛横纵比低于阈值的连续帧数阈值
    int distractionConsecFrames = 1;
    int unmaskedConsecFrames = 20;
    int nodriverConsecFrames = 20;
    int sightYawThresholdLeft = -40;//degree
    int sightYawThresholdRight = 40;//degree
    int sightPitchThresholdLeft = -40;//degree
    int sightPitchThresholdRight = 40;//degree
    // DMS counters
    int EYE_CLOSE_COUNTER = 0; //眼睛横纵比低于阈值的连续帧数计数
    int DISTRACTION_COUNTER = 0;
    int UNMASKED_COUNTER = 0;
    int NODRIVER_COUNTER = 0;

    float eyeAR;
    float mouthAR;

    DMSResultPtr res;

};

DEEPINFER_REGISTER_TASKS(TaskDMS);

} //namespace task
} //namspace deepinfer
} //namespace waytous


#endif








