
#ifndef WAYTOUS_DEEPINFER_TASK_BSW_H_
#define WAYTOUS_DEEPINFER_TASK_BSW_H_

#include "interfaces/base_task.h"
#include "models/camera_model.h"
#include "libs/ios/detection.h"

namespace waytous{
namespace deepinfer{
namespace task{


struct RangeInfo{
    std::string name;
    cv::Scalar color;
    int warningFrameThreshold;
    std::vector<cv::Point> polygan;
};


enum class BSWMsg{ // blind spot warning
    BSW_NORMAL = 0,
    BSW_YELLOW = 1,
    BSW_RED = 2,
};


class BSWResult: public interfaces::BaseIO{
public:
    ios::Det2DPtr obj;
    std::vector<int> counters; // for count warning frame
    int lost_ages = 0; // untracked frame number
    BSWMsg msg = BSWMsg::BSW_NORMAL;
};
using BSWResultPtr = std::shared_ptr<BSWResult>;



class TaskBSW: public interfaces::BaseTask{
public:
    std::map<std::string, BSWMsg> WarningName2Msg = {
        {"Green", BSWMsg::BSW_NORMAL},
        {"Yellow", BSWMsg::BSW_YELLOW},
        {"Red", BSWMsg::BSW_RED},
        };

    bool Init(std::string& taskConfigPath) override;

    bool Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs) override;
    void Visualize(cv::Mat* image, interfaces::BaseIOPtr outs) override;
    std::string Name() override;

private:
    
    bool InitRanges(const std::string& warningRangeConfigPath, YAML::Node& distanceNode);
    
    bool isInRange(const std::vector<cv::Point>& polygan, float x, float y);

public:
    std::shared_ptr<interfaces::BaseModel> detector;

    std::vector<RangeInfo> ranges;
    std::map<int, BSWResultPtr> BSWRes;
    int imageWidth, imageHeight;
    cv::Mat mask;

};

DEEPINFER_REGISTER_TASKS(TaskBSW);

} //namespace task
} //namspace deepinfer
} //namespace waytous


#endif








