#ifndef DEEPINFER_CAMERA_MODEL_H_
#define DEEPINFER_CAMERA_MODEL_H_

#include <string>
#include <vector>
#include <memory>

#include "libs/sources/camera_src.h"
#include "interfaces/base_model.h"

namespace waytous {
namespace deepinfer {
namespace camera {


class CameraModel: public interfaces::BaseModel{

public:
    virtual bool Init(std::string& configPath) override;

    virtual bool Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs);
    virtual bool Exec(std::vector<base::Image8UPtr> inputs, std::vector<interfaces::BaseIOPtr>& outputs);

    virtual std::string Name() override;

public:
    YAML::Node modelConfigNode;
    std::vector<interfaces::BaseUnitPtr> units_;
};

DEEPINFER_REGISTER_MODELS(CameraModel);

}  // namespace camera
}  // namespace deepinfer
}  // namespace waytous


#endif


