#ifndef WAYTOUS_DEEPINFER_TRACK_H_
#define WAYTOUS_DEEPINFER_TRACK_H_

#include <vector>

#include "libs/ios/detection.h"
#include "libs/trackers/tracker_datatype.h"
#include "libs/trackers/kalman_filter.h"

namespace waytous{
namespace deepinfer{
namespace tracker{


enum TrackState { New = 0, Tracked, Lost, Removed };

class Track
{
public:
	Track(ios::Det2DPtr obj);
	~Track();

	std::vector<float> static tlbr_to_tlwh(std::vector<float> &tlbr);
	void static multi_predict(std::vector<Track*> &tracks, KalmanFilter &kalman_filter);
	void static_tlwh();
	void static_tlbr();
	std::vector<float> tlwh_to_xyah(std::vector<float> tlwh_tmp);
	std::vector<float> to_xyah();
	void mark_lost();
	void mark_removed();
	int next_id();
	int end_frame();
	
	void activate(KalmanFilter &kalman_filter, int frame_id);
	void re_activate(Track &new_track, int frame_id, bool new_id = false);
	void update(Track &new_track, int frame_id);

public:
	bool is_activated;
	int track_id;
	int state;

	std::vector<float> _tlwh;
	std::vector<float> tlwh;
	std::vector<float> tlbr;

	int frame_id;
	int tracklet_len;
	int start_frame;

	KAL_MEAN mean;
	KAL_COVA covariance;

    ios::Det2DPtr obj_;

private:
	KalmanFilter kalman_filter;
};


} //namespace tracker
} //namspace deepinfer
} //namespace waytous

#endif


