
#ifndef DEEPINFER_PREPROCESS_UNDISTORT_H_
#define DEEPINFER_PREPROCESS_UNDISTORT_H_

#include <memory>
#include <string>
#include <algorithm>
#include <Eigen/Dense>
#include <npp.h>

#include "common/file.h"
#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/camera_ios.h"

namespace waytous {
namespace deepinfer {
namespace preprocess {


class Undistort: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

    bool loadIntrinsic(std::string& yaml_file);
    bool loadExtrinsics(std::string& yaml_file);
    void InitUndistortRectifyMap(const Eigen::Matrix3f &camera_model,
                               const Eigen::Matrix<float, 1, 5> &distortion,
                               const Eigen::Matrix3f &R,
                               const Eigen::Matrix3f &new_camera_model,
                               int width, int height, base::Blob<float> *d_mapx,
                               base::Blob<float> *d_mapy);

public:
    base::Blob<float> d_mapx_;
    base::Blob<float> d_mapy_;
    Eigen::Matrix<double, 4, 4, Eigen::RowMajor> camera_extrinsic; // load by another yaml file
    Eigen::Matrix<float, 3, 3, Eigen::RowMajor> camera_intrinsic;
    Eigen::Matrix<float, 3, 3, Eigen::RowMajor> camera_rectification;
    Eigen::Matrix<float, 3, 4, Eigen::RowMajor> camera_projection;
    Eigen::Matrix<float, 1, 5, Eigen::RowMajor> distortion_coefficients;

    int width_ = 0;     // image cols
    int height_ = 0;    // image rows
    int in_size_ = 0;   // size of the input image in byte
    int out_size_ = 0;  // size of the output image in byte
    int device_ = 0;    // device number for gpu
    bool inited_ = 0;

};

DEEPINFER_REGISTER_UNIT(Undistort);


}  // namespace preprocess
}  // namespace deepinfer
}  // namespace waytous

#endif



