
#ifndef DEEPINFER_POSTPROCESS_WHENet_H_
#define DEEPINFER_POSTPROCESS_WHENet_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/ios/head_pose.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class WHENetPostProcess: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

public:
    int outputYawLength;
    int outputPitchLength;
    int outputRollLength;

};

DEEPINFER_REGISTER_UNIT(WHENetPostProcess);


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif



