
#ifndef DEEPINFER_POSTPROCESS_MOBILEFACENET_H_
#define DEEPINFER_POSTPROCESS_MOBILEFACENET_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/ios/landmark.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class MobileFaceNetPostProcess: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

public:
    int landmarkNumber;

};

DEEPINFER_REGISTER_UNIT(MobileFaceNetPostProcess);


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif



