#include "libs/postprocessors/homo_project.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


bool HomoProject::Init(YAML::Node& node, YAML::Node& globalParamNode) {
    if(!BaseUnit::Init(node, globalParamNode)){
        LOG_WARN << "Init homo project error";
        return false;
    };
    auto homoMatrixPath = node["homoMatrixPath"].as<std::string>();
    std::string yaml_path = common::GetAbsolutePath(common::ConfigRoot::GetRootPath(), homoMatrixPath);
    if (!common::PathExists(yaml_path)) {
        LOG_INFO << yaml_path << " does not exist!";
        return false;
    }

    YAML::Node node = YAML::LoadFile(yaml_path);
    if (node.IsNull()) {
        LOG_INFO << "Load " << yaml_path << " failed! please check!";
        return false;
    }

    for(int i=0; i<9; i++){
        camera_homo_to_main(i) = node["homography_matrix"]["data"][i].as<float>();
    }
    return true;
}


bool HomoProject::Exec(){
    auto ptr = std::dynamic_pointer_cast<ios::Detection2Ds>(interfaces::GetIOPtr(inputNames[0]));
    if (ptr == nullptr){
        LOG_ERROR << "HomoProject input " << inputNames[0] << " haven't been init or doesn't exist.";
        return false;
    }

    auto projected_dets = std::make_shared<ios::Detection2Ds>(ios::Detection2Ds());
    Eigen::Matrix<float, 3, 2, Eigen::RowMajor> default_box, pbox;
    default_box(4) = 1;
    default_box(5) = 1;
    for(auto& obj: ptr->detections){
        ios::Det2DPtr projected_obj = obj->copy();
        default_box(0) = obj->x1;
        default_box(1) = obj->x2;
        default_box(2) = obj->y1;
        default_box(3) = obj->y2;
        pbox = camera_homo_to_main * default_box;// projected to main space

        projected_obj->x1 = pbox(0);
        projected_obj->x2 = pbox(1);
        projected_obj->y1 = pbox(2);
        projected_obj->y2 = pbox(3);

        projected_dets->detections.push_back(projected_obj);
    }
    interfaces::SetIOPtr(outputNames[0], projected_dets);
    return true;
}


std::string HomoProject::Name() {
    return "HomoProject";
};


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous


