#ifndef WAYTOUS_DEEPINFER_BAYESIAN_FUSIONER_H_
#define WAYTOUS_DEEPINFER_BAYESIAN_FUSIONER_H_

#include <algorithm>
#include <map>
#include <string>

#include "interfaces/base_unit.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/detection.h"

namespace waytous{
namespace deepinfer{
namespace fusioner{

enum class BayesianFusionMatchMethod{
    IOU = 0,
    GIOU = 1,
    CIOU = 2,
    IOA = 3
};


class BayesianFusioner: public interfaces::BaseUnit{
public:
    std::map<std::string, BayesianFusionMatchMethod> MethodName2Type = {
        {"IOU", BayesianFusionMatchMethod::IOU},
        {"GIOU", BayesianFusionMatchMethod::GIOU},
        {"CIOU", BayesianFusionMatchMethod::CIOU},
        {"IOA", BayesianFusionMatchMethod::IOA}
    };

    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

    float Measure(ios::Det2DPtr obja, ios::Det2DPtr objb);


public:
    BayesianFusionMatchMethod matchMethod = BayesianFusionMatchMethod::IOU;
    float NMSThreshold = 0.5;

};


DEEPINFER_REGISTER_UNIT(BayesianFusioner);


} //namespace fusioner
} //namspace deepinfer
} //namespace waytous

#endif

