#include "interfaces/base_unit.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {

bool BaseUnit::Init(YAML::Node& node, YAML::Node& globalParamNode){
    inputNames = node["inputNames"].as<std::vector<std::string>>();
    outputNames = node["outputNames"].as<std::vector<std::string>>();
    inferBatchSize = globalParamNode["inferBatchSize"].as<int>(); // default=1
    inputHeight = globalParamNode["inputHeight"].as<int>();
    inputWidth = globalParamNode["inputWidth"].as<int>();
    fixAspectRatio = globalParamNode["fixAspectRatio"].as<bool>();
    return true;
};

}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous

