
#include <vector>
#include <chrono>
#include <opencv2/opencv.hpp>

#if CV_VERSION_MAJOR == 4
#define CV_FOURCC cv::VideoWriter::fourcc
#endif

#include <glog/logging.h>
#include "interfaces/base_task.h"

using namespace waytous::deepinfer;

std::vector<std::string> stringSplit(const std::string& str, char delim) {
    std::stringstream ss(str);
    std::string item;
    std::vector<std::string> elems;
    while (std::getline(ss, item, delim)) {
        if (!item.empty()) {
            elems.push_back(item);
        }
    }
    return elems;
}

int main(int argc, char** argv){
    // google::InitGoogleLogging("INFO");
    if(argc < 6){
        printf("wrong args.");
        printf("use like ./main task video/image configpath src dst.");
        return 0;
    }
    std::string taskName = argv[1];
    std::string videoOrImage = argv[2];
    std::string configPath = argv[3];
    std::string srcPath = argv[4];
    std::string savePath = argv[5];
    auto t = interfaces::BaseTaskRegisterer::GetInstanceByName(taskName);
    t->Init(configPath);
    printf("Init all Done\n");

    auto paths = stringSplit(srcPath, ',');
    auto savePaths = stringSplit(savePath, ',');

    std::vector<cv::Mat*> inputs;
    std::vector<interfaces::BaseIOPtr> outputs;
    if( videoOrImage == "image"){
        std::vector<cv::Mat> images;
        images.resize(paths.size());

        for(int i=0; i<paths.size(); i++){
            auto p = paths[i];
            std::cout << " load image: "<< p << std::endl;
            images[i] = cv::imread(p);
            inputs.push_back(&images[i]);
        }
        std::cout << "before infer." << std::endl;
        auto e1 = std::chrono::system_clock::now();
        for(int i=0; i<100; i++){
            outputs.clear();
            t->Exec(inputs, outputs);
        }
        auto e2 = std::chrono::system_clock::now();
        std::cout << "100 times avg infer time: " <<
            std::chrono::duration_cast<std::chrono::microseconds>(e2 - e1).count() / 1000. / 100. << " ms" << std::endl;
        for(int i=0; i<inputs.size(); i++){
            cv::Mat vis = images[i];
            t->Visualize(&vis, outputs[i]);
            cv::imwrite(savePaths[i], vis);
        }
            
    }else if(videoOrImage == "video"){
        cv::VideoCapture cap(srcPath);
        int img_height = cap.get(cv::CAP_PROP_FRAME_HEIGHT);
        int img_width = cap.get(cv::CAP_PROP_FRAME_WIDTH);
        cv::VideoWriter writer(savePath, CV_FOURCC('M', 'J', 'P', 'G'), 25, cv::Size(img_width, img_height));
        cv::Mat img;
        while (true)
        {
            inputs.clear();
            outputs.clear();
            if(!cap.read(img)){
                break;
            };
            inputs.push_back(&img);
            t->Exec(inputs, outputs);
            cv::Mat vis_img = img.clone();
            t->Visualize(&vis_img, outputs[0]);
            writer.write(vis_img);
        }
        cap.release();
        writer.release();
    }

    return 1;
}











