
#include "tasks/task_detect.h"

namespace waytous{
namespace deepinfer{
namespace task{


bool TaskDetect::Init(std::string& taskConfigPath){
    if(!interfaces::BaseTask::Init(taskConfigPath)){
        LOG_ERROR << "Init task detect error";
        return false;
    };
    std::string detectorName = taskNode["detectorName"].as<std::string>();
    std::string detectorConfigPath = taskNode["detectorConfigPath"].as<std::string>();

    detector.reset(interfaces::BaseModelRegisterer::GetInstanceByName(detectorName));
    if(!detector->Init(detectorConfigPath)){
        LOG_ERROR << detectorName << " detector init problem";
        return false;
    };
}


bool TaskDetect::Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs){
    detector->Exec(inputs, outputs);
}


void TaskDetect::Visualize(cv::Mat* image, interfaces::BaseIOPtr outs){
    auto detections = std::dynamic_pointer_cast<ios::Detection2Ds>(outs)->detections;
    for(auto &obj : detections){
        cv::Scalar color = get_color(obj->class_label);
        cv::rectangle(*image, cv::Rect(obj->x1, obj->y1, obj->x2 - obj->x1, obj->y2 - obj->y1), color, 2);
        cv::putText(*image, common::formatValue(obj->confidence, 2) + ":" + 
                    std::to_string(obj->track_id) + "." + obj->class_name, 
                    cv::Point(obj->x1, obj->y1 - 5), cv::FONT_HERSHEY_SIMPLEX, 0.5, color, 1);
    }
}


std::string TaskDetect::Name(){
    return "TaskDetect";
}

DEEPINFER_REGISTER_TASKS(TaskDetect);

} //namespace task
} //namspace deepinfer
} //namespace waytous









