
#include "models/camera_model.h"

namespace waytous {
namespace deepinfer {
namespace camera {

bool CameraModel::Init(std::string& configPath) {
    // CUDA_CHECK(cudaStreamCreate(&stream_));
    std::string cfgPath = common::GetAbsolutePath(common::ConfigRoot::GetRootPath(), configPath);
    if(!common::PathExists(cfgPath)){
        LOG_WARN << "config_file "<< common::ConfigRoot::GetRootPath() << " " << cfgPath << " not exist.";
        return false;
    }
    modelConfigNode = YAML::LoadFile(cfgPath);
    if (modelConfigNode.IsNull()) {
        LOG_WARN << "Load " << configPath << " failed! please check!";
        return false;
    }
    inputNames = modelConfigNode.as<std::vector<std::string>>("inputNames");
    outputNames = modelConfigNode.as<std::vector<std::string>>("outputNames");
    auto globalParamNode = modelConfigNode["globalParams"];

    // units
    auto unitNodes = modelConfigNode["units"];
    for(int i=0; i<unitNodes.size(); i++){
        auto unitNode = unitNodes[i];
        std::string unitName = unitNode["name"].as<std::string>();
        interfaces::BaseUnitPtr unitPtr = std::make_shared<interfaces::BaseUnit>(interfaces::BaseUnitRegisterer::GetInstanceByName(unitName));
        if(!unitPtr->Init(unitNode, globalParamNode)){
            LOG_WARN << "Init unit " << unitName << " failed!";
            return false;
        };
        units_.push_back(unitPtr);
    }
    return true;
}


bool CameraModel::Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs){
    // set source
    for (int i=0; i<inputs.size(); i++){
        auto input_img = inputs[i];
        auto inputName = inputNames[i];
        auto input = std::make_shared<ios::CameraSrcIn>(ios::CameraSrcIn(input_img));
        interfaces::SetIOPtr(inputName, input);
    }
    // infer
    for(auto unit: units_){
        unit->Exec();
    }

    // output
    for(auto outName: outputNames){
        outputs.push_back(interfaces::GetIOPtr(outName));
    }

    return true;
}


bool CameraModel::Exec(std::vector<base::Image8UPtr> inputs, std::vector<interfaces::BaseIOPtr>& outputs){
    // set source
    for (int i=0; i<inputs.size(); i++){
        auto input_img = inputs[i];
        auto inputName = inputNames[i];
        auto input = std::make_shared<ios::CameraSrcOut>(ios::CameraSrcOut(input_img));
        interfaces::SetIOPtr(inputName, input);
    }
    // infer
    for(auto unit: units_){
        unit->Exec();
    }

    // output
    for(auto outName: outputNames){
        outputs.push_back(interfaces::GetIOPtr(outName));
    }
    return true;
}


std::string CameraModel::Name(){
    return "CameraModel";
}


DEEPINFER_REGISTER_MODELS(CameraModel);

}  // namespace camera
}  // namespace deepinfer
}  // namespace waytous


