
#ifndef DEEPINFER_POSTPROCESS_YOLOV5_H_
#define DEEPINFER_POSTPROCESS_YOLOV5_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/ios/detection.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class YoloV5PostProcess: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

public:
    int keepTopK = 100;
    float scoreThreshold, truncatedThreshold;
    std::vector<std::string> classNames;

};


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif



