
#ifndef DEEPINFER_POSTPROCESS_TRDES_H_
#define DEEPINFER_POSTPROCESS_TRDES_H_

#include <cuda_runtime.h>
#include <cstdint>

#include "interfaces/base_unit.h"
#include "base/image.h"

#include "libs/ios/normal_ios.h"
#include "libs/ios/camera_ios.h"
#include "libs/ios/detection.h"

namespace waytous {
namespace deepinfer {
namespace postprocess {


class TraDesPostProcess: public interfaces::BaseUnit{

public:
    bool Init(YAML::Node& node, YAML::Node& globalParamNode) override;

    bool Exec() override;

    std::string Name() override;

protected:
    void trades_postprocess(const float *hm, const float *reg, const float *wh, const float* seg_weights, const float* seg_feat, 
        int* output_length, float *output_bboxes, int* output_mask_cnt_lengths, int* output_mask_cnts, const int topK, const int max_cnts_length, 
        const int w, const int h, const int number_classes, const int kernerl_size,  const int seg_dims, const float score_threshold);

public:
    base::BlobPtr<int> output_length_ptr;
    base::BlobPtr<float> bboxes_ptr;
    base::BlobPtr<int> maskCnts_lengths_ptr;
    base::BlobPtr<int> maskCnts_ptr;

    float scoreThreshold, truncatedThreshold;
    int classNumber;
    std::vector<std::string> classNames;
    int topK = 100;
    int downScale = 4;
    int segDims = 64;
    int maxCntsLength = 500;
};


}  // namespace postprocess
}  // namespace deepinfer
}  // namespace waytous

#endif















