
#ifndef DEEPINFER_DETECTION_H_
#define DEEPINFER_DETECTION_H_

#include <vector>
#include <string>

#include "common/common.h"
#include "interfaces/base_io.h"
#include "libs/ios/instance_mask.h"


namespace waytous {
namespace deepinfer {
namespace ios {


class Det{
public:
    Det() = default;
    virtual ~Det() = default;
};
using DetPtr = std::shared_ptr<Det>;


class Det2D : public Det{

public:
    void validCoordinate();
    Det2DPtr copy();
    void update(Det2DPtr obj_);
    void update(std::vector<float>& tlbr);

public:
    float image_width = 0, image_height = 0;
    float x1, y1, x2, y2;
    float confidence;
    int class_label;
    std::string class_name;
    bool truncated = false;
    InstanceMaskPtr mask_ptr = nullptr;
    int track_id = -1;
};
using Det2DPtr = std::shared_ptr<Det2D>;



class Detection2Ds: public interfaces::BaseIO{

public:
    std::vector<Det2DPtr> detections;
};
using Detection2DsPtr = std::shared_ptr<Detection2Ds>;

}  // namespace ios
}  // namespace deepinfer
}  // namespace waytous

#endif
