
#include "libs/ios/detection.h"

namespace waytous {
namespace deepinfer {
namespace ios {

void Det2D::validCoordinate(){
    x1 = iMIN(image_width - 1, iMAX(0, x1));
    x2 = iMIN(image_width - 1, iMAX(0, x2));
    y1 = iMIN(image_height - 1, iMAX(0, y1));
    y2 = iMIN(image_height - 1, iMAX(0, y2));
}


Det2DPtr Det2D::copy(){
    Det2DPtr obj = std::make_shared<Det2D>(Det2D());
    obj->x1 = this->x1;
    obj->x2 = this->x2;
    obj->y1 = this->y1;
    obj->y2 = this->y2;
    obj->confidence = this->confidence;
    obj->class_label = this->class_label;
    obj->class_name = this->class_name;
    obj->truncated = this->truncated;
    obj->track_id = this->track_id;
    if (obj->mask_ptr != nullptr){
        obj->mask_ptr.reset(new InstanceMask(this->mask_ptr.get()));
    }
}

void Det2D::update(Det2DPtr obj_){
    this->x1 = obj_->x1;
    this->x2 = obj_->x2;
    this->y1 = obj_->y1;
    this->y2 = obj_->y2;
    this->confidence = obj_->confidence;
    this->class_label = obj_->class_label;
    this->class_name = obj_->class_name;
    this->truncated = obj_->truncated;
    this->track_id = obj_->track_id;
    if (this->mask_ptr != nullptr){
        this->mask_ptr->update(obj_->mask_ptr.get());
    }
};


void Det2D::update(std::vector<float>& tlbr){
    this->x1 = tlbr[0];
    this->y1 = tlbr[1];
    this->x2 = tlbr[2];
    this->y2 = tlbr[3];
};

}  // namespace ios
}  // namespace deepinfer
}  // namespace waytous







