#ifndef WAYTOUS_DEEPINFER_INFERENCE_TRT_CALIBRATOR_H_
#define WAYTOUS_DEEPINFER_INFERENCE_TRT_CALIBRATOR_H_
#pragma once

#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <iterator>
#include <opencv2/opencv.hpp>

#include "NvInfer.h"
#include "cuda.h"
#include "cuda_runtime.h"

#include "common/log.h"
#include "common/file.h"
#include "libs/inferences/tensorrt/trt_utils.h"


namespace waytous {
namespace deepinfer {
namespace inference {


void resizeImageCPU(cv::Mat& img, float* hostImage, int inputWidth, int inputHeight,
    const float* inputMean, const float* inputStd, bool fixAspect, bool bgr);


class int8EntroyCalibrator : public nvinfer1::IInt8EntropyCalibrator {
public:
    int8EntroyCalibrator(const std::string &imgPath_, const std::string &calibTablePath_, 
        int batchSize_, int inputWidth_, int inputHeight_, std::vector<float>& inputMean_, 
        std::vector<float>& inputStd_, bool useBGR_, bool fixAspectRatio_);

    ~int8EntroyCalibrator();

    int getBatchSize() const override;

    bool getBatch(void *bindings[], const char *names[], int nbBindings) override;

    const void *readCalibrationCache(std::size_t &length) override;

    void writeCalibrationCache(const void *cache, std::size_t length) override;

private:
    int batchSize, inputWidth, inputHeight;
    float inputMean[3], inputStd[3];
    size_t inputCount;
    size_t imageIndex;
    bool useBGR = false;
    bool fixAspectRatio = true;

    std::string calibTablePath;
    std::vector<std::string> imgPaths;

    float *batchData = nullptr;
    void  *deviceInput = nullptr;

    bool readCache;
    std::vector<char> calibrationCache;
};


}  // namespace inference
}  // namespace deepinfer
}  // namespace waytous

#endif
