#include "interfaces/base_unit.h"

namespace waytous {
namespace deepinfer {
namespace interfaces {

bool BaseUnit::Init(YAML::Node& node, YAML::Node& globalParamNode){
    inputNames = node.as<std::vector<std::string>>("inputNames");
    outputNames = node.as<std::vector<std::string>>("outputNames");
    inferBatchSize = globalParamNode["inferBatchSize"].as<int>(); // default=1
    inputHeight = globalParamNode["inputHeight"].as<int>();
    inputWidth = globalParamNode["inputWidth"].as<int>();
    fixAspectRatio = globalParamNode["fixAspectRatio"].as<bool>();
    return true;
};

}  // namespace interfaces
}  // namespace deepinfer
}  // namespace waytous

