#ifndef WAYTOUS_DEEPINFER_TASK_H_
#define WAYTOUS_DEEPINFER_TASK_H_

#include <string>
#include <opencv2/opencv.hpp>
#include <yaml-cpp/yaml.h>

#include "common/register.h"
#include "interfaces/base_io.h"


namespace waytous{
namespace deepinfer{
namespace interfaces{


class BaseTask{
public:
    BaseTask() = default;
    virtual ~BaseTask() = default;

    virtual bool Init(std::string& taskConfigPath);

    // camera image
    virtual bool Exec(std::vector<cv::Mat*> inputs, std::vector<interfaces::BaseIOPtr>& outputs);
    virtual void Visualize(cv::Mat* image, interfaces::BaseIOPtr outs) = 0;

    virtual cv::Scalar get_color(int idx);

    virtual std::string Name(){
        return "BaseTask";
    }

public:
    YAML::Node taskNode;

};

DEEPINFER_REGISTER_REGISTERER(BaseTask);
#define DEEPINFER_REGISTER_TASKS(name) \
  DEEPINFER_REGISTER_CLASS(BaseTask, name)

} //namespace interfaces
} //namspace deepinfer
} //namespace waytous


#endif
