
#include "common/file.h"


namespace waytous{
namespace deepinfer{
namespace common{

std::shared_ptr<ConfigRoot> ConfigRoot::instance = nullptr;

const std::string ConfigRoot::GetRootPath(){
    if(instance == nullptr){
        SetRootPath("");
        LOG_WARN << "Haven't init config root, use default ''.";
    }
    return instance->rootPath;
}


void ConfigRoot::SetRootPath(const std::string path){
    if(instance == nullptr){
        instance.reset(new ConfigRoot());
    }
    instance->rootPath = path;
}


} //namespace common
} //namspace deepinfer
} //namespace waytous



