/**
 *  Copyright (C) 2021 - Innovusion Inc.
 *
 *  All Rights Reserved.
 *
 *  $Id$
 */

#ifndef SDK_COMMON_INNO_FAULTS_FALCON_H_
#define SDK_COMMON_INNO_FAULTS_FALCON_H_

/*falcon fault list*/
enum InnoLidarInFault {
  INNO_LIDAR_IN_FAULT_OTHER = 0,  // reserved
  INNO_LIDAR_IN_FAULT_POWER_LOW = 1,
  INNO_LIDAR_IN_FAULT_POWER_HIGH = 2,
  INNO_LIDAR_IN_FAULT_WINDOW_BLOCKAGE1 = 3,  // mud 1
  INNO_LIDAR_IN_FAULT_WINDOW_BLOCKAGE2 = 4,  // mud 2
  INNO_LIDAR_IN_FAULT_WINDOW_BLOCKAGE3 = 5,  // reserved
  INNO_LIDAR_IN_FAULT_WINDOW_BLOCKAGE4 = 6,  // reserved
  INNO_LIDAR_IN_FAULT_LASER_INTERLOCK = 7,
  INNO_LIDAR_IN_FAULT_COMM_LASER = 8,
  INNO_LIDAR_IN_FAULT_LASER = 9,
  INNO_LIDAR_IN_FAULT_COMM_DSP = 10,
  INNO_LIDAR_IN_FAULT_CANFD_DSP = 11,  // reserved
  INNO_LIDAR_IN_FAULT_DSP = 12,        // reserved
  INNO_LIDAR_IN_FAULT_POLYGON_CONTROL = 13,
  INNO_LIDAR_IN_FAULT_POLYGON_SENSOR = 14,
  INNO_LIDAR_IN_FAULT_GALVO_CONTROL = 15,
  INNO_LIDAR_IN_FAULT_GALVO_SENSOR = 16,
  INNO_LIDAR_IN_FAULT_OPTIC1 = 17,
  INNO_LIDAR_IN_FAULT_OPTIC2 = 18,
  INNO_LIDAR_IN_FAULT_IIC_DSP = 19,    // reserved
  INNO_LIDAR_IN_FAULT_IIC_SOC = 20,    // reserved
  INNO_LIDAR_IN_FAULT_DSP_EXTWD = 21,  // reserved
  INNO_LIDAR_IN_FAULT_DBTEMP = 22,
  INNO_LIDAR_IN_FAULT_CHIPTEMP = 23,   // reserved
  INNO_LIDAR_IN_FAULT_HUMIDITY = 24,   // reserved
  INNO_LIDAR_IN_FAULT_COMM_ADC = 25,   // reserved
  INNO_LIDAR_IN_FAULT_FPGACLOCK = 26,  // reserved
  INNO_LIDAR_IN_FAULT_SOC = 27,        // reserved
  INNO_LIDAR_IN_FAULT_SOC_EXTWD = 28,
  INNO_LIDAR_IN_FAULT_RAWDATA_STREAM = 29,
  INNO_LIDAR_IN_FAULT_POLYGON_TO = 30,
  INNO_LIDAR_IN_FAULT_GALVO_TO = 31,
  INNO_LIDAR_IN_FAULT_TRIGGER_TO = 32,
  INNO_LIDAR_IN_FAULT_POWSUPL1 = 33,  // reserved
  INNO_LIDAR_IN_FAULT_POWSUPL2 = 34,
  INNO_LIDAR_IN_FAULT_LPDDR4 = 35,  // reserved
  INNO_LIDAR_IN_FAULT_FLASH = 36,   // reserved
  INNO_LIDAR_IN_FAULT_NETWORK1 = 37,
  INNO_LIDAR_IN_FAULT_NETWORK2 = 38,
  INNO_LIDAR_IN_FAULT_OVERHEAT1 = 39,  // reserved
  INNO_LIDAR_IN_FAULT_OVERHEAT2 = 40,  // reserved
  INNO_LIDAR_IN_FAULT_OVERHEAT3 = 41,  // have to stop
  INNO_LIDAR_IN_FAULT_CONFIG1 = 42,
  INNO_LIDAR_IN_FAULT_CONFIG2 = 43,
  INNO_LIDAR_IN_FAULT_ASSERT_FAILURE = 44,
  INNO_LIDAR_IN_FAULT_CPULOAD_HIGH = 45,
  INNO_LIDAR_IN_FAULT_LATENCY_LONG = 46,
  INNO_LIDAR_IN_FAULT_DATA_DROP4 = 47,  // used for stage_signal force job drop
  INNO_LIDAR_IN_FAULT_RAWDATA_TO = 48,
  INNO_LIDAR_IN_FAULT_EXCESSIVE_NOISE = 49,
  INNO_LIDAR_IN_FAULT_DATA_DROP1 = 50,
  INNO_LIDAR_IN_FAULT_DATA_DROP2 = 51,
  INNO_LIDAR_IN_FAULT_DATA_DROP3 = 52,
  INNO_LIDAR_TEMPHIGH_INHIBIT = 53,
  INNO_LIDAR_IN_FAULT_OPTIC1_F = 54,
  INNO_LIDAR_IN_FAULT_REFINTENSITY = 55,
  INNO_LIDAR_IN_FAULT_REPROGRAMMING = 56,  // reserved
  INNO_LIDAR_IN_FAULT_GALVO_MIRROR = 57,   // reserved
  INNO_LIDAR_IN_FAULT_MAX_DISTANCE = 58,   // reserved
  INNO_LIDAR_IN_FAULT_EXCESSIVE_BLOOMING = 59,
  INNO_LIDAR_IN_FAULT_OPTIC2_F = 60,
  INNO_LIDAR_IN_FAULT_RESERVED16 = 61,  // reserved
  INNO_LIDAR_IN_FAULT_OPTIC_FIBER = 62,
  INNO_LIDAR_IN_FAULT_RESERVED18 = 63,  // reserved
  // below are extended faults
  INNO_LIDAR_IN_FAULT_MISALIGNMENT = 64,  // reserved
  // in Normal/Quiet/Calibration Mode
  // Sampling the polygon speed every 100ms for 10 times,
  // if the speed is greater, than 2400RPM, report this error
  INNO_LIDAR_IN_FAULT_COVEROPEN = 65,
  // For cases where the Encoder hardware is unreliable and signals
  // are being occasionally lost. we add a new fault:
  //          INNO_LIDAR_IN_FAULT_POLYGON_DRIVER
  // 1) DSP reads Polygon pre-driver chip fault information PD_nFAULT.
  // 2) 10ms sampling, sampling to PD_nFAULT=0, then DSP confirms Polygon
  //    pre-driver chip fault. . (Fault68, not in FIM mapping)
  INNO_LIDAR_IN_FAULT_POLYGON_DRIVER = 66,
  INNO_LIDAR_IN_FAULT_MULTI_HIGH_INT = 68,
  INNO_LIDAR_IN_FAULT_MAX
};

#endif  // SDK_COMMON_INNO_FAULTS_FALCON_H_
