# Introduction

Installation:

```
sudo apt-get update
sudo apt-get install -y  libyaml-cpp-dev
```

# Config params

please refer to [config.yaml](/src/seyond_lidar_ros/config/config.yaml), support multiple lidars input

# ROS Command Line Parameters

| Parameter | Default Value | description |
| --- | --- | --- |
| config_path | ""  | config_path, if use this param, other params will become invalid |
| log_level | info | limit log from lidar, can choose from (info warn error) |
| replay_rosbag | false | replay rosbag packet flag |
| packet_mode | false | packet mode enable |
| aggregate_num | 20  | aggregate packets num |
| frame_id | seyond | - |
| frame_topic | iv_points | - |
| packet_topic | iv_packets | - |
| lidar_name | seyond | lidar name |
| lidar_ip | 172.168.1.10 | - |
| port | 8010 | tcp port |
| udp_port | 8010 | udp port |
| reflectance_mode | true | 0:intensiy mode 1:reflectance mode |
| multiple_return | 1   | lidar detection echo mode |
| continue_live | false | fatal error encountered, restart driver |
| pcap_file | ""  | path of path playback pcapfile |
| hv_table_file | ""  | path of hv table file, only for generic lidar |
| packet_rate | 10000 | file playback rate, if value <= 100 :  value MB/s, if value  >  100 :  value / 10000 x|
| file_rewind | 0   | number of file replays 0:no rewind -1: unlimited times |
| max_range | 2000 | display point maximum distance |
| min_range | 0.4 | display point minimum distance |
| name_value_pairs | ""  | some settings of lidar are consistent with the usage of inno_pc_client |
| coordinate_mode | 3   | convert the xyz direction of a point cloud, x/y/z, 0:up/right/forward 3:forward/left/up |
| transform_enable | false | transform enable |
| x   | 0.0 | - |
| y   | 0.0 | - |
| z   | 0.0 | - |
| pitch | 0.0 | - |
| yaw | 0.0 | - |
| roll | 0.0 | - |
| transform_matrix | ""  | transform matrix string, if not empty, priority is higher than x/y/z/pitch/yaw/roll |

# Quick start

If you have your own ROS/ROS2 workspace, please refer to [ROS package build](src/seyond_lidar_ros/README.md)

**Compile**

```
source /opt/ros/<ROS_DISTRO>/setup.sh
./build.bash
```

**Run**

```
source install/setup.bash
roslaunch seyond start.launch
// or
ros2 launch seyond start.py
```

# Additional guides

[Create deb](doc/08_how_to_create_deb.md)

[Fuse multiple lidars](doc/07_how_to_fuse_multiple_lidars.md)
