include Makefile.am.libasncodec

LIBS += -lm
CFLAGS += $(ASN_MODULE_CFLAGS) -DASN_PDU_COLLECTION -I.
ASN_LIBRARY ?= libasncodec.a
ASN_PROGRAM ?= converter-example
ASN_PROGRAM_SRCS ?= \
	converter-example.c\
	pdu_collection.c

all: $(ASN_PROGRAM)

$(ASN_PROGRAM): $(ASN_LIBRARY) $(ASN_PROGRAM_SRCS:.c=.o)
	$(CC) $(CFLAGS) $(CPPFLAGS) -o $(ASN_PROGRAM) $(ASN_PROGRAM_SRCS:.c=.o) $(LDFLAGS) $(ASN_LIBRARY) $(LIBS)

$(ASN_LIBRARY): $(ASN_MODULE_SRCS:.c=.o)
	$(AR) rcs $@ $(ASN_MODULE_SRCS:.c=.o)

.SUFFIXES:
.SUFFIXES: .c .o

.c.o:
	$(CC) $(CFLAGS) -o $@ -c $<

clean:
	rm -f $(ASN_PROGRAM) $(ASN_LIBRARY)
	rm -f $(ASN_MODULE_SRCS:.c=.o) $(ASN_PROGRAM_SRCS:.c=.o)

regen: regenerate-from-asn1-source

regenerate-from-asn1-source:
	/home/wangsiyuan/work/wangsiyuan/asn1Demo/tool/bin/asn1c -S /home/wangsiyuan/work/wangsiyuan/asn1Demo/tool/share/asn1c /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehSize.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehBrake.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/DefPositionOffset.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehSafetyExt.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MapNode.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MapPoint.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MsgFrame.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/DefMotion.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/RSM.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MapLane.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/SignalPhaseAndTiming.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/DefAcceleration.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehClass.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehEmgExt.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/VehStatus.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/DefPosition.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MapSpeedLimit.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/DefTime.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/SPATIntersectionState.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/Map.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/RSI.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/BSM.asn /home/wangsiyuan/work/wangsiyuan/asn1Demo/msgs/MapLink.asn

