/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.graphics.Point;
import android.hardware.CameraStatus;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Size;
import android.view.IWindowManager;
import com.mediatek.smartplatform.AvmCameraInfo;
import com.mediatek.smartplatform.CarEventProxy;
import com.mediatek.smartplatform.CollisionProxy;
import com.mediatek.smartplatform.ICarCamDeviceUser;
import com.mediatek.smartplatform.ISmartPlatformEventListener;
import com.mediatek.smartplatform.ISmartPlatformService;
import com.mediatek.smartplatform.IpodProxy;
import com.mediatek.smartplatform.SimpleCommand;
import com.mediatek.smartplatform.SpmCameraDevice;
import com.mediatek.smartplatform.SpmCameraDeviceImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class SmartPlatformManager {
    private static final String SMARTPLATFORM_SERVICE_BINDER_NAME = "mtk.smartplatform";
    private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
    private static final String WINDOW_SERVICE_BINDER_NAME = "window";
    private static final String TAG = "SmartPlatformManager";
    private static final boolean DEBUG = Build.IS_ENG || SystemProperties.getBoolean((String)"persist.vendor.log.spmsdk", (boolean)false);
    private IpodProxy mIpodProxy = null;
    private CollisionProxy mCollisionProxy = null;
    private CarEventProxy mCarEventProxy = null;
    private Object mLock = new Object();
    private Object mEventListenerLock = new Object();
    private Object mArrayMapLock = new Object();
    private Object mCameraServiceLock = new Object();
    private Object mServiceDiedLock = new Object();
    private Object mCameraDeviceLock = new Object();
    private Object mAvailableCallbackLock = new Object();
    private ISmartPlatformService mSmartPlatformService = null;
    private ICameraService mCameraService = null;
    private IWindowManager mWindowManager = null;
    public static final boolean sCameraServiceDisabled = SystemProperties.getBoolean((String)"config.disable_cameraservice", (boolean)false);
    private final ArraySet<ServiceDeathCallback> mServiceDeathCallbacks = new ArraySet();
    private final ArraySet<CameraAvailableCallback> mAvailableCallbacks = new ArraySet();
    private final ArrayMap<String, SpmCameraDevice> mCameraDevices = new ArrayMap();
    private final ArrayMap<SpmCameraDevice, CameraDeviceRefCount> mCameraDevicesRefMap = new ArrayMap();
    private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();
    public static final int EVENT_TEST = 100;
    private final CameraManager mCameraManager = new CameraManager(null);
    private static final SmartPlatformManager gSmartPlatformManager = new SmartPlatformManager();
    private ISmartPlatformEventListener mEventListener = new ISmartPlatformEventListener.Stub(){
        public static final int EVENT_CAR_REVERSE = 1;
        public static final int EVENT_COLLISION = 2;
        public static final int EVENT_CAR_ENGINE_CHANGED = 3;
        public static final int EVENT_CAR_CUSTOMIZATION1 = 1000;
        public static final int EVENT_CAR_CUSTOMIZATION2 = 2000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEventChanged(int event, int arg1, int arg2) throws RemoteException {
            if (DEBUG) {
                Log.i((String)SmartPlatformManager.TAG, (String)("onEventChanged: event" + event + "  arg1 = " + arg1 + "   arg2 =" + arg2));
            }
            Object object = SmartPlatformManager.this.mEventListenerLock;
            synchronized (object) {
                switch (event) {
                    case 100: {
                        break;
                    }
                    case 2: {
                        if (SmartPlatformManager.this.mCollisionProxy == null) break;
                        SmartPlatformManager.this.mCollisionProxy.onCollison(arg1, arg2);
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 1000: 
                    case 2000: {
                        if (SmartPlatformManager.this.mCarEventProxy == null) break;
                        SmartPlatformManager.this.mCarEventProxy.handEvent(event, arg1, arg2);
                        break;
                    }
                }
            }
        }
    };
    private ICameraServiceListener mCameraListener = new ICameraServiceListener.Stub(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = SmartPlatformManager.this.mCameraServiceLock;
            synchronized (object) {
                SmartPlatformManager.this.onStatusChangedLocked(status, cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTorchStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = SmartPlatformManager.this.mCameraServiceLock;
            synchronized (object) {
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCameraAccessPrioritiesChanged() throws RemoteException {
            Object object = SmartPlatformManager.this.mCameraServiceLock;
            synchronized (object) {
            }
        }
    };
    private HandlerThread mEventThread = null;
    private SpmEventHandler mEventHandler = null;
    static final int EVENT_DEVICE_DISCONNECTED = 1;
    public static final int DEVICE_TYPE_COMMON = 1;
    public static final int DEVICE_TYPE_POWERKEY_BY_ACC = 2;
    public static final int DEVICE_TYPE_VCDT = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onStatusChangedLocked(int status, String id) {
        if (DEBUG) {
            Log.v((String)TAG, (String)String.format("Camera id %s has status changed to 0x%x", id, status));
        }
        if (!this.validStatus(status)) {
            Log.e((String)TAG, (String)String.format("Ignoring invalid device %s status 0x%x", id, status));
            return;
        }
        Integer oldStatus = (Integer)this.mDeviceStatus.put((Object)id, (Object)status);
        if (oldStatus != null && oldStatus == status) {
            if (DEBUG) {
                Log.v((String)TAG, (String)String.format("Device status changed to 0x%x, which is what it already was", status));
            }
            return;
        }
        Log.i((String)TAG, (String)String.format("Camera id %s: oldStatus 0x%x changed to status 0x%x", id, oldStatus, status));
        Object object = this.mAvailableCallbackLock;
        synchronized (object) {
            for (CameraAvailableCallback callback : this.mAvailableCallbacks) {
                if (callback == null) continue;
                callback.onAvailable(id, status);
            }
        }
    }

    private boolean validStatus(int status) {
        switch (status) {
            case -2: 
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private SmartPlatformManager() {
        this.getSmartPlatformService();
        this.getCameraService();
    }

    public static SmartPlatformManager get() {
        return gSmartPlatformManager;
    }

    private ISmartPlatformService getSmartPlatformService() {
        if (this.mSmartPlatformService == null) {
            Log.i((String)TAG, (String)"mSmartPlatformService is null, try to get it");
            IBinder smartPlatformServiceBinder = ServiceManager.getService((String)SMARTPLATFORM_SERVICE_BINDER_NAME);
            if (smartPlatformServiceBinder == null) {
                Log.e((String)TAG, (String)"mtk.smartplatform is null");
                return null;
            }
            try {
                smartPlatformServiceBinder.linkToDeath((IBinder.DeathRecipient)new DeathNotifer(SMARTPLATFORM_SERVICE_BINDER_NAME), 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.mSmartPlatformService = ISmartPlatformService.Stub.asInterface(smartPlatformServiceBinder);
            try {
                this.mSmartPlatformService.addListener(this.mEventListener);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return this.mSmartPlatformService;
    }

    private IWindowManager getWindowManagerService() {
        if (this.mWindowManager == null) {
            Log.i((String)TAG, (String)"mWindowManager is null, try to get it");
            IBinder windowServiceBinder = ServiceManager.getService((String)WINDOW_SERVICE_BINDER_NAME);
            if (windowServiceBinder == null) {
                Log.e((String)TAG, (String)"window is null");
                return null;
            }
            try {
                windowServiceBinder.linkToDeath((IBinder.DeathRecipient)new DeathNotifer(WINDOW_SERVICE_BINDER_NAME), 0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            this.mWindowManager = IWindowManager.Stub.asInterface((IBinder)windowServiceBinder);
        }
        return this.mWindowManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICameraService getCameraService() {
        Object object = this.mLock;
        synchronized (object) {
            this.connectCameraServiceLocked();
            if (this.mCameraService == null && !sCameraServiceDisabled) {
                Log.e((String)TAG, (String)"Camera service is unavailable");
            }
            return this.mCameraService;
        }
    }

    private void connectCameraServiceLocked() {
        if (this.mCameraService != null || sCameraServiceDisabled) {
            return;
        }
        Log.i((String)TAG, (String)"Connecting to camera service");
        IBinder cameraServiceBinder = ServiceManager.getService((String)CAMERA_SERVICE_BINDER_NAME);
        if (cameraServiceBinder == null) {
            return;
        }
        try {
            cameraServiceBinder.linkToDeath((IBinder.DeathRecipient)new DeathNotifer(CAMERA_SERVICE_BINDER_NAME), 0);
        }
        catch (RemoteException e) {
            return;
        }
        ICameraService cameraService = ICameraService.Stub.asInterface((IBinder)cameraServiceBinder);
        try {
            CameraMetadataNative.setupGlobalVendorTagDescriptor();
        }
        catch (ServiceSpecificException e) {
            Log.i((String)TAG, (String)" set global vendor tag failed");
            return;
        }
        try {
            CameraStatus[] cameraStatuses;
            for (CameraStatus c : cameraStatuses = this.getSmartPlatformService().addCameraListener(this.mCameraListener)) {
                this.onStatusChangedLocked(c.status, c.cameraId);
            }
            this.mCameraService = cameraService;
        }
        catch (ServiceSpecificException e) {
            throw new IllegalStateException("Failed to register a camera service listener", e);
        }
        catch (RemoteException e) {
            Log.w((String)TAG, (String)"Connecting to camera service error occurred");
        }
    }

    public boolean isServiceAlive() {
        return this.getSmartPlatformService() != null && this.getCameraService() != null;
    }

    public boolean isSmartPlatformServiceAlive() {
        return this.getSmartPlatformService() != null;
    }

    private Size getDisplaySize() {
        Size ret = new Size(0, 0);
        try {
            IWindowManager windowManager = this.getWindowManagerService();
            Point initialSize = new Point();
            windowManager.getInitialDisplaySize(0, initialSize);
            int width = initialSize.x;
            int height = initialSize.y;
            if (height > width) {
                int temp = height;
                height = width;
                width = temp;
            }
            ret = new Size(width, height);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("getDisplaySize Failed. " + e.toString()));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraCharacteristics getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.getSmartPlatformService() == null) {
                    Log.e((String)TAG, (String)"Smartplatform Service is not alive");
                    return null;
                }
                CameraMetadataNative info = this.getSmartPlatformService().getCameraCharacteristics(cameraId);
                Size displaySize = this.getDisplaySize();
                try {
                    info.setCameraId(Integer.parseInt(cameraId));
                }
                catch (NumberFormatException e) {
                    Log.e((String)TAG, (String)("Failed to parse camera Id " + cameraId + " to integer"));
                }
                info.setDisplaySize(displaySize);
                characteristics = new CameraCharacteristics(info);
            }
            catch (ServiceSpecificException info) {
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return characteristics;
    }

    public int getNumberOfCameras() {
        String[] ids = this.getCameraIdList();
        if (ids != null) {
            return ids.length;
        }
        return -1;
    }

    public String getAvmCameraId() {
        try {
            String cameraId = this.getSmartPlatformService().getAvmCameraId();
            Log.i((String)TAG, (String)("get avm camera id: " + cameraId));
            return cameraId;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getCameraIdList() {
        String[] cameraIds = null;
        Object object = this.mLock;
        synchronized (object) {
            this.connectCameraServiceLocked();
            int idCount = 0;
            cameraIds = new String[this.mDeviceStatus.size()];
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                cameraIds[idCount] = (String)this.mDeviceStatus.keyAt(i);
                ++idCount;
            }
        }
        Arrays.sort(cameraIds, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int s1Int = 0;
                int s2Int = 0;
                try {
                    s1Int = Integer.parseInt(s1);
                }
                catch (NumberFormatException e) {
                    s1Int = -1;
                }
                try {
                    s2Int = Integer.parseInt(s2);
                }
                catch (NumberFormatException e) {
                    s2Int = -1;
                }
                if (s1Int >= 0 && s2Int >= 0) {
                    return s1Int - s2Int;
                }
                if (s1Int >= 0) {
                    return -1;
                }
                if (s2Int >= 0) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        });
        return cameraIds;
    }

    public int getCameraStatus(String cameraId) {
        this.connectCameraServiceLocked();
        Integer ret = (Integer)this.mDeviceStatus.get((Object)cameraId);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServiceDeathCallback(ServiceDeathCallback callback) {
        Log.i((String)TAG, (String)"add Service Death Callback");
        Object object = this.mServiceDiedLock;
        synchronized (object) {
            if (callback != null) {
                this.mServiceDeathCallbacks.add((Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServiceDeathCallback(ServiceDeathCallback callback) {
        Log.i((String)TAG, (String)"remove Service Death Callback");
        Object object = this.mServiceDiedLock;
        synchronized (object) {
            if (callback != null) {
                this.mServiceDeathCallbacks.remove((Object)callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCameraAvailableCallback(CameraAvailableCallback callback) {
        Log.i((String)TAG, (String)("cyt, addCameraAvailableCallback: " + callback));
        Object object = this.mAvailableCallbackLock;
        synchronized (object) {
            if (callback != null) {
                this.mAvailableCallbacks.add((Object)callback);
                for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                    callback.onAvailable((String)this.mDeviceStatus.keyAt(i), (Integer)this.mDeviceStatus.valueAt(i));
                }
                Log.i((String)TAG, (String)("camera status: " + this.mDeviceStatus.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCameraAvailableCallback(CameraAvailableCallback callback) {
        Object object = this.mAvailableCallbackLock;
        synchronized (object) {
            this.mAvailableCallbacks.remove((Object)callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int notifyCameraDeviceError(int error, SpmCameraDevice cameraDevice) {
        Log.i((String)TAG, (String)("Camera [" + cameraDevice.getCameraId() + "] Error: " + error));
        int ret = 0;
        Object object = this.mServiceDiedLock;
        synchronized (object) {
            for (ServiceDeathCallback callback : this.mServiceDeathCallbacks) {
                if (callback == null) continue;
                callback.onDeath(0, "SpmCameraDevice");
                ++ret;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpmCameraDevice openCameraDevice(String cameraIdStr) {
        Object object = this.mCameraDeviceLock;
        synchronized (object) {
            CameraDeviceRefCount crc;
            SpmCameraDevice device;
            if (DEBUG) {
                Log.d((String)TAG, (String)("openCameraDevice cameraId : " + cameraIdStr), (Throwable)new Throwable("here"));
            } else {
                Log.i((String)TAG, (String)("openCameraDevice cameraId : " + cameraIdStr));
            }
            if (this.mEventHandler == null) {
                this.mEventThread = new HandlerThread("SmartPlatformManagerSmartPlatformManager");
                this.mEventThread.start();
                this.mEventHandler = new SpmEventHandler(this, this.mEventThread.getLooper());
            }
            int cameraId = Integer.parseInt(cameraIdStr);
            int mNumberOfCameras = this.getNumberOfCameras();
            if (!this.isServiceAlive()) {
                Log.e((String)TAG, (String)"Camera or Smartplatform Service is not alive");
                return null;
            }
            if (this.mCameraDevices.indexOfKey((Object)cameraIdStr) < 0) {
                Log.i((String)TAG, (String)"new a SpmCameraDevice");
                SpmCameraDeviceImpl deviceImpl = new SpmCameraDeviceImpl(gSmartPlatformManager, this.mEventHandler, cameraIdStr);
                try {
                    ICarCamDeviceUser remoteDevice = this.getSmartPlatformService().connectDevice(cameraIdStr);
                    deviceImpl.setRemoteDevice(remoteDevice);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                int ret = deviceImpl.openCamera();
                if (ret != 0) {
                    Log.e((String)TAG, (String)"Camera open failed.");
                    SpmCameraDevice device2 = null;
                    return device2;
                }
                device = deviceImpl;
                crc = new CameraDeviceRefCount(0);
                Object object2 = this.mArrayMapLock;
                synchronized (object2) {
                    this.mCameraDevices.put((Object)cameraIdStr, (Object)device);
                    this.mCameraDevicesRefMap.put((Object)device, (Object)crc);
                }
            }
            device = (SpmCameraDevice)this.mCameraDevices.get((Object)cameraIdStr);
            crc = (CameraDeviceRefCount)this.mCameraDevicesRefMap.get((Object)device);
            ++crc.refCout;
            if (DEBUG) {
                Log.d((String)TAG, (String)("cameraId : " + cameraIdStr + "  refCount : " + crc.refCout));
            }
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpmCameraDevice openAvmCameraDevice() {
        Object object = this.mCameraDeviceLock;
        synchronized (object) {
            CameraDeviceRefCount crc;
            SpmCameraDevice device;
            String cameraIdStr = this.getAvmCameraId();
            if (DEBUG) {
                Log.d((String)TAG, (String)("openAvmCameraDevice cameraId : " + cameraIdStr), (Throwable)new Throwable("here"));
            } else {
                Log.i((String)TAG, (String)("openAvmCameraDevice cameraId : " + cameraIdStr));
            }
            if (this.mEventHandler == null) {
                this.mEventThread = new HandlerThread("SmartPlatformManagerSmartPlatformManager");
                this.mEventThread.start();
                this.mEventHandler = new SpmEventHandler(this, this.mEventThread.getLooper());
            }
            int cameraId = Integer.parseInt(cameraIdStr);
            int mNumberOfCameras = this.getNumberOfCameras();
            if (this.getSmartPlatformService() == null) {
                Log.e((String)TAG, (String)"Smartplatform Service is not alive");
                return null;
            }
            if (this.mCameraDevices.indexOfKey((Object)cameraIdStr) < 0) {
                Log.i((String)TAG, (String)"new a SpmCameraDevice");
                SpmCameraDeviceImpl deviceImpl = new SpmCameraDeviceImpl(gSmartPlatformManager, this.mEventHandler, cameraIdStr);
                try {
                    ICarCamDeviceUser remoteDevice = this.getSmartPlatformService().connectAvmDevice(cameraIdStr);
                    deviceImpl.setRemoteDevice(remoteDevice);
                    deviceImpl.setAvmDeviceType();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                int ret = deviceImpl.openCamera();
                if (ret != 0) {
                    Log.e((String)TAG, (String)"Camera open failed.");
                    SpmCameraDevice device2 = null;
                    return device2;
                }
                device = deviceImpl;
                crc = new CameraDeviceRefCount(0);
                Object object2 = this.mArrayMapLock;
                synchronized (object2) {
                    this.mCameraDevices.put((Object)cameraIdStr, (Object)device);
                    this.mCameraDevicesRefMap.put((Object)device, (Object)crc);
                }
            }
            device = (SpmCameraDevice)this.mCameraDevices.get((Object)cameraIdStr);
            crc = (CameraDeviceRefCount)this.mCameraDevicesRefMap.get((Object)device);
            ++crc.refCout;
            if (DEBUG) {
                Log.d((String)TAG, (String)("cameraId : " + cameraIdStr + "  refCount : " + crc.refCout));
            }
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCameraDevice(SpmCameraDevice camera) {
        Object object = this.mCameraDeviceLock;
        synchronized (object) {
            if (DEBUG) {
                Log.d((String)TAG, (String)("close SpmCameraDevice camera : " + camera), (Throwable)new Throwable("here"));
            } else {
                Log.i((String)TAG, (String)("close SpmCameraDevice camera : " + camera));
            }
            if (!this.mCameraDevices.containsValue((Object)camera)) {
                Log.w((String)TAG, (String)"Already closed !!");
                return;
            }
            CameraDeviceRefCount crc = (CameraDeviceRefCount)this.mCameraDevicesRefMap.get((Object)camera);
            --crc.refCout;
            String cameraId = (String)this.mCameraDevices.keyAt(this.mCameraDevices.indexOfValue((Object)camera));
            if (DEBUG) {
                Log.d((String)TAG, (String)("camera: " + cameraId + " refCout:  " + crc.refCout));
            }
            if (crc.refCout == 0) {
                Log.i((String)TAG, (String)"release SpmCameraDevice ");
                camera.release();
                Object object2 = this.mArrayMapLock;
                synchronized (object2) {
                    this.mCameraDevices.removeAt(this.mCameraDevices.indexOfValue((Object)camera));
                    this.mCameraDevicesRefMap.remove((Object)camera);
                }
                camera = null;
                try {
                    if (this.isSmartPlatformServiceAlive()) {
                        this.getSmartPlatformService().disconnectDevice(cameraId);
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                if (this.mCameraDevices.size() == 0 && this.mEventThread != null) {
                    this.mEventThread.quitSafely();
                    this.mEventHandler = null;
                    this.mEventThread = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeCameraDevice(String cameraId) {
        Object object = this.mCameraDeviceLock;
        synchronized (object) {
            if (this.mCameraDevices.indexOfKey((Object)cameraId) < 0) {
                Log.w((String)TAG, (String)"Already closed !!");
                return;
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("close SpmCameraDevice cameraId : " + cameraId), (Throwable)new Throwable("here"));
            } else {
                Log.i((String)TAG, (String)("close SpmCameraDevice cameraId : " + cameraId));
            }
            SpmCameraDevice camera = (SpmCameraDevice)this.mCameraDevices.get((Object)cameraId);
            camera.release();
            Object object2 = this.mArrayMapLock;
            synchronized (object2) {
                this.mCameraDevices.remove((Object)cameraId);
                this.mCameraDevicesRefMap.remove((Object)camera);
            }
            camera = null;
            try {
                if (this.isSmartPlatformServiceAlive()) {
                    this.getSmartPlatformService().disconnectDevice(cameraId);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (this.mCameraDevices.size() == 0 && this.mEventThread != null) {
                this.mEventThread.quitSafely();
                this.mEventHandler = null;
                this.mEventThread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAvmCameraDevice() {
        Object object = this.mCameraDeviceLock;
        synchronized (object) {
            String cameraId = this.getAvmCameraId();
            if (this.mCameraDevices.indexOfKey((Object)cameraId) < 0) {
                Log.w((String)TAG, (String)"Already closed !!");
                return;
            }
            if (DEBUG) {
                Log.d((String)TAG, (String)("close SpmCameraDevice cameraId : " + cameraId), (Throwable)new Throwable("here"));
            } else {
                Log.i((String)TAG, (String)("close SpmCameraDevice cameraId : " + cameraId));
            }
            SpmCameraDevice camera = (SpmCameraDevice)this.mCameraDevices.get((Object)cameraId);
            camera.release();
            Object object2 = this.mArrayMapLock;
            synchronized (object2) {
                this.mCameraDevices.remove((Object)cameraId);
                this.mCameraDevicesRefMap.remove((Object)camera);
            }
            camera = null;
            try {
                if (this.isSmartPlatformServiceAlive()) {
                    this.getSmartPlatformService().disconnectAvmDevice();
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            if (this.mCameraDevices.size() == 0 && this.mEventThread != null) {
                this.mEventThread.quitSafely();
                this.mEventHandler = null;
                this.mEventThread = null;
            }
        }
    }

    public AvmCameraInfo getAvmCameraInfo() {
        AvmCameraInfo avmInfo = new AvmCameraInfo();
        try {
            List<String> avmInfoArray;
            if (this.isSmartPlatformServiceAlive() && (avmInfoArray = this.getSmartPlatformService().getAvmCameraInfo()) != null && avmInfoArray.size() >= 2) {
                String[] info = new String[avmInfoArray.size()];
                avmInfo.setWidth(Integer.parseInt(info[0]));
                avmInfo.setHeight(Integer.parseInt(info[1]));
                Log.i((String)TAG, (String)("get avm camera w x h : cameraId : " + info[0] + " x " + info[1]));
                return avmInfo;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return null;
    }

    public IpodProxy getIpodProxy() {
        this.mIpodProxy = IpodProxy.getInstance(gSmartPlatformManager);
        return this.mIpodProxy;
    }

    protected int postIpodCommand(String cmd, String params) {
        try {
            if (this.isSmartPlatformServiceAlive()) {
                return this.getSmartPlatformService().postIpodCommand(cmd, params);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public CarEventProxy getCarEventProxy() {
        this.mCarEventProxy = CarEventProxy.getInstance(gSmartPlatformManager);
        return this.mCarEventProxy;
    }

    protected void sendCareventCommand(SimpleCommand cmd) throws RemoteException {
        if (DEBUG) {
            Log.d((String)TAG, (String)("sendCareventCommand: " + cmd));
        }
        try {
            if (this.isSmartPlatformServiceAlive()) {
                this.getSmartPlatformService().sendCarCommand(cmd);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public CollisionProxy getCollisionProxy() {
        this.mCollisionProxy = CollisionProxy.getInstance(gSmartPlatformManager);
        return this.mCollisionProxy;
    }

    protected void sendCollisionCommand(SimpleCommand cmd) throws RemoteException {
        if (DEBUG) {
            Log.d((String)TAG, (String)("sendCollisionCommand: " + cmd));
        }
        try {
            if (this.isSmartPlatformServiceAlive()) {
                this.getSmartPlatformService().sendCollisionCommand(cmd);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public int[] getSupportedDeviceType() {
        int[] deviceTypeList = new int[]{1, 2, 3};
        return deviceTypeList;
    }

    public int getCurrentDeviceType() {
        String deviceType = SystemProperties.get((String)"ro.boot.devicetype");
        if (deviceType.equals("common")) {
            return 1;
        }
        if (deviceType.equals("sp_powerkey_by_acc")) {
            return 2;
        }
        if (deviceType.equals("sp_vcdt")) {
            return 3;
        }
        Log.w((String)TAG, (String)("Wrong device type: " + deviceType));
        return 1;
    }

    protected int setJpegHwEncState(int state) {
        int result = -1;
        try {
            result = this.getSmartPlatformService().setJpegHwEncState(state);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected int getJpegHwEncState() {
        int result = -1;
        try {
            if (this.isSmartPlatformServiceAlive()) {
                result = this.getSmartPlatformService().getJpegHwEncState();
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    public int setDeviceType(int deviceType) {
        int result = -1;
        try {
            if (this.isSmartPlatformServiceAlive()) {
                result = this.getSmartPlatformService().setDeviceType(deviceType);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void test() {
        if (DEBUG) {
            Log.d((String)TAG, (String)"test");
        }
        try {
            if (this.isSmartPlatformServiceAlive()) {
                this.getSmartPlatformService().sendCommand(100, -1, -1);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    private class SpmEventHandler
    extends Handler {
        private SmartPlatformManager mManager;

        public SpmEventHandler(SmartPlatformManager manager, Looper looper) {
            super(looper);
            this.mManager = manager;
        }

        public void handleMessage(Message msg) {
            if (DEBUG) {
                Log.i((String)SmartPlatformManager.TAG, (String)("handleMessage: " + msg.what));
            }
            switch (msg.what) {
                case 1: {
                    String cameraId = (String)msg.obj;
                    Log.w((String)SmartPlatformManager.TAG, (String)("Device Disconnected, no ErrorCallbck, close ; " + cameraId));
                    this.mManager.closeCameraDevice(cameraId);
                    return;
                }
            }
            Log.e((String)SmartPlatformManager.TAG, (String)("Unknow message type " + msg.what));
        }
    }

    private final class CameraDeviceRefCount {
        public int refCout;

        CameraDeviceRefCount(int count) {
            this.refCout = count;
        }
    }

    class DeathNotifer
    implements IBinder.DeathRecipient {
        private String mServiceName;

        DeathNotifer(String name) {
            this.mServiceName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            Log.e((String)SmartPlatformManager.TAG, (String)(this.mServiceName + " died "));
            if (SmartPlatformManager.SMARTPLATFORM_SERVICE_BINDER_NAME.equals(this.mServiceName)) {
                SmartPlatformManager.this.mSmartPlatformService = null;
            }
            if (SmartPlatformManager.CAMERA_SERVICE_BINDER_NAME.equals(this.mServiceName)) {
                SmartPlatformManager.this.mCameraService = null;
            }
            if (SmartPlatformManager.WINDOW_SERVICE_BINDER_NAME.equals(SmartPlatformManager.this.mWindowManager)) {
                SmartPlatformManager.this.mWindowManager = null;
            }
            Object object = SmartPlatformManager.this.mServiceDiedLock;
            synchronized (object) {
                for (ServiceDeathCallback callback : SmartPlatformManager.this.mServiceDeathCallbacks) {
                    if (callback == null) continue;
                    callback.onDeath(0, this.mServiceName);
                }
            }
        }
    }

    public static interface CameraAvailableCallback {
        public static final int STATUS_CAMERA_REMOVED = 0;
        public static final int STATUS_CAMERA_ADDED = 1;

        public void onAvailable(String var1, int var2);
    }

    public static interface ServiceDeathCallback {
        public void onDeath(int var1, String var2);
    }
}

