/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.graphics.Point;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;

public class ADASInfo
implements Parcelable {
    public static final int SeverityNone = 0;
    public static final int SeverityINFO = 1;
    public static final int SeverityATTENTION = 2;
    public static final int SeverityDanger = 3;
    public static final int TypeNone = 0;
    public static final int TypeSolidLineCrossing = 1;
    public static final int TypeDashedLineCrossing = 2;
    public static final int ObjectTypeNone = 0;
    public static final int ObjectTypeVehicle = 1;
    public static final int ObjectTypePedestrian = 2;
    public static final int DRIVER_ATTENTION_LEFT = 0;
    public static final int DRIVER_ATTENTION_FORWARD = 1;
    public static final int DRIVER_ATTENTION_MIDDLE = 2;
    public static final int DRIVER_ATTENTION_RIGHT = 3;
    public static final int DRIVER_ATTENTION_DOWN = 4;
    public static final int DRIVER_ATTENTION_ABSENT = 5;
    public int leftLaneWarning;
    public int rightLaneWarning;
    public int laneSeverity;
    public int laneType;
    public Point[] leftLanePos = new Point[2];
    public Point[] rightLanePos = new Point[2];
    public int lightValue;
    public int numOfVehicles;
    public int forwardObject;
    public int forwardSeverity;
    public int calibrationReady;
    public int driverSeverity;
    public int rearSeverity;
    public int driverState;
    public int rearObject;
    public int fvdInfo;
    public Rect[] vehiclesPos;
    public int[] distances;
    public static final Parcelable.Creator<ADASInfo> CREATOR = new Parcelable.Creator<ADASInfo>(){

        public ADASInfo createFromParcel(Parcel in) {
            ADASInfo info = new ADASInfo();
            info.readFromParcel(in);
            return info;
        }

        public ADASInfo[] newArray(int size) {
            return new ADASInfo[size];
        }
    };

    public ADASInfo() {
        this.leftLanePos[0] = new Point(0, 0);
        this.leftLanePos[1] = new Point(0, 0);
        this.rightLanePos[0] = new Point(0, 0);
        this.rightLanePos[1] = new Point(0, 0);
    }

    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.leftLaneWarning);
        dest.writeInt(this.rightLaneWarning);
        dest.writeInt(this.laneSeverity);
        dest.writeInt(this.laneType);
        dest.writeInt(4);
        for (Point pos : this.leftLanePos) {
            pos.writeToParcel(dest, flags);
        }
        dest.writeInt(4);
        for (Point pos : this.rightLanePos) {
            pos.writeToParcel(dest, flags);
        }
        dest.writeInt(this.lightValue);
        dest.writeInt(this.numOfVehicles);
        dest.writeInt(this.forwardObject);
        dest.writeInt(this.forwardSeverity);
        dest.writeInt(this.calibrationReady);
        dest.writeInt(this.driverSeverity);
        dest.writeInt(this.rearSeverity);
        dest.writeInt(this.driverState);
        dest.writeInt(this.rearObject);
        dest.writeInt(this.fvdInfo);
        if (this.numOfVehicles > 0) {
            void var3_6;
            dest.writeInt(this.numOfVehicles * 5);
            this.vehiclesPos = new Rect[this.numOfVehicles];
            boolean bl = false;
            while (var3_6 < this.numOfVehicles) {
                this.vehiclesPos[var3_6] = new Rect();
                ++var3_6;
            }
            for (Rect rect : this.vehiclesPos) {
                rect.writeToParcel(dest, flags);
            }
            for (int distance : this.distances = new int[this.numOfVehicles]) {
                dest.writeInt(distance);
            }
        }
    }

    public void readFromParcel(Parcel in) {
        this.leftLaneWarning = in.readInt();
        this.rightLaneWarning = in.readInt();
        this.laneSeverity = in.readInt();
        this.laneType = in.readInt();
        in.readInt();
        this.leftLanePos[0].readFromParcel(in);
        this.leftLanePos[1].readFromParcel(in);
        in.readInt();
        this.rightLanePos[0].readFromParcel(in);
        this.rightLanePos[1].readFromParcel(in);
        this.lightValue = in.readInt();
        this.numOfVehicles = in.readInt();
        this.forwardObject = in.readInt();
        this.forwardSeverity = in.readInt();
        this.calibrationReady = in.readInt();
        this.driverSeverity = in.readInt();
        this.rearSeverity = in.readInt();
        this.driverState = in.readInt();
        this.rearObject = in.readInt();
        this.fvdInfo = in.readInt();
        if (this.numOfVehicles > 0) {
            int i;
            in.readInt();
            this.vehiclesPos = new Rect[this.numOfVehicles];
            this.distances = new int[this.numOfVehicles];
            for (i = 0; i < this.numOfVehicles; ++i) {
                this.vehiclesPos[i] = new Rect();
                this.vehiclesPos[i].readFromParcel(in);
            }
            for (i = 0; i < this.numOfVehicles; ++i) {
                this.distances[i] = in.readInt();
            }
        }
    }

    public String toString() {
        String str = super.toString() + " leftLaneWarning=" + this.leftLaneWarning + "; rightLaneWarning=" + this.rightLaneWarning + "; laneSeverity=" + this.laneSeverity + "; laneType=" + this.laneType + "; leftLanePos=" + this.leftLanePos + "; rightLanePos=" + this.rightLanePos + "; lightValue=" + this.lightValue + "; numOfVehicles=" + this.numOfVehicles + "; forwardObject=" + this.forwardObject + "; forwardSeverity=" + this.forwardSeverity + "; calibrationReady=" + this.calibrationReady + "; driverSeverity=" + this.driverSeverity + "; rearSeverity=" + this.rearSeverity + "; driverState=" + this.driverState + "; rearObject=" + this.rearObject + "; fvdInfo=" + this.fvdInfo + "; vehiclesPos=" + this.vehiclesPos + "; distances=" + this.distances;
        return str;
    }
}

