package com.waytous.pushassistant

import android.media.CamcorderProfile
import com.mediatek.smartplatform.RecordConfiguration
import com.mediatek.smartplatform.RecordConfiguration.VideoFrameMode.VIDEO_FRAME_MODE_DUAL_SOURCE
import com.mediatek.smartplatform.RecordSource
import com.mediatek.smartplatform.SpmCameraDevice
import com.mediatek.smartplatform.SpmCameraDevice.VideoCallback
import com.mediatek.smartplatform.VideoInfoMap
import java.io.File

class BsdRecordManager(private val camera: SpmCameraDevice, private val recordParent: File, private val duration:Int, private val frameRate:Int = 15, private val bitRate:Int = 90000) {

    fun startRecord() {
        val frontPlaybackDir = File(recordParent, "bsd")
        if (!frontPlaybackDir.exists()) {
            frontPlaybackDir.mkdirs()
        }
        camera.startRecord(RecordSource.GENERAL_CAMERA, createRecordConfiguration(frontPlaybackDir.path,duration,frameRate,bitRate))
    }

    fun stopRecord(){
        camera.stopRecord(RecordSource.GENERAL_CAMERA)
    }

    private fun createRecordConfiguration(path:String, duration:Int, frameRate:Int, bitRate:Int): RecordConfiguration = RecordConfiguration.get(
        RecordSource.GENERAL_CAMERA).apply {
        mCamcorderProfile = CamcorderProfile.get(CamcorderProfile.QUALITY_480P).apply {
            videoFrameRate = frameRate
            videoBitRate = bitRate
        }
        mOutPutFilePath = path
        mOutPutFileName = "playback-%Y%m%d_%H%M%S"
        mVideoCycleDeleteFileNum = 30
        mVideoRotateDuration = duration
        mVideoFrameMode = VIDEO_FRAME_MODE_DUAL_SOURCE
        mVideoCallback = object: VideoCallback {
            override fun onVideoTaken(p0: VideoInfoMap?) {

            }

            override fun onVideoFrame(h264: ByteArray, dataType: Int, size: Int, cameraId: String?, recordType: Int) {
                PushTools.onCameraBsdFrame(h264,size)
            }
        }
    }
}