/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.os.Build;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.util.Range;
import android.util.Rational;
import com.mediatek.smartplatform.CameraSurfaceUsage;
import com.mediatek.smartplatform.MetadataUtil;
import com.mediatek.smartplatform.RecordConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;

public class SpmCamParameters {
    private String TAG = "SpmCameraDevice";
    private static final boolean DEBUG = Build.IS_ENG || SystemProperties.getBoolean((String)"persist.vendor.log.spmsdk", (boolean)false);
    CameraCharacteristics mCameraCharacteristics = null;
    CameraMetadataNative mResultMetadata = null;
    CameraMetadataNative mRequestMetadata = null;
    Range<Integer> mPreviwFpsRange = null;
    ArrayList<Pair<Integer, Integer>> mDropStreamFrameInfo = null;
    int[] mHorizonflip = null;
    int[] mFisheyeCorrection = null;
    private static final CameraMetadataNative.Key<Integer> CAMERA_HORIZON_FLIP_ENABLE = new CameraMetadataNative.Key("com.mediatek.flipfeature.enable", Integer.TYPE);
    private static final CameraMetadataNative.Key<Integer> CAMERA_HORIZON_FLIP_ROTATION = new CameraMetadataNative.Key("com.mediatek.flipfeature.rotation", Integer.TYPE);
    private LinkedHashMap<String, String> mMap;
    private Object mMapLock = new Object();
    private static final String SUPPORTED_VALUES_SUFFIX = "-values";
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private static final String KEY_PREVIEW_SIZE = "preview-size";
    private static final String KEY_VIDEO_SIZE = "video-size";
    private static final String KEY_VIDEO_ROTATE_SIZE = "max-filesize";
    private static final String KEY_VIDEO_ROTATE_DURATION = "max-duration";
    private static final String KEY_VIDEO_MUTE_AIUDO = "mute-recording_audio";
    private static final String KEY_MOTION_DETECT_MODE = "motion_detect_mode";
    private static final String KEY_VIDEO_OUTPUT_FORMAT = "video-output-format";
    private static final String KEY_VIDEO_FRAME_RATE = "video-frame-rate";
    private static final String KEY_VIDEO_PARAM_ENCODING_BITRATE = "video-param-encoding-bitrate";
    private static final String KEY_VIDEO_ENCODER = "video-encoder";
    private static final String KEY_VIDEO_PARAM_CAMERA_ID = "video-param-camera-id";
    private static final String KEY_AUDIO_PARAM_ENCODING_BITRATE = "audio-param-encoding-bitrate";
    private static final String KEY_AUDIO_PARAM_NUMBER_OF_CHANNELS = "audio-param-number-of-channels";
    private static final String KEY_AUDIO_PARAM_SAMPLING_RATE = "audio-param-sampling-rate";
    private static final String KEY_AUDIO_ENCODER = "audio-encoder";
    private static final String KEY_VIDEO_OUTPUT_FILE = "video-output-file";
    private static final String KEY_VIDEO_OUTPUT_FILE_NAME = "video-output-file-name";
    private static final String KEY_VIDEO_LOCK_FILE = "video-lock-file";
    private static final String KEY_LOCK_FILE_NAME_PREFIX = "lock-file-name-prefix";
    private static final String KEY_WATERMARK_OFFSET = "watermark-offset";
    private static final String KEY_WATERMARK_TIMER_OFFSET = "watermark-timer-offset";
    private static final String KEY_WATERMARK_ADDRESS = "watermark-address";
    private static final String KEY_WATERMARK_SIZE = "watermark-size";
    private static final String KEY_WATERMARK_DATA_PATH = "watermark-data-path";
    private static final String KEY_WATERMARK_OWNER_NAME = "watermark-owner-name";
    private static final String KEY_WHITE_BALANCE = "whitebalance";
    private static final String KEY_AUTO_WHITEBALANCE_LOCK = "auto-whitebalance-lock";
    private static final String KEY_AUTO_WHITEBALANCE_LOCK_SUPPORTED = "auto-whitebalance-lock-supported";
    private static final String KEY_MAX_EXPOSURE_COMPENSATION = "max-exposure-compensation";
    private static final String KEY_MIN_EXPOSURE_COMPENSATION = "min-exposure-compensation";
    private static final String KEY_EXPOSURE_COMPENSATION = "exposure-compensation";
    private static final String KEY_EXPOSURE_COMPENSATION_STEP = "exposure-compensation-step";
    private static final String KEY_FREE_SIZE_LIMIT = "free-size-limit";
    private static final String KEY_ADAS_SIZE = "adas-size";
    private static final String KEY_ADAS_END_POINT = "adas-end-point";
    private static final String KEY_ADAS_SCALE_FACTOR = "adas-scale-factor";
    private static final String KEY_ADAS_FOCAL_LENGTH = "adas-focal-length";
    static final String KEY_MAIN_VIDEO_FRAME_ENABLED = "main-video-frame-enabled";
    private static final String KEY_USER_SET_VIDEO_ENCODEBITRATE = "user_set_video_encod_bitrate";
    private static final String KEY_VIDEO_PARAM_ENCODING_MINBITRATE = "video-param-encoding-minbitrate";
    private static final String KEY_VIDEO_PARAM_ENCODING_MAXBITRATE = "video-param-encoding-maxbitrate";
    private static final String KEY_KEYPOINT_SPAN_LIMIT = "keypoint-span-limit";
    private static final String KEY_IMEI_NUMBER = "imei-number";
    private static final String KEY_JPEG_IMAGE_DESC = "jpeg-image-desc";
    private static final String KEY_REC_MUTE_OGG = "rec-mute-ogg";
    private static final String KEY_ENABLE_FILE_TIME = "enable-file-time";
    private static final String KEY_SDCARD_SPEED_LIMIT = "sdcard-speed-limit";
    private static final String KEY_ENABLE_ENCRYPT = "enable-encrypt-flag";
    private static final String KEY_NOTIFY_ENCRYPT_TYPE = "notify-encrypt-type";
    private static final String KEY_ENABLE_MPEG4_RECOVER = "enable-mpeg4-recover";
    private static final String KEY_ENABLE_MMAP_TYEPE = "enable_mmap_type";
    private static final String KEY_DISABLE_CIRCULAR_DELETE = "disable-circular-delete";
    private static final String KEY_REDUCE_REC_FPS = "reduce-recorde-fps";
    private static final String KEY_DELETE_FILE_NUM = "delete-file-num";
    private static final String KEY_SUB_VIDEO_SIZE = "videocb-size";
    private static final String KEY_SUB_VIDEO_FRAME_RATE = "sub-video-frame-rate";
    private static final String KEY_SUB_VIDEO_FRAME_ENABLED = "sub-video-frame-enabled";
    private static final String KEY_SUB_VIDEO_PARAM_ENCODING_BITRATE = "sub-video-param-encoding-bitrate";
    private static final String KEY_SUB_VIDEO_OUTPUT_FILE = "sub-video-output-file";
    private static final String KEY_SUB_VIDEO_OUTPUT_FILE_NAME = "sub-video-output-file-name";
    private static final String KEY_SUB_VIDEO_CROP = "sub-video-crop";
    private static final String KEY_SUB_STREAM_SHARE_AUDIO = "sub_stream_share_audio";
    private static final String KEY_AVM_VIDEO_SIZE = "avm-video-size";
    private static final String KEY_AVM_VIDEO_FRAME_RATE = "avm-video-frame-rate";
    private static final String KEY_AVM_VIDEO_FRAME_ENABLED = "avm-video-frame-enabled";
    private static final String KEY_AVM_VIDEO_PARAM_ENCODING_BITRATE = "avm-video-param-encoding-bitrate";
    private static final String KEY_AVM_VIDEO_OUTPUT_FILE = "avm-video-output-file";
    private static final String KEY_AVM_VIDEO_OUTPUT_FILE_NAME = "avm-video-output-file-name";
    private static final String KEY_AVM_DISPLAY = "avm-display";
    private static final String KEY_AVM_CALIBRATION_MODE = "avm-calibration-mode";
    private static final String KEY_AVM_CALIBRATION = "avm-calibration";
    private static final String KEY_PREVIEW_WATERMARK_TEXT_MODE = "preview-watermark-text-mode";
    private static final String KEY_RECORD_WATERMARK_TEXT_MODE = "record-watermark-text-mode";
    private static final String KEY_PICTURE_WATERMARK_TEXT_MODE = "picture-watermark-text-mode";
    private static final String KEY_VIDEOCB_WATERMARK_TEXT_MODE = "videocb-watermark-text-mode";
    private static final String KEY_WATERMARK_AREA = "watermark-area";
    private static final String KEY_WATERMARK_TEXT = "watermark-text";
    private static final String KEY_WATERMARK_AREA_EX1 = "watermark-area-ex1";
    private static final String KEY_WATERMARK_TEXT_EX1 = "watermark-text-ex1";
    private static final String KEY_WATERMARK_AREA_EX2 = "watermark-area-ex2";
    private static final String KEY_WATERMARK_TEXT_EX2 = "watermark-text-ex2";
    private static final String KEY_WATERMARK_AREA_EX3 = "watermark-area-ex3";
    private static final String KEY_WATERMARK_TEXT_EX3 = "watermark-text-ex3";
    private static final String KEY_WATERMARK_TEXT_SIZE = "watermark-text-size";
    private static final String KEY_WATERMARK_TEXT_X = "watermark-text-x";
    private static final String KEY_WATERMARK_TEXT_Y = "watermark-text-y";
    private static final String KEY_WATERMARK_TEXT_COLOR = "watermark-text-color";
    private static final String KEY_WATERMARK_FONT_FILE = "watermark-font-file";
    private static final String KEY_WATERMARK_TIMESTAMP_FORMAT = "watermark-timestamp-format";
    private static final String KEY_WATERMARK_TIME_MS = "watermark-timestamp-ms";
    private static final String KEY_PREVIEW_WATERMARK_IMG_MODE = "preview-watermark-img-mode";
    private static final String KEY_RECORD_WATERMARK_IMG_MODE = "record-watermark-img-mode";
    private static final String KEY_PICTURE_WATERMARK_IMG_MODE = "picture-watermark-img-mode";
    private static final String KEY_VIDEOCB_WATERMARK_IMG_MODE = "videocb-watermark-img-mode";
    private static final String KEY_WATERMARK_IMG_PATH = "watermark-img-path";
    private static final String KEY_WATERMARK_IMG_AREA = "watermark-img-area";
    private static final String KEY_WATERMARK_TEXT_MODE = "watermark-text-mode";
    private static final String KEY_WATERMARK_IMG_MODE = "watermark-img-mode";
    private static final String KEY_WATERMARK_TEXT_SHADOW_RADIUS = "watermark-text-shadow-radius";
    private static final String KEY_WATERMARK_TEXT_SHADOW_XOFFSET = "watermark-text-shadow-xoffset";
    private static final String KEY_WATERMARK_TEXT_SHADOW_YOFFSET = "watermark-text-shadow-yoffset";
    private static final String KEY_WATERMARK_TEXT_SHADOW_COLOR = "watermark-text-shadow-color";
    private static final String KEY_WATERMARK_PREVIEW_EN = "watermark-preview-en";
    public static final String WHITE_BALANCE_AUTO = "auto";
    public static final String WHITE_BALANCE_INCANDECSENT = "incandescent";
    public static final String WHITE_BALANCE_FLUORESCENT = "fluorescent";
    public static final String WHITE_BALANCE_WARM_FLUORESCENT = "warm-fluorescent";
    public static final String WHITE_BALANCE_DAYLIGHT = "daylight";
    public static final String WHITE_BALANCE_CLOUDY_DAYLIGHT = "cloudy-daylight";
    public static final String WHITE_BALANCE_TWILIGHT = "twilight";
    public static final String WHITE_BALANCE_SHADE = "shade";
    public static final String WHITE_BALANCE_TUNGSTEN = "tungsten";
    private static final String KEY_PREVIEW_FRAME_RATE = "preview-frame-rate";
    private static final String KEY_PREVIEW_FPS_RANGE = "preview-fps-range";
    private static final String KEY_SCENE_MODE = "scene-mode";
    private static final String KEY_EIS_MODE = "eis-mode";
    private static final String KEY_VIDEO_STABILIZATION = "video-stabilization";
    private static final String KEY_VIDEO_STABILIZATION_SUPPORTED = "video-stabilization-supported";
    private static final String KEY_EFFECT = "effect";
    private static final String KEY_VIDCB_FRAMERATE = "vidcb-frame-rate";
    private static final String KEY_DROP_CAMERA_FRAME = "drop-camera-frame";
    private static final String KEY_FRAME_TIMESTAMP_FOR_PRV = "prv-timestamp";
    private static final String KEY_FRAME_TIMESTAMP_FOR_REC = "rec-timestamp";
    private static final String KEY_YUV_CALLBACK = "yuv-callback-type";
    private static final String KEY_PICTURE_SIZE = "picture-size";
    private static final String KEY_JPEG_THUMBNAIL_SIZE = "jpeg-thumbnail-size";
    private static final String KEY_JPEG_THUMBNAIL_WIDTH = "jpeg-thumbnail-width";
    private static final String KEY_JPEG_THUMBNAIL_HEIGHT = "jpeg-thumbnail-height";
    private static final String KEY_JPEG_THUMBNAIL_QUALITY = "jpeg-thumbnail-quality";
    private static final String KEY_JPEG_QUALITY = "jpeg-quality";
    private static final String KEY_RECORDING_HINT = "recording-hint";
    private static final String KEY_ROTATION = "rotation";
    private static final String KEY_VIDEO_ROTATION = "video-rotation";
    private static final String KEY_PREVIEW_MIRROR = "preview-mirror";
    private static final String KEY_GPS_LATITUDE = "gps-latitude";
    private static final String KEY_GPS_LONGITUDE = "gps-longitude";
    private static final String KEY_GPS_ALTITUDE = "gps-altitude";
    private static final String KEY_GPS_TIMESTAMP = "gps-timestamp";
    private static final String KEY_GPS_PROCESSING_METHOD = "gps-processing-method";
    public static final String KEY_VIDEO_HDR = "video-hdr";
    public static final String KEY_VIDEO_HDR_MODE = "video-hdr-mode";
    public static final String VIDEO_HDR_MODE_IVHDR = "video-hdr-mode-ivhdr";
    public static final String VIDEO_HDR_MODE_MVHDR = "video-hdr-mode-mvhdr";
    public static final String KEY_WARP_MODE = "warp-enable";
    public static final String KEY_CAM_MODE = "mtk-cam-mode";
    public static final String KEY_AUDIO_SOURCE = "audio-source";
    public static final String KEY_EXT1_SIZE = "ext1-size";
    public static final String KEY_EXT1_FMT = "ext1-format";
    public static final String KEY_EXT0_SIZE = "ext0-size";
    public static final String KEY_EXT0_FMT = "ext0-format";
    public static final String KEY_EXT2_SIZE = "ext2-size";
    public static final String KEY_EXT2_FMT = "ext2-format";
    public static final String KEY_EXT3_SIZE = "ext3-size";
    public static final String KEY_EXT3_FMT = "ext3-format";
    public static final String KEY_AVM_CALIB_INTREAR = "avm_calib_intrear";
    public static final String KEY_AVM_CALIB_POSREAR = "avm_calib_posrear";
    public static final String KEY_AVM_CALIB_DISTCOEFFREAR = "avm_calib_distcoeffrear";
    public static final String KEY_RECORD_ID = "record-id";
    public static final String KEY_VEHICLE_LONGITUDE = "vehicle-longitude";
    public static final String KEY_VEHICLE_LATITUDE = "vehicle-latitude";
    public static final String KEY_VEHICLE_SPEED = "vehicle-speed";
    public static final String KEY_VEHICLE_GEAR_STATUS = "vehicle-gear-status";
    public static final String KEY_VEHICLE_ACCELERATOR = "vehicle-accelerator";
    public static final String KEY_VEHICLE_BRAKE = "vehicle-brake";
    public static final String KEY_VEHICLE_LEFT_SIGNAL = "vehicle-left-signal";
    public static final String KEY_VEHICLE_RIGHT_SIGNAL = "vehicle-right-signal";
    public static final String KEY_VEHICLE_SAFETYBELT = "vehicle-safetybelt";
    public static final String KEY_VEHICLE_ADAS_STATUS = "vehicle-adas-status";
    public static final String KEY_VEHICLE_LANUAGE = "vehicle-lanuage";
    public static final String[] KEY_EXT_SURFACE_SIZE = new String[]{"ext0-size", "ext1-size", "ext2-size", "ext3-size", "ext4-size"};
    public static final String[] KEY_EXT_SURFACE_FORMAT = new String[]{"ext0-format", "ext1-format", "ext2-format", "ext3-format", "ext4-format"};
    public static final String[] KEY_EXT_SIZE = new String[]{"ext0-size", "ext1-size", "ext2-size", "ext3-size"};
    public static final String[] KEY_EXT_FORMAT = new String[]{"ext0-format", "ext1-format", "ext2-format", "ext3-format"};
    private static final CameraMetadataNative.Key<int[]> CAMERA_FISHEYE_CORRECTION = new CameraMetadataNative.Key("com.mediatek.streamingfeature.fisheyeCorrection", int[].class);
    private static final CameraMetadataNative.Key<int[]> CAMERA_FRAME_DROP_POLICY = new CameraMetadataNative.Key("com.mediatek.streamingfeature.frameDropPolicy", int[].class);
    private static final CameraMetadataNative.Key<Integer> CAMERA_SUB_VIDEO_CROP = new CameraMetadataNative.Key("com.mediatek.streamingfeature.subVideoCrop", Integer.TYPE);
    private static final String KEY_AE_BLOCK_Y_MODE = "ae-blocky-mode";
    private static final CameraMetadataNative.Key<Integer> AE_BLOCK_Y_MODE = new CameraMetadataNative.Key("com.mediatek.3afeature.aeBlockYvaluesGetMode", Integer.TYPE);
    private static final CameraMetadataNative.Key<int[]> AE_BLOCK_Y_VALUES = new CameraMetadataNative.Key("com.mediatek.3afeature.aeBlockYvalues", int[].class);
    static final int AeBlockValueSize = 25;
    private static final CameraMetadataNative.Key<Integer> WATERMARK_TEXT_ENABLE = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextEnable", Integer.TYPE);
    private static final CameraMetadataNative.Key<Float> WATERMARK_TEXT_SIZE = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextSize", Float.TYPE);
    private static final CameraMetadataNative.Key<Integer> WATERMARK_TEXT_COLOR = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextColor", Integer.TYPE);
    private static final CameraMetadataNative.Key<String> WATERMARK_TEXT_FONTFILE = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextFont", String.class);
    private static final CameraMetadataNative.Key<Integer> WATERMARK_TEXT_TIME_AREA = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTimeArea", Integer.TYPE);
    private static final CameraMetadataNative.Key<String> WATERMARK_TEXT = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkText", String.class);
    private static final CameraMetadataNative.Key<int[]> WATERMARK_TEXT_AREA = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextArea", int[].class);
    private static final CameraMetadataNative.Key<String> WATERMARK_TEXT_EX1 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextEx1", String.class);
    private static final CameraMetadataNative.Key<int[]> WATERMARK_TEXT_AREA_EX1 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextAreaEx1", int[].class);
    private static final CameraMetadataNative.Key<String> WATERMARK_TEXT_EX2 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextEx2", String.class);
    private static final CameraMetadataNative.Key<int[]> WATERMARK_TEXT_AREA_EX2 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextAreaEx2", int[].class);
    private static final CameraMetadataNative.Key<String> WATERMARK_TEXT_EX3 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextEx3", String.class);
    private static final CameraMetadataNative.Key<int[]> WATERMARK_TEXT_AREA_EX3 = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextAreaEx3", int[].class);
    private static final CameraMetadataNative.Key<float[]> WATERMARK_TEXT_POSITION = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTextPosition", float[].class);
    private static final CameraMetadataNative.Key<Integer> WATERMARK_IMAGE_ENABLE = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkImageEnable", Integer.TYPE);
    private static final CameraMetadataNative.Key<int[]> WATERMARK_IMAGE_AREA = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkImageArea", int[].class);
    private static final CameraMetadataNative.Key<String> WATERMARK_IMAGE_PATH = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkImagePath", String.class);
    private static final CameraMetadataNative.Key<Integer> WATERMARK_TIME_MS = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkTimeMs", Integer.TYPE);
    private static final CameraMetadataNative.Key<String> WATERMARK_FORMAT = new CameraMetadataNative.Key("com.mediatek.watermark.watermarkFormat", String.class);
    private static final CameraMetadataNative.Key<Integer> WATERMARK_PREVIEW_EN = new CameraMetadataNative.Key("com.mediatek.watermark.previewEn", Integer.TYPE);
    public static final int MTK_CONTROL_SCENE_MODE_DUMMY_NIGHT = 129;
    private static final String KEY_AVM_ALGO = "avm-algo";
    private static final int CONTROL_SCENE_MODE_HDR = 18;

    public void setHorizonFlip(boolean flip, int rotation) {
        if (DEBUG) {
            Log.i((String)this.TAG, (String)("setHorizonFlip: " + rotation + flip));
        }
        this.mHorizonflip = new int[2];
        this.mHorizonflip[0] = flip ? 1 : 0;
        this.mHorizonflip[1] = rotation;
    }

    private void mapHorizonFlip(CameraMetadataNative metadata) {
        if (this.mHorizonflip != null) {
            try {
                metadata.set(CAMERA_HORIZON_FLIP_ENABLE, (Object)this.mHorizonflip[0]);
                metadata.set(CAMERA_HORIZON_FLIP_ROTATION, (Object)this.mHorizonflip[1]);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + CAMERA_HORIZON_FLIP_ENABLE.getName()));
            }
        }
    }

    public SpmCamParameters() {
        this.mMap = new LinkedHashMap(128);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyFrom(SpmCamParameters other) {
        if (other == null) {
            throw new NullPointerException("other must not be null");
        }
        Object object = this.mMapLock;
        synchronized (object) {
            this.mMap.putAll(other.mMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unflatten(String flattened) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mMap.clear();
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(';');
            splitter.setString(flattened);
            for (String kv : splitter) {
                int pos = kv.indexOf(61);
                if (pos == -1) continue;
                String k = kv.substring(0, pos);
                String v = kv.substring(pos + 1);
                this.mMap.put(k, v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String flatten() {
        StringBuilder flattened = new StringBuilder(128);
        Object object = this.mMapLock;
        synchronized (object) {
            for (String k : this.mMap.keySet()) {
                flattened.append(k);
                flattened.append("=");
                flattened.append(this.mMap.get(k));
                flattened.append(";");
            }
        }
        flattened.deleteCharAt(flattened.length() - 1);
        return flattened.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String key) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mMap.remove(key);
        }
    }

    private ArrayList<String> split(String str) {
        if (str == null) {
            return null;
        }
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
        splitter.setString(str);
        ArrayList<String> substrings = new ArrayList<String>();
        for (String s : splitter) {
            substrings.add(s);
        }
        return substrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key) {
        Object object = this.mMapLock;
        synchronized (object) {
            return this.mMap.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String key, String defaultValue) {
        String value;
        Object object = this.mMapLock;
        synchronized (object) {
            value = this.mMap.get(key);
        }
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInt(String key) {
        Object object = this.mMapLock;
        synchronized (object) {
            return Integer.parseInt(this.mMap.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float getFloat(String key, float defaultValue) {
        try {
            Object object = this.mMapLock;
            synchronized (object) {
                return Float.parseFloat(this.mMap.get(key));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getInt(String key, int defaultValue) {
        try {
            Object object = this.mMapLock;
            synchronized (object) {
                return Integer.parseInt(this.mMap.get(key));
            }
        }
        catch (NumberFormatException e) {
            Log.w((String)this.TAG, (String)("getInt NumberFormatException, use defaultValue :" + defaultValue));
            return defaultValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(String key, String value) {
        Object object = this.mMapLock;
        synchronized (object) {
            this.mMap.remove(key);
            this.mMap.put(key, value);
        }
    }

    public void set(String key, String value) {
        if (key.indexOf(61) != -1 || key.indexOf(59) != -1 || key.indexOf(0) != -1) {
            Log.e((String)this.TAG, (String)("Key \"" + key + "\" contains invalid character (= or ; or \\0)"));
            return;
        }
        if (key == null || value == null) {
            Log.e((String)this.TAG, (String)("key or value is null, key:" + key + ", value:" + value));
            return;
        }
        if (value.indexOf(61) != -1 || value.indexOf(59) != -1 || value.indexOf(0) != -1) {
            Log.e((String)this.TAG, (String)("Value \"" + value + "\" contains invalid character (= or ; or \\0)"));
            return;
        }
        this.put(key, value);
    }

    public void set(String key, int value) {
        this.put(key, Integer.toString(value));
    }

    public void set(String key, float value) {
        this.put(key, Float.toString(value));
    }

    private ArrayList<Size> splitSize(String str) {
        if (str == null) {
            return null;
        }
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
        splitter.setString(str);
        ArrayList<Size> sizeList = new ArrayList<Size>();
        for (String s : splitter) {
            Size size = this.strToSize(s);
            if (size == null) continue;
            sizeList.add(size);
        }
        if (sizeList.size() == 0) {
            return null;
        }
        return sizeList;
    }

    private Size strToSize(String str) {
        if (str == null) {
            return null;
        }
        int pos = str.indexOf(120);
        if (pos != -1) {
            String width = str.substring(0, pos);
            String height = str.substring(pos + 1);
            return new Size(Integer.parseInt(width), Integer.parseInt(height));
        }
        return null;
    }

    private ArrayList<int[]> splitRange(String str) {
        int endIndex;
        if (str == null || str.charAt(0) != '(' || str.charAt(str.length() - 1) != ')') {
            Log.e((String)this.TAG, (String)("Invalid range list string=" + str));
            return null;
        }
        ArrayList<int[]> rangeList = new ArrayList<int[]>();
        int fromIndex = 1;
        do {
            int[] range = new int[2];
            endIndex = str.indexOf("),(", fromIndex);
            if (endIndex == -1) {
                endIndex = str.length() - 1;
            }
            this.splitInt(str.substring(fromIndex, endIndex), range);
            rangeList.add(range);
            fromIndex = endIndex + 3;
        } while (endIndex != str.length() - 1);
        if (rangeList.size() == 0) {
            return null;
        }
        return rangeList;
    }

    private ArrayList<Integer> splitInt(String str) {
        if (str == null) {
            return null;
        }
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
        splitter.setString(str);
        ArrayList<Integer> substrings = new ArrayList<Integer>();
        for (String s : splitter) {
            substrings.add(Integer.parseInt(s));
        }
        if (substrings.size() == 0) {
            return null;
        }
        return substrings;
    }

    private void splitInt(String str, int[] output) {
        if (str == null) {
            return;
        }
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(',');
        splitter.setString(str);
        int index = 0;
        for (String s : splitter) {
            output[index++] = Integer.parseInt(s);
        }
    }

    public List<Size> getSupportedPreviewSizes() {
        StreamConfigurationMap configMap;
        try {
            configMap = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)"Unable to obtain preview sizes.", (Throwable)ex);
            return new ArrayList<Size>(0);
        }
        ArrayList<Size> supportedPictureSizes = new ArrayList<Size>();
        for (android.util.Size androidSize : configMap.getOutputSizes(SurfaceTexture.class)) {
            supportedPictureSizes.add(new Size(androidSize));
        }
        return supportedPictureSizes;
    }

    public void setPreviewSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_PREVIEW_SIZE, v);
    }

    public Size getPreviewSize() {
        String pair = this.get(KEY_PREVIEW_SIZE);
        return this.strToSize(pair);
    }

    public void setPictureSize(int width, int height) {
        String str = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_PICTURE_SIZE, str);
    }

    public Size getPictureSize() {
        String str = this.get(KEY_PICTURE_SIZE);
        return this.strToSize(str);
    }

    public List<Size> getSupportedPictureSizes(int imageFormat) {
        StreamConfigurationMap configMap;
        try {
            configMap = (StreamConfigurationMap)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        }
        catch (Exception ex) {
            Log.e((String)this.TAG, (String)"Unable to obtain picture sizes.", (Throwable)ex);
            return new ArrayList<Size>(0);
        }
        ArrayList<Size> supportedPictureSizes = new ArrayList<Size>();
        for (android.util.Size androidSize : configMap.getOutputSizes(imageFormat)) {
            supportedPictureSizes.add(new Size(androidSize));
        }
        return supportedPictureSizes;
    }

    public void setJpegThumbnailSize(int width, int height) {
        this.set(KEY_JPEG_THUMBNAIL_WIDTH, width);
        this.set(KEY_JPEG_THUMBNAIL_HEIGHT, height);
    }

    public Size getJpegThumbnailSize() {
        return new Size(this.getInt(KEY_JPEG_THUMBNAIL_WIDTH), this.getInt(KEY_JPEG_THUMBNAIL_HEIGHT));
    }

    public List<Size> getSupportedJpegThumbnailSizes() {
        String str = this.get("jpeg-thumbnail-size-values");
        return this.splitSize(str);
    }

    public void setJpegThumbnailQuality(int quality) {
        this.set(KEY_JPEG_THUMBNAIL_QUALITY, quality);
    }

    public int getJpegThumbnailQuality() {
        return this.getInt(KEY_JPEG_THUMBNAIL_QUALITY);
    }

    public void setJpegQuality(int quality) {
        this.set(KEY_JPEG_QUALITY, quality);
    }

    public int getJpegQuality() {
        return this.getInt(KEY_JPEG_QUALITY);
    }

    public void setImageDesc(String desc) {
        this.set(KEY_JPEG_IMAGE_DESC, desc);
    }

    public String getImageDesc() {
        return this.get(KEY_JPEG_IMAGE_DESC);
    }

    @Deprecated
    public void setPreviewFrameRate(int fps) {
        this.set(KEY_PREVIEW_FRAME_RATE, fps);
    }

    @Deprecated
    public int getPreviewFrameRate() {
        return this.getInt(KEY_PREVIEW_FRAME_RATE);
    }

    @Deprecated
    public List<Integer> getSupportedPreviewFrameRates() {
        String str = this.get("preview-frame-rate-values");
        return this.splitInt(str);
    }

    public void setPreviewFpsRange(int min, int max) {
        this.set(KEY_PREVIEW_FPS_RANGE, "" + min + "," + max);
        this.mPreviwFpsRange = new Range((Comparable)Integer.valueOf(min), (Comparable)Integer.valueOf(max));
    }

    public void getPreviewFpsRange(int[] range) {
        if (range == null || range.length != 2) {
            throw new IllegalArgumentException("range must be an array with two elements.");
        }
        this.splitInt(this.get(KEY_PREVIEW_FPS_RANGE), range);
    }

    public List<int[]> getSupportedPreviewFpsRange() {
        Range[] fpsRange;
        ArrayList<int[]> rangeList = new ArrayList<int[]>();
        for (Range it : fpsRange = (Range[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES)) {
            rangeList.add(MetadataUtil.convertAeFpsRangeToLegacy((Range<Integer>)it));
        }
        return rangeList;
    }

    public void setVideoSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_VIDEO_SIZE, v);
    }

    public Size getVideoSize() {
        String pair = this.get(KEY_VIDEO_SIZE);
        return this.strToSize(pair);
    }

    public void setSubVideoSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_SUB_VIDEO_SIZE, v);
    }

    public void setSubVideoCrop(boolean isEnable) {
        this.set(KEY_SUB_VIDEO_CROP, isEnable ? 1 : 0);
        Log.e((String)this.TAG, (String)("yyyy  setSubVideoCrop " + isEnable));
    }

    public Size getSubVideoSize() {
        String pair = this.get(KEY_SUB_VIDEO_SIZE);
        return this.strToSize(pair);
    }

    public void setAVMVideoSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_AVM_VIDEO_SIZE, v);
    }

    public Size getAVMVideoSize() {
        String pair = this.get(KEY_AVM_VIDEO_SIZE);
        return this.strToSize(pair);
    }

    public List<Size> getSupportedVideoSizes() {
        String values = this.get("video-size-values");
        return this.splitSize(values);
    }

    public String getSceneMode() {
        return this.get(KEY_SCENE_MODE);
    }

    public void setSceneMode(int value) {
        this.set(KEY_SCENE_MODE, value);
    }

    public List<String> getSupportedSceneModes() {
        String str = this.get("scene-mode-values");
        return this.split(str);
    }

    public String getEisMode() {
        return this.get(KEY_EIS_MODE);
    }

    public void setEisMode(String eis) {
        this.set(KEY_EIS_MODE, eis);
    }

    public List<String> getSupportedEisMode() {
        String str = this.get("eis-mode-values");
        return this.split(str);
    }

    public void setVideoStabilization(boolean toggle) {
        this.set(KEY_VIDEO_STABILIZATION, toggle ? TRUE : FALSE);
    }

    public boolean getVideoStabilization() {
        String str = this.get(KEY_VIDEO_STABILIZATION);
        return TRUE.equals(str);
    }

    public boolean isVideoStabilizationSupported() {
        String str = this.get(KEY_VIDEO_STABILIZATION_SUPPORTED);
        return TRUE.equals(str);
    }

    public void setProtectRecordingMode(boolean isMotionMode) {
        if (isMotionMode) {
            this.set(KEY_MOTION_DETECT_MODE, Integer.toString(1));
        } else {
            this.set(KEY_MOTION_DETECT_MODE, Integer.toString(0));
        }
    }

    public void setVideoEncodingBitRate(int mEncodingBitRate) {
        this.set(KEY_VIDEO_PARAM_ENCODING_BITRATE, Integer.toString(mEncodingBitRate));
        this.set(KEY_USER_SET_VIDEO_ENCODEBITRATE, Integer.toString(1));
    }

    public void setWaterMarkOffset(int offsetX, int offsetY) {
        String str = Integer.toString(offsetX) + "," + Integer.toString(offsetY);
        this.set(KEY_WATERMARK_OFFSET, str);
    }

    public void setWaterMarkTimerOffset(int offsetX, int offsetY) {
        String str = Integer.toString(offsetX) + "," + Integer.toString(offsetY);
        this.set(KEY_WATERMARK_TIMER_OFFSET, str);
    }

    public void setWaterMarkDataAddress(int address) {
        this.set(KEY_WATERMARK_ADDRESS, Integer.toString(address));
    }

    public void setWaterMarkSize(int width, int height) {
        String str = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_WATERMARK_SIZE, str);
    }

    public void setWaterMarkDataPath(String path) {
        this.set(KEY_WATERMARK_DATA_PATH, path);
    }

    public void setWaterMarkOwner(String ownerName) {
        this.set(KEY_WATERMARK_OWNER_NAME, ownerName);
    }

    public void setWhiteBalance(String value) {
        String oldValue = this.get(KEY_WHITE_BALANCE);
        if (this.same(value, oldValue)) {
            return;
        }
        this.set(KEY_WHITE_BALANCE, value);
        this.set(KEY_AUTO_WHITEBALANCE_LOCK, FALSE);
    }

    private boolean same(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s1.equals(s2);
    }

    public String getWhiteBalance() {
        return this.get(KEY_WHITE_BALANCE);
    }

    public List<String> getSupportedWhiteBalance() {
        int[] modeEnums = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AWB_AVAILABLE_MODES);
        List<String> modeNames = this.convertEnumToString(modeEnums);
        return modeNames;
    }

    private List<String> convertEnumToString(int[] enumIndexs) {
        ModeEnum[] modes = ModeEnum.values();
        ArrayList<String> names = new ArrayList<String>(enumIndexs.length);
        block0: for (int i = 0; i < enumIndexs.length; ++i) {
            int enumIndex = enumIndexs[i];
            for (ModeEnum mode : modes) {
                if (mode.getValue() != enumIndex) continue;
                String name = mode.getName().replace('_', '-').toLowerCase(Locale.ENGLISH);
                names.add(name);
                continue block0;
            }
        }
        return names;
    }

    private int convertStringToEnum(String value) {
        ModeEnum[] modes;
        int enumIndex = 0;
        for (ModeEnum mode : modes = ModeEnum.values()) {
            String modeName = mode.getName().replace('_', '-').toLowerCase(Locale.ENGLISH);
            if (!modeName.equalsIgnoreCase(value)) continue;
            enumIndex = mode.getValue();
        }
        return enumIndex;
    }

    public int getExposureCompensation() {
        return this.getInt(KEY_EXPOSURE_COMPENSATION, 0);
    }

    public void setAutoWhiteBalanceLock(boolean toggle) {
        this.set(KEY_AUTO_WHITEBALANCE_LOCK, toggle ? TRUE : FALSE);
    }

    public void setExposureCompensation(int value) {
        this.set(KEY_EXPOSURE_COMPENSATION, value);
    }

    public int getMaxExposureCompensation() {
        if (!this.isExposureCompensationSupported()) {
            return -1;
        }
        Range compensationRange = (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        return (Integer)compensationRange.getUpper();
    }

    public int getMinExposureCompensation() {
        if (!this.isExposureCompensationSupported()) {
            return -1;
        }
        Range compensationRange = (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        return (Integer)compensationRange.getLower();
    }

    public float getExposureCompensationStep() {
        if (!this.isExposureCompensationSupported()) {
            return -1.0f;
        }
        Rational compensationStep = (Rational)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_STEP);
        return (float)compensationStep.getNumerator() / (float)compensationStep.getDenominator();
    }

    public void setCameraId(int value) {
        this.set(KEY_VIDEO_PARAM_CAMERA_ID, value);
    }

    public void setCameraId(String value) {
        this.set(KEY_VIDEO_PARAM_CAMERA_ID, value);
    }

    public void setFreeSizeLimit(int limitSize) {
        this.set(KEY_FREE_SIZE_LIMIT, limitSize);
    }

    public void setAdasSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_ADAS_SIZE, v);
    }

    public void setAdasEndPoint(int value) {
        this.set(KEY_ADAS_END_POINT, value);
    }

    public void setAdasScaleFactor(float value) {
        this.set(KEY_ADAS_SCALE_FACTOR, value);
    }

    public void setAdasFocalLength(float value) {
        this.set(KEY_ADAS_FOCAL_LENGTH, value);
    }

    public void setImeiNumber(String imei) {
        this.set(KEY_IMEI_NUMBER, imei);
    }

    public void enableWatermarkText(boolean enable) {
        if (enable) {
            this.set(KEY_WATERMARK_TEXT_MODE, "on");
        } else {
            this.set(KEY_WATERMARK_TEXT_MODE, "off");
        }
    }

    public void setWatermarkTextArea(int left, int top, int right, int bottom) {
        String area = "(" + left + "," + top + "," + right + "," + bottom + ",1)";
        this.set(KEY_WATERMARK_AREA, area);
    }

    public void setWatermarkText(String text) {
        this.set(KEY_WATERMARK_TEXT, text);
    }

    public void setWatermarkTextEx1(String text) {
        this.set(KEY_WATERMARK_TEXT_EX1, text);
    }

    public void setWatermarkTextAreaEx1(int left, int top, int right, int bottom) {
        String area = "(" + left + "," + top + "," + right + "," + bottom + ",1)";
        this.set(KEY_WATERMARK_AREA_EX1, area);
    }

    public void setWatermarkTextEx2(String text) {
        this.set(KEY_WATERMARK_TEXT_EX2, text);
    }

    public void setWatermarkTextAreaEx2(int left, int top, int right, int bottom) {
        String area = "(" + left + "," + top + "," + right + "," + bottom + ",1)";
        this.set(KEY_WATERMARK_AREA_EX2, area);
    }

    public void setWatermarkTextEx3(String text) {
        this.set(KEY_WATERMARK_TEXT_EX3, text);
    }

    public void setWatermarkTextAreaEx3(int left, int top, int right, int bottom) {
        String area = "(" + left + "," + top + "," + right + "," + bottom + ",1)";
        this.set(KEY_WATERMARK_AREA_EX3, area);
    }

    public void setWatermarkTextSize(float size) {
        this.set(KEY_WATERMARK_TEXT_SIZE, size);
    }

    public void setWatermarkTextColor(int color) {
        this.set(KEY_WATERMARK_TEXT_COLOR, color);
    }

    public void setWatermarkTextColor(int a, int r, int g, int b) {
        int color = a << 24 & 0xFF000000 | r << 16 & 0xFF0000 | g << 8 & 0xFF00 | b & 0xFF;
        this.set(KEY_WATERMARK_TEXT_COLOR, color);
    }

    public void setWatermarkTextPosition(float x, float y) {
        this.set(KEY_WATERMARK_TEXT_X, x);
        this.set(KEY_WATERMARK_TEXT_Y, y);
    }

    public void setWatermarkFontFile(String file) {
        this.set(KEY_WATERMARK_FONT_FILE, file);
    }

    public void setWatermarkTimestampFormat(String format) {
        this.set(KEY_WATERMARK_TIMESTAMP_FORMAT, format);
    }

    public void setWatermarkPreviewEn(boolean enable) {
        if (enable) {
            this.set(KEY_WATERMARK_PREVIEW_EN, 1);
        } else {
            this.set(KEY_WATERMARK_PREVIEW_EN, 0);
        }
    }

    public void setWatermarkTimeMs(boolean enable) {
        if (enable) {
            this.set(KEY_WATERMARK_TIME_MS, 1);
        } else {
            this.set(KEY_WATERMARK_TIME_MS, 0);
        }
    }

    public void setWatermarkTextShadowRadius(float shadowRadius) {
        this.set(KEY_WATERMARK_TEXT_SHADOW_RADIUS, shadowRadius);
    }

    public void setWatermarkTextShadowOffset(float xOffset, float yOffset) {
        this.set(KEY_WATERMARK_TEXT_SHADOW_XOFFSET, xOffset);
        this.set(KEY_WATERMARK_TEXT_SHADOW_YOFFSET, yOffset);
    }

    public void setWatermarkTextShadowColor(int shadowColor) {
        this.set(KEY_WATERMARK_TEXT_SHADOW_COLOR, shadowColor);
    }

    public void enableWatermarkImage(boolean enable) {
        if (enable) {
            this.set(KEY_WATERMARK_IMG_MODE, "on");
        } else {
            this.set(KEY_WATERMARK_IMG_MODE, "off");
        }
    }

    public void setWatermarkImgPath(String path) {
        this.set(KEY_WATERMARK_IMG_PATH, path);
    }

    public void setWatermarkImgArea(int left, int top, int right, int bottom) {
        String area = "(" + left + "," + top + "," + right + "," + bottom + ",1)";
        this.set(KEY_WATERMARK_IMG_AREA, area);
    }

    public void setRecordingHint(boolean hint) {
        this.set(KEY_RECORDING_HINT, hint ? TRUE : FALSE);
    }

    public void setHdr(boolean enabled) {
        this.set(KEY_VIDEO_HDR, enabled ? "on" : "off");
    }

    public String getHdr() {
        String value = this.get(KEY_VIDEO_HDR);
        return value;
    }

    public List<String> getSuportedHdr() {
        String str = this.get("video-hdr-values");
        return this.split(str);
    }

    public String getColorEffect() {
        return this.get(KEY_EFFECT);
    }

    public void setColorEffect(String value) {
        this.set(KEY_EFFECT, value);
    }

    public List<String> getSupportedColorEffects() {
        String str = this.get("effect-values");
        return this.split(str);
    }

    public void setHdrMode(String mode) {
        if (!mode.isEmpty() && (mode.equals(VIDEO_HDR_MODE_IVHDR) || mode.equals(VIDEO_HDR_MODE_MVHDR))) {
            this.set(KEY_VIDEO_HDR_MODE, mode);
        }
    }

    public void setRotation(int rotation) {
        if (rotation != 0 && rotation != 90 && rotation != 180 && rotation != 270) {
            throw new IllegalArgumentException("Invalid rotation=" + rotation);
        }
        this.set(KEY_ROTATION, Integer.toString(rotation));
    }

    public void setVideoRotation(int rotation) {
        if (DEBUG) {
            Log.i((String)this.TAG, (String)("setVideoBufRotation: " + rotation));
        }
        this.set(KEY_VIDEO_ROTATION, rotation);
    }

    public void setPreviewMirror(boolean mirror) {
        if (DEBUG) {
            Log.i((String)this.TAG, (String)("setPreviewMirror: " + mirror));
        }
        this.set(KEY_PREVIEW_MIRROR, mirror ? 1 : 0);
    }

    public void setGpsLatitude(double latitude) {
        this.set(KEY_GPS_LATITUDE, Double.toString(latitude));
    }

    public void setGpsLongitude(double longitude) {
        this.set(KEY_GPS_LONGITUDE, Double.toString(longitude));
    }

    public void setGpsAltitude(double altitude) {
        this.set(KEY_GPS_ALTITUDE, Double.toString(altitude));
    }

    public void setGpsTimestamp(long timestamp) {
        this.set(KEY_GPS_TIMESTAMP, Long.toString(timestamp));
    }

    public void setGpsProcessingMethod(String processing_method) {
        this.set(KEY_GPS_PROCESSING_METHOD, processing_method);
    }

    public void removeGpsData() {
        this.remove(KEY_GPS_LATITUDE);
        this.remove(KEY_GPS_LONGITUDE);
        this.remove(KEY_GPS_ALTITUDE);
        this.remove(KEY_GPS_TIMESTAMP);
        this.remove(KEY_GPS_PROCESSING_METHOD);
    }

    public void setDropCamFrame(int interval) {
        this.set(KEY_DROP_CAMERA_FRAME, interval);
    }

    public void setDropStreamFrame(int streamPolicy, int usage) {
        if (this.mDropStreamFrameInfo == null) {
            this.mDropStreamFrameInfo = new ArrayList(5);
        }
        Pair<Integer, Integer> oldVal = null;
        for (Pair<Integer, Integer> pair : this.mDropStreamFrameInfo) {
            if (usage != (Integer)pair.second) continue;
            oldVal = pair;
            break;
        }
        if (oldVal != null) {
            this.mDropStreamFrameInfo.remove(oldVal);
        }
        Pair pair = new Pair((Object)streamPolicy, (Object)usage);
        this.mDropStreamFrameInfo.add((Pair<Integer, Integer>)pair);
    }

    public void enableFisheyeCorrection(boolean isEnable) {
        this.mFisheyeCorrection = new int[1];
        this.mFisheyeCorrection[0] = isEnable ? 1 : 0;
    }

    public void enableTimestampWithFrame(int isEnable) {
        this.set(KEY_FRAME_TIMESTAMP_FOR_PRV, isEnable);
        this.set(KEY_FRAME_TIMESTAMP_FOR_REC, isEnable);
    }

    public void enableTimestampForPrv(int isEnable) {
        this.set(KEY_FRAME_TIMESTAMP_FOR_PRV, isEnable);
    }

    public void enableTimestampForRec(int isEnable) {
        this.set(KEY_FRAME_TIMESTAMP_FOR_REC, isEnable);
    }

    public void enableVideoWithTimeCallback(boolean isEnable) {
        this.set(KEY_ENABLE_FILE_TIME, isEnable ? 1 : 0);
    }

    public void enableWarp(boolean enable) {
        this.set(KEY_WARP_MODE, enable ? "on" : "off");
    }

    public boolean isWarpEnable() {
        String str = this.get(KEY_WARP_MODE);
        return "on".equals(str);
    }

    public void setCamMode(int mode) {
        this.set(KEY_CAM_MODE, mode);
    }

    public void setSubFrameSize(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_EXT1_SIZE, v);
    }

    void setExt0Size(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_EXT0_SIZE, v);
    }

    void setExt0Format(String v) {
        this.set(KEY_EXT0_FMT, v);
    }

    void setExt1Size(int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        this.set(KEY_EXT1_SIZE, v);
    }

    void setExt1Format(String v) {
        this.set(KEY_EXT1_FMT, v);
    }

    public void setAVMDisplay(AVMCameraDisplay display) {
        this.set(KEY_AVM_DISPLAY, display.position);
    }

    public void setAvmCalibrationMode(int mode) {
        this.set(KEY_AVM_CALIBRATION_MODE, mode);
    }

    public void setAvmCalibration(boolean enable) {
        this.set(KEY_AVM_CALIBRATION, enable ? 1 : 2);
    }

    void setExtSize(int id, int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        if (id < 0 || id >= KEY_EXT_SIZE.length) {
            Log.e((String)this.TAG, (String)("setExtSize error : id=" + id + ",bug length is " + KEY_EXT_SIZE.length));
        }
        this.set(KEY_EXT_SIZE[id], v);
    }

    void setExtFormat(int id, String v) {
        if (id < 0 || id >= KEY_EXT_SIZE.length) {
            Log.e((String)this.TAG, (String)("setExtFormat error : id=" + id + ",bug length is " + KEY_EXT_SIZE.length));
        }
        this.set(KEY_EXT_FORMAT[id], v);
    }

    public String getAvmCalibIntRearStr() {
        String value = this.get(KEY_AVM_CALIB_INTREAR);
        return value;
    }

    public String getAvmCalibPosRearStr() {
        String value = this.get(KEY_AVM_CALIB_POSREAR);
        return value;
    }

    public String getAvmCalibDistCoeffRearStr() {
        String value = this.get(KEY_AVM_CALIB_DISTCOEFFREAR);
        return value;
    }

    public float[] getAvmCalibIntRear() {
        String value = this.get(KEY_AVM_CALIB_INTREAR);
        if (value == null) {
            Log.e((String)this.TAG, (String)"the value of KEY_AVM_CALIB_INTREAR is null, try again");
            return null;
        }
        float[] result = new float[9];
        this.String2FloatArray(value, result, 9, ',');
        return result;
    }

    public float[] getAvmCalibPosRear() {
        String value = this.get(KEY_AVM_CALIB_POSREAR);
        if (value == null) {
            Log.e((String)this.TAG, (String)"the value of KEY_AVM_CALIB_POSREAR is null, try again");
            return null;
        }
        float[] result = new float[3];
        this.String2FloatArray(value, result, 3, ',');
        return result;
    }

    public float[] getAvmCalibDistCoeffRear() {
        String value = this.get(KEY_AVM_CALIB_DISTCOEFFREAR);
        if (value == null) {
            Log.e((String)this.TAG, (String)"the value of KEY_AVM_CALIB_DISTCOEFFREAR is null, try again");
            return null;
        }
        float[] result = new float[4];
        this.String2FloatArray(value, result, 4, ',');
        return result;
    }

    boolean String2FloatArray(String value, float[] result, int num, char split) {
        if (!"".equals(value)) {
            TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(split);
            splitter.setString(value);
            int i = 0;
            for (String kv : splitter) {
                if (i > num) {
                    Log.e((String)this.TAG, (String)("size > " + num));
                    return false;
                }
                result[i] = Float.parseFloat(kv);
                ++i;
            }
            return true;
        }
        return false;
    }

    void setExtSurfaceSize(int id, int width, int height) {
        String v = Integer.toString(width) + "x" + Integer.toString(height);
        if (id < 0 || id >= KEY_EXT_SURFACE_SIZE.length) {
            Log.wtf((String)this.TAG, (String)("setExtSurfaceSize error : id=" + id + ",bug length is " + KEY_EXT_SIZE.length));
        }
        this.set(KEY_EXT_SURFACE_SIZE[id], v);
    }

    void setExtSurfaceFormat(int id, String v) {
        if (id < 0 || id >= KEY_EXT_SURFACE_SIZE.length) {
            Log.e((String)this.TAG, (String)("setExtSurfaceFormat error : id=" + id + ",bug length is " + KEY_EXT_SIZE.length));
        }
        this.set(KEY_EXT_SURFACE_FORMAT[id], v);
    }

    public void setAvmAlgo(int algo) {
        this.set(KEY_AVM_ALGO, algo);
    }

    void setFromRecordConfig(RecordConfiguration config) {
        String path = config.mOutPutFilePath;
        String fileName = config.mOutPutFileName;
        this.set(KEY_VIDEO_OUTPUT_FILE, path);
        this.set(KEY_VIDEO_OUTPUT_FILE_NAME, fileName);
        if (config.mLockFilePath != null) {
            this.set(KEY_VIDEO_LOCK_FILE, config.mLockFilePath);
        }
        if (config.mLockFileNamePrefix != null) {
            this.set(KEY_LOCK_FILE_NAME_PREFIX, config.mLockFileNamePrefix);
        }
        this.set(KEY_VIDEO_OUTPUT_FORMAT, Integer.toString(config.mCamcorderProfile.fileFormat));
        this.set(KEY_VIDEO_ENCODER, Integer.toString(config.mCamcorderProfile.videoCodec));
        this.setVideoSize(config.mCamcorderProfile.videoFrameWidth, config.mCamcorderProfile.videoFrameHeight);
        this.set(KEY_VIDEO_FRAME_RATE, Integer.toString(config.mCamcorderProfile.videoFrameRate));
        this.set(KEY_VIDEO_PARAM_ENCODING_BITRATE, Integer.toString(config.mCamcorderProfile.videoBitRate));
        this.set(KEY_AUDIO_SOURCE, config.mAudioSource);
        this.set(KEY_AUDIO_ENCODER, Integer.toString(config.mCamcorderProfile.audioCodec));
        this.set(KEY_AUDIO_PARAM_ENCODING_BITRATE, Integer.toString(config.mCamcorderProfile.audioBitRate));
        this.set(KEY_AUDIO_PARAM_NUMBER_OF_CHANNELS, Integer.toString(config.mCamcorderProfile.audioChannels));
        this.set(KEY_AUDIO_PARAM_SAMPLING_RATE, Integer.toString(config.mCamcorderProfile.audioSampleRate));
        int videoFrameMode = config.mVideoFrameMode;
        this.set(KEY_MAIN_VIDEO_FRAME_ENABLED, videoFrameMode);
        if (config.mRecordingMuteAudio) {
            this.set(KEY_VIDEO_MUTE_AIUDO, Integer.toString(1));
        } else {
            this.set(KEY_VIDEO_MUTE_AIUDO, Integer.toString(0));
        }
        this.set(KEY_KEYPOINT_SPAN_LIMIT, config.mKeypointSpanLimit);
        this.set(KEY_VIDCB_FRAMERATE, config.mVideoCbFrameRate);
        this.set(KEY_VIDEO_ROTATE_SIZE, Integer.toString(config.mVideoRotateSize));
        this.set(KEY_VIDEO_ROTATE_DURATION, Integer.toString(config.mVideoRotateDuration));
        this.set(KEY_REC_MUTE_OGG, config.mEnableRecordStartRing ? 0 : 1);
        this.set(KEY_VIDEO_PARAM_ENCODING_MINBITRATE, config.mVideoBitRateMin);
        this.set(KEY_VIDEO_PARAM_ENCODING_MAXBITRATE, config.mVideoBitRateMax);
        this.set(KEY_DELETE_FILE_NUM, config.mVideoCycleDeleteFileNum);
        this.set(KEY_REDUCE_REC_FPS, config.mReduceRecordingFps);
        this.set(KEY_ENABLE_ENCRYPT, config.mEnableEncryption ? 1 : 0);
        this.set(KEY_NOTIFY_ENCRYPT_TYPE, config.mEnableNotifyEncryptType ? 1 : 0);
        this.set(KEY_ENABLE_MPEG4_RECOVER, config.mEnableMPEG4Recover ? 1 : 0);
        this.set(KEY_SDCARD_SPEED_LIMIT, config.mSDCardSpeedLimit);
        this.set(KEY_ENABLE_MMAP_TYEPE, config.mEnableMmapType ? 1 : 0);
        this.set(KEY_DISABLE_CIRCULAR_DELETE, config.mDisableCircularDelete ? 1 : 0);
        this.set(KEY_SUB_STREAM_SHARE_AUDIO, config.mEnableSubStreamShareAudio ? 1 : 0);
    }

    void setCameraCharacteristics(CameraCharacteristics cameraCharacteristics) {
        this.mCameraCharacteristics = cameraCharacteristics;
    }

    void setRequestMetadata(CameraMetadataNative metadata) {
        this.mRequestMetadata = metadata;
    }

    CameraMetadataNative getRequestMetadata() {
        return this.mRequestMetadata;
    }

    void updateMetadata(CameraMetadataNative metadata, int usage) {
        if (metadata == null) {
            Log.e((String)this.TAG, (String)" updateMetadata is null");
            return;
        }
        if (CameraSurfaceUsage.isPicture(usage)) {
            this.resetFrameDrop(metadata);
        } else {
            this.mapFrameDrop(metadata);
        }
        this.mapHorizonFlip(metadata);
        this.mapSubVideoCrop(metadata);
        this.mapFisheyeCorrection(metadata);
        this.mapWatermark(metadata, usage);
        this.mapFpsRange(metadata, usage);
        this.mapSceneMode(metadata, usage);
        if (DEBUG) {
            Log.i((String)this.TAG, (String)(" updateMetadata usage: " + usage));
            metadata.dumpToLog();
        }
    }

    private void mapFisheyeCorrection(CameraMetadataNative metadata) {
        if (this.mFisheyeCorrection != null) {
            try {
                metadata.set(CAMERA_FISHEYE_CORRECTION, (Object)this.mFisheyeCorrection);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + CAMERA_FISHEYE_CORRECTION.getName()));
            }
        }
    }

    private void mapFrameDrop(CameraMetadataNative metadata) {
        int sensorMode = 1;
        int streamMode = 21;
        int[] interval = null;
        if (this.mDropStreamFrameInfo != null && this.mDropStreamFrameInfo.size() != 0) {
            int size = this.mDropStreamFrameInfo.size() * 2 + 2;
            interval = new int[size];
            interval[0] = streamMode;
            interval[1] = this.mDropStreamFrameInfo.size();
            int index = 2;
            for (Pair<Integer, Integer> pair : this.mDropStreamFrameInfo) {
                if (index < size) {
                    interval[index++] = (Integer)pair.first;
                    interval[index++] = (Integer)pair.second;
                    continue;
                }
                Log.e((String)this.TAG, (String)("Error: size " + size + "index " + index));
            }
        } else {
            int dropFrame = this.getInt(KEY_DROP_CAMERA_FRAME, 0);
            String strDropFrame = this.get(KEY_DROP_CAMERA_FRAME);
            interval = new int[]{0, 0};
            if (strDropFrame != null) {
                interval[0] = sensorMode;
            }
            interval[1] = dropFrame;
        }
        Log.e((String)this.TAG, (String)("mapFrameDrop " + Arrays.toString(interval)));
        try {
            metadata.set(CAMERA_FRAME_DROP_POLICY, (Object)interval);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)this.TAG, (String)("set fail:" + CAMERA_FRAME_DROP_POLICY.getName()));
        }
    }

    private void resetFrameDrop(CameraMetadataNative metadata) {
        int[] interval = new int[]{1, 0};
        try {
            metadata.set(CAMERA_FRAME_DROP_POLICY, (Object)interval);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)this.TAG, (String)("resetFrameDrop fail:" + CAMERA_FRAME_DROP_POLICY.getName()));
        }
    }

    void mapAeBlockMode(CameraMetadataNative metadata) {
        int aeBlockyMode = this.getInt(KEY_AE_BLOCK_Y_MODE, 0);
        try {
            metadata.set(AE_BLOCK_Y_MODE, (Object)aeBlockyMode);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)this.TAG, (String)("set fail:" + AE_BLOCK_Y_MODE.getName()));
        }
    }

    private void mapSubVideoCrop(CameraMetadataNative metadata) {
        int isCrop = this.getInt(KEY_SUB_VIDEO_CROP, 0);
        try {
            Log.e((String)this.TAG, (String)("yyyy   mapSubVideoCrop " + isCrop));
            metadata.set(CAMERA_SUB_VIDEO_CROP, (Object)isCrop);
        }
        catch (IllegalArgumentException e) {
            Log.e((String)this.TAG, (String)("set fail:" + CAMERA_SUB_VIDEO_CROP.getName()));
        }
    }

    private int[] getWatermarkArea(String area) {
        int[] ret = new int[4];
        if (area == null) {
            area = "(0,200,300,240)";
        }
        String str = area.replaceAll("\\(|\\)", "");
        String[] digstr = str.split(",");
        for (int i = 0; i < 4; ++i) {
            try {
                ret[i] = Integer.parseInt(digstr[i]);
                continue;
            }
            catch (NumberFormatException e) {
                Log.e((String)this.TAG, (String)("number format error: " + area));
                ret[i] = 0;
            }
        }
        return ret;
    }

    boolean isWatermarkEnable(int usage) {
        String watermarkTextMode = this.get(KEY_WATERMARK_TEXT_MODE);
        String watermarkImageMode = this.get(KEY_WATERMARK_IMG_MODE);
        boolean textEnable = "on".equals(watermarkTextMode);
        boolean imageEnable = "on".equals(watermarkImageMode);
        return textEnable || imageEnable;
    }

    private void mapWatermark(CameraMetadataNative metadata, int usage) {
        String watermarkTextMode = this.get(KEY_WATERMARK_TEXT_MODE);
        String watermarkImageMode = this.get(KEY_WATERMARK_IMG_MODE);
        if ("on".equals(watermarkTextMode)) {
            String watermarkText = this.get(KEY_WATERMARK_TEXT);
            String watermarkArea = this.get(KEY_WATERMARK_AREA);
            String watermarkTextEx1 = this.get(KEY_WATERMARK_TEXT_EX1);
            String watermarkAreaEx1 = this.get(KEY_WATERMARK_AREA_EX1);
            String watermarkTextEx2 = this.get(KEY_WATERMARK_TEXT_EX2);
            String watermarkAreaEx2 = this.get(KEY_WATERMARK_AREA_EX2);
            String watermarkTextEx3 = this.get(KEY_WATERMARK_TEXT_EX3);
            String watermarkAreaEx3 = this.get(KEY_WATERMARK_AREA_EX3);
            String watermarkSize = this.get(KEY_WATERMARK_SIZE);
            float watermarkTextSize = this.getFloat(KEY_WATERMARK_TEXT_SIZE, 1.0f);
            int watermarkTextColor = this.getInt(KEY_WATERMARK_TEXT_COLOR, -65536);
            String watermarkTextFont = this.get(KEY_WATERMARK_FONT_FILE);
            float[] watermarkTextPosition = new float[]{this.getFloat(KEY_WATERMARK_TEXT_X, 1.0f), this.getFloat(KEY_WATERMARK_TEXT_Y, 1.0f)};
            String watermarkOffset = this.get(KEY_WATERMARK_OFFSET);
            int watermarkTimeMs = this.getInt(KEY_WATERMARK_TIME_MS, 0);
            String watermarkTimerOffset = this.get(KEY_WATERMARK_TIMER_OFFSET);
            String watermarkFormat = this.get(KEY_WATERMARK_TIMESTAMP_FORMAT);
            int watermarkPreviewEn = this.getInt(KEY_WATERMARK_PREVIEW_EN, 1);
            try {
                metadata.set(WATERMARK_TEXT_ENABLE, (Object)1);
                metadata.set(WATERMARK_TEXT_SIZE, (Object)Float.valueOf(watermarkTextSize));
                metadata.set(WATERMARK_TEXT_COLOR, (Object)watermarkTextColor);
                metadata.set(WATERMARK_TEXT_FONTFILE, (Object)watermarkTextFont);
                metadata.set(WATERMARK_TEXT_POSITION, (Object)watermarkTextPosition);
                metadata.set(WATERMARK_TIME_MS, (Object)watermarkTimeMs);
                metadata.set(WATERMARK_TEXT, (Object)watermarkText);
                metadata.set(WATERMARK_TEXT_AREA, (Object)this.getWatermarkArea(watermarkArea));
                metadata.set(WATERMARK_TEXT_EX1, (Object)watermarkTextEx1);
                metadata.set(WATERMARK_TEXT_AREA_EX1, (Object)this.getWatermarkArea(watermarkAreaEx1));
                metadata.set(WATERMARK_TEXT_EX2, (Object)watermarkTextEx2);
                metadata.set(WATERMARK_TEXT_AREA_EX2, (Object)this.getWatermarkArea(watermarkAreaEx2));
                metadata.set(WATERMARK_TEXT_EX3, (Object)watermarkTextEx3);
                metadata.set(WATERMARK_TEXT_AREA_EX3, (Object)this.getWatermarkArea(watermarkAreaEx3));
                metadata.set(WATERMARK_FORMAT, (Object)watermarkFormat);
                metadata.set(WATERMARK_PREVIEW_EN, (Object)watermarkPreviewEn);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + e.getMessage()));
            }
        } else {
            try {
                metadata.set(WATERMARK_TEXT_ENABLE, (Object)0);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + WATERMARK_TEXT_ENABLE.getName()));
            }
        }
        if ("on".equals(watermarkImageMode)) {
            String watermarkImageArea = this.get(KEY_WATERMARK_IMG_AREA);
            String watermarkImagePath = this.get(KEY_WATERMARK_IMG_PATH);
            try {
                metadata.set(WATERMARK_IMAGE_ENABLE, (Object)1);
                metadata.set(WATERMARK_IMAGE_AREA, (Object)this.getWatermarkArea(watermarkImageArea));
                metadata.set(WATERMARK_IMAGE_PATH, (Object)watermarkImagePath);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)"set watermark image fail");
            }
        } else {
            try {
                metadata.set(WATERMARK_IMAGE_ENABLE, (Object)0);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + WATERMARK_IMAGE_ENABLE.getName()));
            }
        }
    }

    private void mapFpsRange(CameraMetadataNative metadata, int usage) {
        Range<Integer> fpsRange = null;
        fpsRange = this.mPreviwFpsRange;
        if (fpsRange != null) {
            try {
                metadata.set(CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE, fpsRange);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE.getName()));
            }
        }
    }

    private void mapSceneMode(CameraMetadataNative metadata, int usage) {
        String sceneMode = this.getSceneMode();
        if (sceneMode != null) {
            try {
                metadata.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)Integer.parseInt(sceneMode));
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("set fail:" + CaptureRequest.CONTROL_SCENE_MODE.getName()));
            }
        }
    }

    void setResultMetadata(CameraMetadataNative resultMetadata) {
        this.mResultMetadata = resultMetadata;
    }

    public int getSensorOrientation() {
        return (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    public Rect getSensorInfoActiveArraySize() {
        return (Rect)this.mCameraCharacteristics.get(CameraCharacteristics.SENSOR_INFO_ACTIVE_ARRAY_SIZE);
    }

    public float getAvailableMaxDigitalZoom() {
        return ((Float)this.mCameraCharacteristics.get(CameraCharacteristics.SCALER_AVAILABLE_MAX_DIGITAL_ZOOM)).floatValue();
    }

    public boolean isFlashSupported() {
        return (Boolean)this.mCameraCharacteristics.get(CameraCharacteristics.FLASH_INFO_AVAILABLE);
    }

    public boolean isHdrSceneSupported() {
        int[] availableSceneModes;
        for (int availableSceneMode : availableSceneModes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AVAILABLE_SCENE_MODES)) {
            if (availableSceneMode != 18) continue;
            return true;
        }
        return false;
    }

    public Integer getSupportedHardwareLevel() {
        Integer supportedHardwareLevel = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
        return supportedHardwareLevel;
    }

    public int[] getSupportedFaceDetectModes() {
        int[] modes = (int[])this.mCameraCharacteristics.get(CameraCharacteristics.STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES);
        return modes;
    }

    public boolean isExposureCompensationSupported() {
        Range compensationRange = (Range)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_COMPENSATION_RANGE);
        return (Integer)compensationRange.getLower() != 0 || (Integer)compensationRange.getUpper() != 0;
    }

    public boolean isAutoFocusSupported() {
        Integer maxAfRegions = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
        return maxAfRegions != null && maxAfRegions > 0;
    }

    public boolean isAutoExposureSupported() {
        Integer maxAeRegions = (Integer)this.mCameraCharacteristics.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
        return maxAeRegions != null && maxAeRegions > 0;
    }

    public void setAeBlockMode(int mode) {
        this.set(KEY_AE_BLOCK_Y_MODE, mode);
    }

    int[] getResultAeBlockValue() {
        int[] value = new int[25];
        if (this.mResultMetadata != null) {
            try {
                value = (int[])this.mResultMetadata.get(AE_BLOCK_Y_VALUES);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)this.TAG, (String)("get fail:" + AE_BLOCK_Y_VALUES.getName()));
            }
        }
        return value;
    }

    public <T> void set(CaptureRequest.Key<T> key, T value) {
        this.mRequestMetadata.set(key, value);
    }

    public <T> void set(CaptureResult.Key<T> key, T value) {
        this.mRequestMetadata.set(key, value);
    }

    public <T> void set(CameraCharacteristics.Key<T> key, T value) {
        this.mRequestMetadata.set(key, value);
    }

    public <T> T get(CameraCharacteristics.Key<T> key) {
        return (T)this.mRequestMetadata.get(key.getNativeKey());
    }

    public <T> T get(CaptureResult.Key<T> key) {
        return (T)this.mRequestMetadata.get(key.getNativeKey());
    }

    public <T> T get(CaptureRequest.Key<T> key) {
        return (T)this.mRequestMetadata.get(key.getNativeKey());
    }

    public void setVehicleLongitude(String longitude) {
        this.set(KEY_VEHICLE_LONGITUDE, longitude);
    }

    public void setVehicleLatitude(String latitude) {
        this.set(KEY_VEHICLE_LATITUDE, latitude);
    }

    public void setVehicleSpeed(int speed) {
        this.set(KEY_VEHICLE_SPEED, speed);
    }

    public void setVehicleGearStatus(VehicleGearStatus gearStatus) {
        this.set(KEY_VEHICLE_GEAR_STATUS, gearStatus.gearStatus);
    }

    public void setVehicleAccelerator(int accelerator) {
        this.set(KEY_VEHICLE_ACCELERATOR, accelerator);
    }

    public void setVehicleBrake(boolean brake) {
        this.set(KEY_VEHICLE_BRAKE, brake ? 1 : 0);
    }

    public void setVehicleLeftSignal(boolean leftSignal) {
        this.set(KEY_VEHICLE_LEFT_SIGNAL, leftSignal ? 1 : 0);
    }

    public void setVehicleRightSignal(boolean rightSignal) {
        this.set(KEY_VEHICLE_RIGHT_SIGNAL, rightSignal ? 1 : 0);
    }

    public void setVehicleSafetybelt(boolean safetybelt) {
        this.set(KEY_VEHICLE_SAFETYBELT, safetybelt ? 1 : 0);
    }

    public void setVehicleAdasStatus(int adasStatus) {
        this.set(KEY_VEHICLE_ADAS_STATUS, adasStatus);
    }

    public void setVehicleLanuage(int lanuage) {
        this.set(KEY_VEHICLE_LANUAGE, lanuage);
    }

    static enum ModeEnum {
        OFF(0),
        AUTO(1),
        INCANDESCENT(2),
        FLUORESCENT(3),
        WARM_FLUORESCENT(4),
        DAYLIGHT(5),
        CLOUDY_DAYLIGHT(6),
        TWILIGHT(7),
        SHADE(8);

        private int mValue = 0;

        private ModeEnum(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public String getName() {
            return this.toString();
        }
    }

    public static enum VehicleGearStatus {
        GEAR_STATUS_P(0),
        GEAR_STATUS_N(1),
        GEAR_STATUS_R(2),
        GEAR_STATUS_D(3),
        GEAR_STATUS_M(4),
        GEAR_STATUS_I(5);

        final int gearStatus;

        private VehicleGearStatus(int gearStatus) {
            this.gearStatus = gearStatus;
        }

        public int getGearStatus() {
            return this.gearStatus;
        }
    }

    public static enum AVMCameraDisplay {
        FRONT(0),
        LEFT(1),
        RIGHT(2),
        BACK(3),
        NONE(-1);

        final int position;

        private AVMCameraDisplay(int position) {
            this.position = position;
        }

        public int getPosition() {
            return this.position;
        }
    }

    public class Size {
        public int width;
        public int height;

        public Size(int w, int h) {
            this.width = w;
            this.height = h;
        }

        public Size(android.util.Size size) {
            this.width = size.getWidth();
            this.height = size.getHeight();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Size)) {
                return false;
            }
            Size s = (Size)obj;
            return this.width == s.width && this.height == s.height;
        }

        public int hashCode() {
            return this.width * 32713 + this.height;
        }
    }
}

