/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.hardware.CameraStatus;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.mediatek.smartplatform.ICarCamDeviceUser;
import com.mediatek.smartplatform.ISmartPlatformEventListener;
import com.mediatek.smartplatform.SimpleCommand;
import java.util.ArrayList;
import java.util.List;

public interface ISmartPlatformService
extends IInterface {
    public int addListener(ISmartPlatformEventListener var1) throws RemoteException;

    public int removeListener(ISmartPlatformEventListener var1) throws RemoteException;

    public void notifyListener(int var1, int var2, int var3) throws RemoteException;

    public int sendCommand(int var1, int var2, int var3) throws RemoteException;

    public void sendCollisionCommand(SimpleCommand var1) throws RemoteException;

    public void sendCarCommand(SimpleCommand var1) throws RemoteException;

    public int postIpodCommand(String var1, String var2) throws RemoteException;

    public ICarCamDeviceUser connectDevice(String var1) throws RemoteException;

    public ICarCamDeviceUser connectAvmDevice(String var1) throws RemoteException;

    public int disconnectDevice(String var1) throws RemoteException;

    public int disconnectAvmDevice() throws RemoteException;

    public int setDeviceType(int var1) throws RemoteException;

    public int setJpegHwEncState(int var1) throws RemoteException;

    public int getJpegHwEncState() throws RemoteException;

    public List<String> getAvmCameraInfo() throws RemoteException;

    public String getAvmCameraId() throws RemoteException;

    public CameraMetadataNative getCameraCharacteristics(String var1) throws RemoteException;

    public CameraStatus[] addCameraListener(ICameraServiceListener var1) throws RemoteException;

    public void removeCameraListener(ICameraServiceListener var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISmartPlatformService {
        private static final String DESCRIPTOR = "com.mediatek.smartplatform.ISmartPlatformService";
        static final int TRANSACTION_addListener = 1;
        static final int TRANSACTION_removeListener = 2;
        static final int TRANSACTION_notifyListener = 3;
        static final int TRANSACTION_sendCommand = 4;
        static final int TRANSACTION_sendCollisionCommand = 5;
        static final int TRANSACTION_sendCarCommand = 6;
        static final int TRANSACTION_postIpodCommand = 7;
        static final int TRANSACTION_connectDevice = 8;
        static final int TRANSACTION_connectAvmDevice = 9;
        static final int TRANSACTION_disconnectDevice = 10;
        static final int TRANSACTION_disconnectAvmDevice = 11;
        static final int TRANSACTION_setDeviceType = 12;
        static final int TRANSACTION_setJpegHwEncState = 13;
        static final int TRANSACTION_getJpegHwEncState = 14;
        static final int TRANSACTION_getAvmCameraInfo = 15;
        static final int TRANSACTION_getAvmCameraId = 16;
        static final int TRANSACTION_getCameraCharacteristics = 17;
        static final int TRANSACTION_addCameraListener = 18;
        static final int TRANSACTION_removeCameraListener = 19;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ISmartPlatformService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ISmartPlatformService) {
                return (ISmartPlatformService)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    ISmartPlatformEventListener _arg0 = ISmartPlatformEventListener.Stub.asInterface(data.readStrongBinder());
                    int _result = this.addListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ISmartPlatformEventListener _arg0 = ISmartPlatformEventListener.Stub.asInterface(data.readStrongBinder());
                    int _result = this.removeListener(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.notifyListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.sendCommand(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    SimpleCommand _arg0 = 0 != data.readInt() ? (SimpleCommand)SimpleCommand.CREATOR.createFromParcel(data) : null;
                    this.sendCollisionCommand(_arg0);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    SimpleCommand _arg0 = 0 != data.readInt() ? (SimpleCommand)SimpleCommand.CREATOR.createFromParcel(data) : null;
                    this.sendCarCommand(_arg0);
                    reply.writeNoException();
                    if (_arg0 != null) {
                        reply.writeInt(1);
                        _arg0.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    int _result = this.postIpodCommand(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ICarCamDeviceUser _result = this.connectDevice(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ICarCamDeviceUser _result = this.connectAvmDevice(_arg0);
                    reply.writeNoException();
                    reply.writeStrongBinder(_result != null ? _result.asBinder() : null);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.disconnectDevice(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _result = this.disconnectAvmDevice();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.setDeviceType(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.setJpegHwEncState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _result = this.getJpegHwEncState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    List _result = this.getAvmCameraInfo();
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _result = this.getAvmCameraId();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CameraMetadataNative _result = this.getCameraCharacteristics(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    ICameraServiceListener _arg0 = ICameraServiceListener.Stub.asInterface((IBinder)data.readStrongBinder());
                    CameraStatus[] _result = this.addCameraListener(_arg0);
                    reply.writeNoException();
                    reply.writeTypedArray((Parcelable[])_result, 1);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    ICameraServiceListener _arg0 = ICameraServiceListener.Stub.asInterface((IBinder)data.readStrongBinder());
                    this.removeCameraListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISmartPlatformService impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISmartPlatformService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISmartPlatformService {
            private IBinder mRemote;
            public static ISmartPlatformService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addListener(ISmartPlatformEventListener listener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addListener(listener);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeListener(ISmartPlatformEventListener listener) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().removeListener(listener);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyListener(int event, int arg1, int arg2) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(event);
                    _data.writeInt(arg1);
                    _data.writeInt(arg2);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyListener(event, arg1, arg2);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int sendCommand(int cmd, int arg1, int arg2) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(cmd);
                    _data.writeInt(arg1);
                    _data.writeInt(arg2);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().sendCommand(cmd, arg1, arg2);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCollisionCommand(SimpleCommand command) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (command != null) {
                        _data.writeInt(1);
                        command.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendCollisionCommand(command);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        command.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendCarCommand(SimpleCommand command) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (command != null) {
                        _data.writeInt(1);
                        command.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().sendCarCommand(command);
                        return;
                    }
                    _reply.readException();
                    if (0 != _reply.readInt()) {
                        command.readFromParcel(_reply);
                    }
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int postIpodCommand(String cmd, String params) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cmd);
                    _data.writeString(params);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().postIpodCommand(cmd, params);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICarCamDeviceUser connectDevice(String cameraId) throws RemoteException {
                ICarCamDeviceUser _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICarCamDeviceUser iCarCamDeviceUser = Stub.getDefaultImpl().connectDevice(cameraId);
                        return iCarCamDeviceUser;
                    }
                    _reply.readException();
                    _result = ICarCamDeviceUser.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ICarCamDeviceUser connectAvmDevice(String cameraId) throws RemoteException {
                ICarCamDeviceUser _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ICarCamDeviceUser iCarCamDeviceUser = Stub.getDefaultImpl().connectAvmDevice(cameraId);
                        return iCarCamDeviceUser;
                    }
                    _reply.readException();
                    _result = ICarCamDeviceUser.Stub.asInterface(_reply.readStrongBinder());
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disconnectDevice(String cameraId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().disconnectDevice(cameraId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int disconnectAvmDevice() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().disconnectAvmDevice();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setDeviceType(int deviceType) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(deviceType);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setDeviceType(deviceType);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int setJpegHwEncState(int state) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().setJpegHwEncState(state);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getJpegHwEncState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getJpegHwEncState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getAvmCameraInfo() throws RemoteException {
                ArrayList _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getAvmCameraInfo();
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getAvmCameraId() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getAvmCameraId();
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraMetadataNative getCameraCharacteristics(String cameraId) throws RemoteException {
                CameraMetadataNative _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(cameraId);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CameraMetadataNative cameraMetadataNative = Stub.getDefaultImpl().getCameraCharacteristics(cameraId);
                        return cameraMetadataNative;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (CameraMetadataNative)CameraMetadataNative.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraStatus[] addCameraListener(ICameraServiceListener listener) throws RemoteException {
                CameraStatus[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CameraStatus[] cameraStatusArray = Stub.getDefaultImpl().addCameraListener(listener);
                        return cameraStatusArray;
                    }
                    _reply.readException();
                    _result = (CameraStatus[])_reply.createTypedArray(CameraStatus.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeCameraListener(ICameraServiceListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeCameraListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISmartPlatformService {
        @Override
        public int addListener(ISmartPlatformEventListener listener) throws RemoteException {
            return 0;
        }

        @Override
        public int removeListener(ISmartPlatformEventListener listener) throws RemoteException {
            return 0;
        }

        @Override
        public void notifyListener(int event, int arg1, int arg2) throws RemoteException {
        }

        @Override
        public int sendCommand(int cmd, int arg1, int arg2) throws RemoteException {
            return 0;
        }

        @Override
        public void sendCollisionCommand(SimpleCommand command) throws RemoteException {
        }

        @Override
        public void sendCarCommand(SimpleCommand command) throws RemoteException {
        }

        @Override
        public int postIpodCommand(String cmd, String params) throws RemoteException {
            return 0;
        }

        @Override
        public ICarCamDeviceUser connectDevice(String cameraId) throws RemoteException {
            return null;
        }

        @Override
        public ICarCamDeviceUser connectAvmDevice(String cameraId) throws RemoteException {
            return null;
        }

        @Override
        public int disconnectDevice(String cameraId) throws RemoteException {
            return 0;
        }

        @Override
        public int disconnectAvmDevice() throws RemoteException {
            return 0;
        }

        @Override
        public int setDeviceType(int deviceType) throws RemoteException {
            return 0;
        }

        @Override
        public int setJpegHwEncState(int state) throws RemoteException {
            return 0;
        }

        @Override
        public int getJpegHwEncState() throws RemoteException {
            return 0;
        }

        @Override
        public List<String> getAvmCameraInfo() throws RemoteException {
            return null;
        }

        @Override
        public String getAvmCameraId() throws RemoteException {
            return null;
        }

        @Override
        public CameraMetadataNative getCameraCharacteristics(String cameraId) throws RemoteException {
            return null;
        }

        @Override
        public CameraStatus[] addCameraListener(ICameraServiceListener listener) throws RemoteException {
            return null;
        }

        @Override
        public void removeCameraListener(ICameraServiceListener listener) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

