package com.intergration.avm.presentation

import android.app.Presentation
import android.content.Context
import android.os.Bundle
import android.view.Display
import android.widget.FrameLayout
import com.intergration.avm.R
import com.intergration.avm.utils.IMAGE_HEIGHT
import com.intergration.avm.utils.IMAGE_WIDTH
import com.mediatek.smartplatform.PictureConfiguration
import com.intergration.avm.glsurface.MyGLSurfaceView

class AuxiliaryScreenPresentation(outerContext: Context, display: Display) :
    Presentation(outerContext, display) {

    private lateinit var pictureConfig:PictureConfiguration

    lateinit var frameLayout: FrameLayout

    private lateinit var rendererView: MyGLSurfaceView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        frameLayout = layoutInflater.inflate(R.layout.layout_presentation,null) as FrameLayout
        setContentView(frameLayout)
        rendererView = frameLayout.findViewById<MyGLSurfaceView?>(R.id.rendererView).also {
            it.setYuvDataSize(IMAGE_HEIGHT,IMAGE_WIDTH)
        }
    }

    /**
     * 打印辅屏的宽和高
     */
    private fun windowWidthAndHeightTest() {
        val height = context.resources.displayMetrics.heightPixels
        val width = context.resources.displayMetrics.widthPixels
    }

    /**
     * EventBus注册
     */
    override fun show() {
        super.show()
//        if (!EventBus.getDefault().isRegistered(this)) {
//            EventBus.getDefault().register(this)
//        }
    }

    /**
     * EventBus解注册
     */
    override fun dismiss() {
//        if (EventBus.getDefault().isRegistered(this)) {
//            EventBus.getDefault().unregister(this)
//        }
        super.dismiss()
    }


    fun feedData(data:ByteArray){
        rendererView.feedData(data,2)
    }

    @Synchronized
    fun setDisplayOrientation(degree:Int){
        rendererView.setDisplayOrientation(degree)
    }

    @Synchronized
    fun setYuvDataSize(width:Int,height:Int){
        rendererView.setYuvDataSize(width,height)
    }

}