package com.intergration.avm.presentation

import android.app.Service
import android.content.Context
import android.content.Intent
import android.hardware.display.DisplayManager
import android.os.Binder
import android.os.Build
import android.os.IBinder
import android.view.Display
import android.view.WindowManager
import com.blankj.utilcode.util.LogUtils

class MultiScreenService : Service() {


    /**屏幕管理器*/
    private var mDisplayManager: DisplayManager? = null

    /**屏幕数组*/
    private lateinit var displays: Array<Display>

    /**辅屏*/
    private var presentation: AuxiliaryScreenPresentation? = null

    override fun onBind(intent: Intent): IBinder {
        return MultiScreenBinder()
    }


    override fun onCreate() {
        super.onCreate()
        initPresentation()
    }

    /** 初始化第二块屏幕  */
    private fun initPresentation() {
        if (null == presentation) {
            mDisplayManager = this.getSystemService(Context.DISPLAY_SERVICE) as DisplayManager
            displays = mDisplayManager?.displays as Array<Display>
            if (displays.size > 1) {
                // displays[1]是副屏
                presentation = AuxiliaryScreenPresentation(this, displays[1])
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O){//8.0
                    presentation?.window?.setType(WindowManager.LayoutParams.TYPE_APPLICATION_OVERLAY)
                }else {
                    presentation?.window?.setType(WindowManager.LayoutParams.TYPE_SYSTEM_OVERLAY)
                }

            }
        }
    }

    /** 显示第二块屏  */
    fun showSecondPresentation() {
        LogUtils.d("showSecondPresentation")
        presentation?.show()
    }

    fun dismissSecondPresentation(){
        presentation?.dismiss()
    }

    fun setSecondPresentationContentView(layoutID:Int){
        presentation?.setContentView(layoutID)
    }

    fun feedNv21Data(data:ByteArray){
        presentation?.feedData(data)
    }

//    fun setDisplayOrientation(degree:Int){
//        presentation?.setDisplayOrientation(270)
//    }
//
//    fun setYuvDataSize(width:Int,height:Int){
//        presentation?.setYuvDataSize(width,height)
//    }

    inner class MultiScreenBinder : Binder() {
        fun getService(): MultiScreenService {
            return this@MultiScreenService
        }
    }
}