/*
 * Decompiled with CFR 0.152.
 */
package com.arcsoft.visdrive.avmsdk;

import android.text.TextUtils;
import androidx.annotation.Keep;
import com.arcsoft.visdrive.avmsdk.ArcErrorInfo;
import com.arcsoft.visdrive.avmsdk.constant.avm.ArcAVMCameraPosType;
import com.arcsoft.visdrive.avmsdk.constant.avm.ArcAVMType;
import com.arcsoft.visdrive.avmsdk.constant.avm.ArcAVMViewPortType;
import com.arcsoft.visdrive.avmsdk.constant.common.ArcImageFormat;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMCalibInfo;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMCalibResult;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMChessInfo;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMClothInfo;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMImageBrightness;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMInitParam;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMInputImage;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMIntrinsicParam;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMLookupTable;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMOutputImage;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMPerPixelDistance;
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMReverseAuxLinePoint;
import com.arcsoft.visdrive.avmsdk.model.common.ArcActivateStatus;
import com.arcsoft.visdrive.avmsdk.model.common.ArcActiveEnvParam;
import com.arcsoft.visdrive.avmsdk.model.common.ArcActiveFileInfo;
import com.arcsoft.visdrive.avmsdk.model.common.ArcImportLicenseInfo;
import com.arcsoft.visdrive.avmsdk.model.common.ArcLicenseFileInfo;
import com.arcsoft.visdrive.avmsdk.model.common.ArcPointF;
import com.arcsoft.visdrive.avmsdk.model.common.ArcRect;
import com.arcsoft.visdrive.avmsdk.model.common.ArcVersionInfo;
import java.util.ArrayList;
import java.util.List;

@Keep
public class ArcVisDriveAVMEngine {
    public static final int LICENSE_FILE_INFO_SIZE_MAX = 2048;
    public static final int AVM_INPUT_CAMERA_IMAGE_COUNT = 4;
    public static final int AVM_OUTPUT_CAMERA_IMAGE_SIZE_MAX = 5;
    public long handle = 0L;
    public final ArcErrorInfo initArcErrorInfo;
    public final ArcErrorInfo drawErrorInfo;
    public ArcAVMOutputImage[] outImageInfoArray;

    public ArcVisDriveAVMEngine() {
        ArcErrorInfo arcErrorInfo;
        ArcErrorInfo arcErrorInfo2;
        Object object = arcErrorInfo2;
        arcErrorInfo2 = new ArcErrorInfo();
        v1.initArcErrorInfo = object;
        object = arcErrorInfo;
        arcErrorInfo = new ArcErrorInfo();
        v1.drawErrorInfo = object;
    }

    public static int activate(String string, String string2, ArcAVMType arcAVMType, ArcActiveEnvParam arcActiveEnvParam) {
        if (string != null && string2 != null && arcActiveEnvParam != null) {
            String string3 = arcActiveEnvParam.storagePath;
            if (string3 != null && string3.length() <= 100) {
                string3 = arcActiveEnvParam.IMEI;
                if (string3 != null && string3.length() > 40) {
                    return -2;
                }
                return ArcVisDriveAVMEngine.nativeActivate(string, string2, arcAVMType.getValue(), arcActiveEnvParam);
            }
            return -2;
        }
        return -2;
    }

    public static native int nativeActivate(String var0, String var1, int var2, ArcActiveEnvParam var3);

    public static int getActivateFileInfo(String string, ArcActiveFileInfo arcActiveFileInfo) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -2;
        }
        if (string.length() >= 2056) {
            return -2;
        }
        if (arcActiveFileInfo == null) {
            return -2;
        }
        return ArcVisDriveAVMEngine.nativeGetActivateFileInfo(string, arcActiveFileInfo);
    }

    public static native int nativeGetActivateFileInfo(String var0, ArcActiveFileInfo var1);

    public static int importLicenseInfo(ArcImportLicenseInfo arcImportLicenseInfo) {
        if (arcImportLicenseInfo == null) {
            return -2;
        }
        String string = arcImportLicenseInfo.licenseInfo;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -2;
        }
        if (string.length() > 2048) {
            return -2;
        }
        return ArcVisDriveAVMEngine.nativeImportLicenseInfo(arcImportLicenseInfo);
    }

    public static native int nativeImportLicenseInfo(ArcImportLicenseInfo var0);

    public static int getLicenseFileInfo(String string, ArcLicenseFileInfo arcLicenseFileInfo) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -2;
        }
        if (string.length() >= 2056) {
            return -2;
        }
        if (arcLicenseFileInfo == null) {
            return -2;
        }
        return ArcVisDriveAVMEngine.nativeGetLicenseFileInfo(string, arcLicenseFileInfo);
    }

    public static native int nativeGetLicenseFileInfo(String var0, ArcLicenseFileInfo var1);

    public static int getActivateStatus(ArcAVMType arcAVMType, ArcActivateStatus arcActivateStatus) {
        if (arcActivateStatus == null) {
            return -2;
        }
        return ArcVisDriveAVMEngine.nativeGetActivateStatus(arcAVMType.getValue(), arcActivateStatus);
    }

    public static native int nativeGetActivateStatus(int var0, ArcActivateStatus var1);

    public static int getVersionInfo(ArcVersionInfo arcVersionInfo) {
        if (arcVersionInfo == null) {
            return -2;
        }
        ArcVisDriveAVMEngine.nativeGetVersion(arcVersionInfo);
        return 0;
    }

    public static native void nativeGetVersion(ArcVersionInfo var0);

    private native long nativeInit(ArcAVMIntrinsicParam[] var1, ArcAVMCalibInfo var2, ArcAVMCalibResult var3, ArcAVMLookupTable var4, ArcErrorInfo var5);

    private native int nativeUnInit(long var1);

    /*
     * Enabled aggressive block sorting
     */
    private boolean checkInputImageInfo(List<ArcAVMInputImage> iterator) {
        boolean bl = true;
        iterator = iterator.iterator();
        do {
            if (!iterator.hasNext()) return bl;
            ArcAVMInputImage arcAVMInputImage = (ArcAVMInputImage)iterator.next();
            if (arcAVMInputImage.imageData == null) return false;
            boolean bl2 = true;
            if (!bl2) return bl2;
            if (arcAVMInputImage.width <= 0) return false;
            if (arcAVMInputImage.height <= 0) return false;
            bl2 = true;
            if (!bl2) {
                return bl2;
            }
            if (arcAVMInputImage.imageFormat != ArcImageFormat.ARC_IMAGE_FORMAT_NV12.getValue()) {
                if (arcAVMInputImage.imageFormat != ArcImageFormat.ARC_IMAGE_FORMAT_NV21.getValue()) return false;
            }
            bl = true;
        } while (bl);
        return bl;
    }

    private native int nativeAutoCalibrate(long var1, ArcAVMInputImage[] var3, ArcAVMClothInfo var4, ArcAVMChessInfo[] var5, ArcAVMCalibResult var6, ArcAVMLookupTable var7);

    private native int nativeManualCalibrate(long var1, ArcAVMInputImage[] var3, ArcAVMClothInfo var4, ArcAVMChessInfo[] var5, ArcAVMCalibResult var6, ArcAVMLookupTable var7);

    private native int nativeGetCalibrateResults(long var1, ArcAVMCalibInfo var3, ArcAVMCalibResult var4, ArcAVMLookupTable var5);

    private native int nativeSetImageBrightness(long var1, ArcAVMImageBrightness var3);

    private native int nativeGetImageBrightness(long var1, ArcAVMImageBrightness var3);

    private native int nativeGetPerPixelDistance(long var1, ArcAVMPerPixelDistance var3);

    private native int nativeGetReverseAuxLinePoint(long var1, int var3, ArcPointF[] var4);

    private native int nativeGetCarModelRect(long var1, ArcRect var3);

    static {
        System.loadLibrary("ArcSoftVisDriveEngine");
    }

    public int init(ArcAVMInitParam object) {
        if (this.handle != 0L) {
            return -10000;
        }
        if (object == null) {
            return -2;
        }
        Object object2 = object.avmIntrinsicParamArray;
        if (object.avmIntrinsicParamArray != null && ((ArcAVMIntrinsicParam[])object2).length == 4) {
            object2 = object.avmCalibInfo;
            if (object2 != null && object2.avmCarInfo != null) {
                if (object2.avm2DImageWidth > 0 && object2.avm2DImageHeight > 0 && object2.singleImageWidth > 0 && object2.singleImageHeight > 0) {
                    if (object2.viewPortType >= ArcAVMViewPortType.SMALL.getValue() && object2.viewPortType <= ArcAVMViewPortType.LARGE.getValue()) {
                        Object object3;
                        Object object4 = object.avmCalibResult;
                        if (object4 != null) {
                            object3 = ((ArcAVMCalibResult)object4).data;
                            if (((ArcAVMCalibResult)object4).data == null || ((byte[])object3).length != ((ArcAVMCalibResult)object4).dataSize) {
                                return -2;
                            }
                        }
                        if ((object4 = object.avmLookupTable) != null) {
                            object3 = ((ArcAVMLookupTable)object4).data;
                            if (((ArcAVMLookupTable)object4).data == null || ((byte[])object3).length != ((ArcAVMLookupTable)object4).dataSize) {
                                return -2;
                            }
                        }
                        ArcVisDriveAVMEngine arcVisDriveAVMEngine = this;
                        object = object.avmIntrinsicParamArray;
                        object4 = object.avmCalibResult;
                        object3 = object.avmLookupTable;
                        ArcErrorInfo arcErrorInfo = arcVisDriveAVMEngine.initArcErrorInfo;
                        arcVisDriveAVMEngine.handle = arcVisDriveAVMEngine.nativeInit((ArcAVMIntrinsicParam[])object, (ArcAVMCalibInfo)object2, (ArcAVMCalibResult)object4, (ArcAVMLookupTable)object3, arcErrorInfo);
                        if (arcVisDriveAVMEngine.initArcErrorInfo.getErrorCode() == 0) {
                            ArcAVMOutputImage arcAVMOutputImage;
                            ArcAVMOutputImage arcAVMOutputImage2;
                            ArcAVMOutputImage arcAVMOutputImage3;
                            ArcAVMOutputImage arcAVMOutputImage4;
                            ArcAVMOutputImage arcAVMOutputImage5;
                            ArcVisDriveAVMEngine arcVisDriveAVMEngine2 = this;
                            ArcAVMOutputImage[] arcAVMOutputImageArray = new ArcAVMOutputImage[5];
                            this.outImageInfoArray = arcAVMOutputImageArray;
                            object = arcAVMOutputImage5;
                            arcAVMOutputImage5 = new ArcAVMOutputImage(object2.avm2DImageWidth * object2.avm2DImageHeight * 3 / 2);
                            arcAVMOutputImageArray[0] = object;
                            arcVisDriveAVMEngine2.outImageInfoArray[0].avmDrawImageType = 1;
                            object = arcAVMOutputImage4;
                            arcAVMOutputImage4 = new ArcAVMOutputImage(object2.singleImageWidth * object2.singleImageHeight * 3 / 2);
                            arcVisDriveAVMEngine2.outImageInfoArray[1] = object;
                            arcVisDriveAVMEngine2.outImageInfoArray[1].avmDrawImageType = 2;
                            object = arcAVMOutputImage3;
                            arcAVMOutputImage3 = new ArcAVMOutputImage(object2.singleImageWidth * object2.singleImageHeight * 3 / 2);
                            arcVisDriveAVMEngine2.outImageInfoArray[2] = object;
                            arcVisDriveAVMEngine2.outImageInfoArray[2].avmDrawImageType = 4;
                            object = arcAVMOutputImage2;
                            arcAVMOutputImage2 = new ArcAVMOutputImage(object2.singleImageWidth * object2.singleImageHeight * 3 / 2);
                            arcVisDriveAVMEngine2.outImageInfoArray[3] = object;
                            arcVisDriveAVMEngine2.outImageInfoArray[3].avmDrawImageType = 8;
                            object = arcAVMOutputImage;
                            arcAVMOutputImage = new ArcAVMOutputImage(object2.singleImageWidth * object2.singleImageHeight * 3 / 2);
                            arcVisDriveAVMEngine2.outImageInfoArray[4] = object;
                            arcVisDriveAVMEngine2.outImageInfoArray[4].avmDrawImageType = 16;
                        }
                        return this.initArcErrorInfo.getErrorCode();
                    }
                    return -2;
                }
                return -2;
            }
            return -2;
        }
        return -2;
    }

    public int unInit() {
        ArcVisDriveAVMEngine arcVisDriveAVMEngine = this;
        int n = arcVisDriveAVMEngine.nativeUnInit(arcVisDriveAVMEngine.handle);
        if (n == 0) {
            this.handle = 0L;
        }
        this.outImageInfoArray = null;
        return n;
    }

    public int autoCalibrate(List<ArcAVMInputImage> arcAVMInputImageArray, ArcAVMClothInfo arcAVMClothInfo, List<ArcAVMChessInfo> arcAVMChessInfoArray, ArcAVMCalibResult arcAVMCalibResult, ArcAVMLookupTable arcAVMLookupTable) {
        if (this.handle == 0L) {
            return -10000;
        }
        if (arcAVMInputImageArray != null && arcAVMInputImageArray.size() == 4) {
            if (!this.checkInputImageInfo((List<ArcAVMInputImage>)arcAVMInputImageArray)) {
                return -2;
            }
            if (arcAVMClothInfo == null) {
                return -2;
            }
            if (arcAVMChessInfoArray != null && arcAVMChessInfoArray.size() == 4) {
                Object object;
                boolean bl = true;
                for (ArcPointF[] arcPointFArray : arcAVMChessInfoArray) {
                    ArcPointF[] arcPointFArray2 = arcPointFArray;
                    object = arcPointFArray.leftChessPoints;
                    arcPointFArray2 = arcPointFArray2.rightChessPoints;
                    boolean bl2 = arcPointFArray.leftChessPoints != null && ((ArcPointF[])object).length == 4 && arcPointFArray2 != null && arcPointFArray2.length == 4;
                    if (!bl2) {
                        bl = bl2;
                        break;
                    }
                    boolean bl3 = object[0] != null && object[1] != null && object[2] != null && object[3] != null;
                    if (!bl3) {
                        bl = bl3;
                        break;
                    }
                    bl = arcPointFArray2[0] != null && arcPointFArray2[1] != null && arcPointFArray2[2] != null && arcPointFArray2[3] != null;
                    if (bl) continue;
                }
                if (!bl) {
                    return -2;
                }
                if (arcAVMCalibResult == null) {
                    return -2;
                }
                if (arcAVMLookupTable == null) {
                    return -2;
                }
                arcAVMInputImageArray = arcAVMInputImageArray.toArray(new ArcAVMInputImage[0]);
                for (ArcAVMInputImage arcAVMInputImage : arcAVMInputImageArray) {
                    object = arcAVMInputImage.imagePosType;
                    if (object == ArcAVMCameraPosType.TYPE_FRONT) {
                        arcAVMInputImageArray[0] = arcAVMInputImage;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_RIGHT) {
                        arcAVMInputImageArray[1] = arcAVMInputImage;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_BACK) {
                        arcAVMInputImageArray[2] = arcAVMInputImage;
                    }
                    if (object != ArcAVMCameraPosType.TYPE_LEFT) continue;
                    arcAVMInputImageArray[3] = arcAVMInputImage;
                }
                arcAVMChessInfoArray = arcAVMChessInfoArray.toArray(new ArcAVMChessInfo[0]);
                for (ArcAVMChessInfo arcAVMChessInfo : arcAVMChessInfoArray) {
                    object = arcAVMChessInfo.imagePosType;
                    if (object == ArcAVMCameraPosType.TYPE_FRONT) {
                        arcAVMChessInfoArray[0] = arcAVMChessInfo;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_RIGHT) {
                        arcAVMChessInfoArray[1] = arcAVMChessInfo;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_BACK) {
                        arcAVMChessInfoArray[2] = arcAVMChessInfo;
                    }
                    if (object != ArcAVMCameraPosType.TYPE_LEFT) continue;
                    arcAVMChessInfoArray[3] = arcAVMChessInfo;
                }
                ArcVisDriveAVMEngine arcVisDriveAVMEngine = this;
                return arcVisDriveAVMEngine.nativeAutoCalibrate(arcVisDriveAVMEngine.handle, arcAVMInputImageArray, arcAVMClothInfo, arcAVMChessInfoArray, arcAVMCalibResult, arcAVMLookupTable);
            }
            return -2;
        }
        return -2;
    }

    public int manualCalibrate(List<ArcAVMInputImage> arcAVMInputImageArray, ArcAVMClothInfo arcAVMClothInfo, List<ArcAVMChessInfo> arcAVMChessInfoArray, ArcAVMCalibResult arcAVMCalibResult, ArcAVMLookupTable arcAVMLookupTable) {
        if (this.handle == 0L) {
            return -10000;
        }
        if (arcAVMInputImageArray != null && arcAVMInputImageArray.size() == 4) {
            if (!this.checkInputImageInfo((List<ArcAVMInputImage>)arcAVMInputImageArray)) {
                return -2;
            }
            if (arcAVMClothInfo == null) {
                return -2;
            }
            if (arcAVMChessInfoArray != null && arcAVMChessInfoArray.size() == 4) {
                Object object;
                boolean bl = true;
                for (ArcPointF[] arcPointFArray : arcAVMChessInfoArray) {
                    ArcPointF[] arcPointFArray2 = arcPointFArray;
                    object = arcPointFArray.leftChessPoints;
                    arcPointFArray2 = arcPointFArray2.rightChessPoints;
                    boolean bl2 = arcPointFArray.leftChessPoints != null && ((ArcPointF[])object).length == 4 && arcPointFArray2 != null && arcPointFArray2.length == 4;
                    if (!bl2) {
                        bl = bl2;
                        break;
                    }
                    boolean bl3 = object[0] != null && object[1] != null && object[2] != null && object[3] != null;
                    if (!bl3) {
                        bl = bl3;
                        break;
                    }
                    bl = arcPointFArray2[0] != null && arcPointFArray2[1] != null && arcPointFArray2[2] != null && arcPointFArray2[3] != null;
                    if (bl) continue;
                }
                if (!bl) {
                    return -2;
                }
                if (arcAVMCalibResult == null) {
                    return -2;
                }
                if (arcAVMLookupTable == null) {
                    return -2;
                }
                arcAVMInputImageArray = arcAVMInputImageArray.toArray(new ArcAVMInputImage[0]);
                for (ArcAVMInputImage arcAVMInputImage : arcAVMInputImageArray) {
                    object = arcAVMInputImage.imagePosType;
                    if (object == ArcAVMCameraPosType.TYPE_FRONT) {
                        arcAVMInputImageArray[0] = arcAVMInputImage;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_RIGHT) {
                        arcAVMInputImageArray[1] = arcAVMInputImage;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_BACK) {
                        arcAVMInputImageArray[2] = arcAVMInputImage;
                    }
                    if (object != ArcAVMCameraPosType.TYPE_LEFT) continue;
                    arcAVMInputImageArray[3] = arcAVMInputImage;
                }
                arcAVMChessInfoArray = arcAVMChessInfoArray.toArray(new ArcAVMChessInfo[0]);
                for (ArcAVMChessInfo arcAVMChessInfo : arcAVMChessInfoArray) {
                    object = arcAVMChessInfo.imagePosType;
                    if (object == ArcAVMCameraPosType.TYPE_FRONT) {
                        arcAVMChessInfoArray[0] = arcAVMChessInfo;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_RIGHT) {
                        arcAVMChessInfoArray[1] = arcAVMChessInfo;
                    }
                    if (object == ArcAVMCameraPosType.TYPE_BACK) {
                        arcAVMChessInfoArray[2] = arcAVMChessInfo;
                    }
                    if (object != ArcAVMCameraPosType.TYPE_LEFT) continue;
                    arcAVMChessInfoArray[3] = arcAVMChessInfo;
                }
                ArcVisDriveAVMEngine arcVisDriveAVMEngine = this;
                return arcVisDriveAVMEngine.nativeManualCalibrate(arcVisDriveAVMEngine.handle, arcAVMInputImageArray, arcAVMClothInfo, arcAVMChessInfoArray, arcAVMCalibResult, arcAVMLookupTable);
            }
            return -2;
        }
        return -2;
    }

    public int getCalibrateResults(ArcAVMCalibInfo arcAVMCalibInfo, ArcAVMCalibResult arcAVMCalibResult, ArcAVMLookupTable arcAVMLookupTable) {
        long l = this.handle;
        if (l == 0L) {
            return -10000;
        }
        if (arcAVMCalibInfo != null && arcAVMCalibResult != null && arcAVMLookupTable != null) {
            if (arcAVMCalibInfo.avmCarInfo == null) {
                return -2;
            }
            return this.nativeGetCalibrateResults(l, arcAVMCalibInfo, arcAVMCalibResult, arcAVMLookupTable);
        }
        return -2;
    }

    public int setImageBrightness(ArcAVMImageBrightness arcAVMImageBrightness) {
        long l = this.handle;
        if (l == 0L) {
            return -10000;
        }
        if (arcAVMImageBrightness == null) {
            return -2;
        }
        int n = arcAVMImageBrightness.brightness;
        if (n >= -9 && n <= 9) {
            return this.nativeSetImageBrightness(l, arcAVMImageBrightness);
        }
        return -2;
    }

    public int getImageBrightness(ArcAVMImageBrightness arcAVMImageBrightness) {
        long l = this.handle;
        if (l == 0L) {
            return -10000;
        }
        if (arcAVMImageBrightness == null) {
            return -2;
        }
        return this.nativeGetImageBrightness(l, arcAVMImageBrightness);
    }

    public int getPerPixelDistance(ArcAVMPerPixelDistance arcAVMPerPixelDistance) {
        long l = this.handle;
        if (l == 0L) {
            return -10000;
        }
        if (arcAVMPerPixelDistance == null) {
            return -2;
        }
        return this.nativeGetPerPixelDistance(l, arcAVMPerPixelDistance);
    }

    public int getReverseAuxLinePoint(ArcAVMReverseAuxLinePoint arcAVMReverseAuxLinePoint) {
        if (this.handle == 0L) {
            return -10000;
        }
        if (arcAVMReverseAuxLinePoint == null) {
            return -2;
        }
        int n = arcAVMReverseAuxLinePoint.auxLineDrawType;
        if (n != 1 && n != 8) {
            return -2;
        }
        ArcPointF[] arcPointFArray = arcAVMReverseAuxLinePoint.pointArray;
        if (arcAVMReverseAuxLinePoint.pointArray != null && arcPointFArray.length == 8) {
            boolean bl = true;
            int n2 = arcPointFArray.length;
            for (int i = 0; i < n2 && (bl = arcPointFArray[i] != null); ++i) {
            }
            if (!bl) {
                return -2;
            }
            ArcAVMReverseAuxLinePoint arcAVMReverseAuxLinePoint2 = arcAVMReverseAuxLinePoint;
            long l = this.handle;
            int n3 = arcAVMReverseAuxLinePoint2.auxLineDrawType;
            ArcPointF[] arcPointFArray2 = arcAVMReverseAuxLinePoint2.pointArray;
            return this.nativeGetReverseAuxLinePoint(l, n3, arcPointFArray2);
        }
        return -2;
    }

    public int getCarModelRect(ArcRect arcRect) {
        long l = this.handle;
        if (l == 0L) {
            return -10000;
        }
        if (arcRect == null) {
            return -2;
        }
        return this.nativeGetCarModelRect(l, arcRect);
    }

    public int drawAVM(int n, List<ArcAVMInputImage> arcAVMInputImageArray, List<ArcAVMOutputImage> list) {
        if (this.handle == 0L) {
            return -10000;
        }
        if ((n & 0xFFFFFFE0) > 0) {
            return -2;
        }
        if (arcAVMInputImageArray != null && arcAVMInputImageArray.size() == 4) {
            ArrayList arrayList;
            if (!this.checkInputImageInfo((List<ArcAVMInputImage>)arcAVMInputImageArray)) {
                return -2;
            }
            if (list == null) {
                return -2;
            }
            arcAVMInputImageArray = arcAVMInputImageArray.toArray(new ArcAVMInputImage[0]);
            for (ArcAVMInputImage arcAVMInputImage : arcAVMInputImageArray) {
                ArcAVMCameraPosType arcAVMCameraPosType = arcAVMInputImage.imagePosType;
                if (arcAVMCameraPosType == ArcAVMCameraPosType.TYPE_FRONT) {
                    arcAVMInputImageArray[0] = arcAVMInputImage;
                }
                if (arcAVMCameraPosType == ArcAVMCameraPosType.TYPE_RIGHT) {
                    arcAVMInputImageArray[1] = arcAVMInputImage;
                }
                if (arcAVMCameraPosType == ArcAVMCameraPosType.TYPE_BACK) {
                    arcAVMInputImageArray[2] = arcAVMInputImage;
                }
                if (arcAVMCameraPosType != ArcAVMCameraPosType.TYPE_LEFT) continue;
                arcAVMInputImageArray[3] = arcAVMInputImage;
            }
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList(5);
            if ((n & 1) != 0) {
                arrayList2.add(this.outImageInfoArray[0]);
            }
            if ((n & 2) != 0) {
                arrayList2.add(this.outImageInfoArray[1]);
            }
            if ((n & 4) != 0) {
                arrayList2.add(this.outImageInfoArray[2]);
            }
            if ((n & 8) != 0) {
                arrayList2.add(this.outImageInfoArray[3]);
            }
            if ((n & 0x10) != 0) {
                arrayList2.add(this.outImageInfoArray[4]);
            }
            ArcVisDriveAVMEngine arcVisDriveAVMEngine = this;
            list.clear();
            long l = this.handle;
            ArcAVMOutputImage[] arcAVMOutputImageArray = arrayList2.toArray(new ArcAVMOutputImage[0]);
            ArcErrorInfo arcErrorInfo = arcVisDriveAVMEngine.drawErrorInfo;
            if (arcVisDriveAVMEngine.nativeDrawAVM(l, n, arcAVMInputImageArray, arcAVMOutputImageArray, arcErrorInfo) > 0) {
                list.addAll(arrayList2);
            }
            return this.drawErrorInfo.getErrorCode();
        }
        return -2;
    }

    public native int nativeDrawAVM(long var1, int var3, ArcAVMInputImage[] var4, ArcAVMOutputImage[] var5, ArcErrorInfo var6);
}

