package com.intergration.avm.utils

import com.arcsoft.visdrive.avmsdk.constant.avm.ArcAVMCameraPosType
import com.arcsoft.visdrive.avmsdk.constant.common.ArcImageFormat
import com.arcsoft.visdrive.avmsdk.model.avm.ArcAVMInputImage

class ArcAVMInputImageFactory {

    companion object{
        private val frontImageData = ArcAVMInputImage().apply {
            width = IMAGE_WIDTH
            height = IMAGE_HEIGHT
            imageFormat = ArcImageFormat.ARC_IMAGE_FORMAT_NV21.value
            imagePosType = ArcAVMCameraPosType.TYPE_FRONT
            imageData = null
        }
        fun ofFront(data:ByteArray):ArcAVMInputImage = frontImageData.apply {
            imageData = data.toByteBuffer()
        }
        private val backImageData = ArcAVMInputImage().apply {
            width = IMAGE_WIDTH
            height = IMAGE_HEIGHT
            imageFormat = ArcImageFormat.ARC_IMAGE_FORMAT_NV21.value
            imagePosType = ArcAVMCameraPosType.TYPE_BACK
            imageData = null
        }
        fun ofBack(data:ByteArray):ArcAVMInputImage = backImageData.apply {
            imageData = data.toByteBuffer()
        }
        private val leftImageData = ArcAVMInputImage().apply {
            width = IMAGE_WIDTH
            height = IMAGE_HEIGHT
            imageFormat = ArcImageFormat.ARC_IMAGE_FORMAT_NV21.value
            imagePosType = ArcAVMCameraPosType.TYPE_LEFT
            imageData = null
        }
        fun ofLeft(data:ByteArray):ArcAVMInputImage = leftImageData.apply {
            imageData = data.toByteBuffer()
        }
        private val rightImageData = ArcAVMInputImage().apply {
            width = IMAGE_WIDTH
            height = IMAGE_HEIGHT
            imageFormat = ArcImageFormat.ARC_IMAGE_FORMAT_NV21.value
            imagePosType = ArcAVMCameraPosType.TYPE_RIGHT
            imageData = null
        }
        fun ofRight(data:ByteArray):ArcAVMInputImage = rightImageData.apply {
            imageData = data.toByteBuffer()
        }
    }
}