/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import com.mediatek.smartplatform.SmartPlatformJni;
import java.io.FileDescriptor;
import java.io.IOException;

public final class SmartPlatformMemoryFile {
    private static final String TAG = "SmartPlatformMemoryFile";
    private long mAddress = 0L;
    private FileDescriptor mFd;
    private ParcelFileDescriptor mPFd;
    private int mSize;

    public SmartPlatformMemoryFile(String name, int size) throws IOException {
        this.openAshmem(name, size);
    }

    public SmartPlatformMemoryFile(FileDescriptor fd, int size) throws IOException {
        this.openAshmem(fd, size);
    }

    public boolean openAshmem(FileDescriptor fd, int size) throws IOException {
        this.mFd = SmartPlatformJni.nativeAshmemOpen(fd, size);
        this.mSize = size;
        if (this.mFd.valid()) {
            this.mAddress = SmartPlatformJni.nativeAshmemMmap(this.mFd, size, 0);
            if (this.mAddress != 0L) {
                return true;
            }
            Log.w((String)TAG, (String)"Failed to call nativeAshmemMap()");
        } else {
            Log.w((String)TAG, (String)"Failed to openAshmem");
        }
        return false;
    }

    public boolean openAshmem(String name, int size) throws IOException {
        if (name != null && size > 0) {
            this.mFd = SmartPlatformJni.nativeAshmemOpen(name, size);
            this.mPFd = new ParcelFileDescriptor(this.mFd);
            this.mSize = size;
            if (this.mFd.valid()) {
                this.mAddress = SmartPlatformJni.nativeAshmemMmap(this.mFd, size, 0);
                if (this.mAddress != 0L) {
                    return true;
                }
                Log.w((String)TAG, (String)"Failed to call nativeAshmemMap()");
            } else {
                Log.w((String)TAG, (String)"Failed to openAshmem");
            }
        } else {
            Log.w((String)TAG, (String)"Invalid arguments in openAshmem()");
        }
        return false;
    }

    public int writeBitmap(Bitmap bitmap) {
        int result = -1;
        if (!this.isDeactivated() && this.mFd.valid()) {
            result = SmartPlatformJni.nativeAshmemWriteBitmap(this.mFd, this.mAddress, bitmap);
        } else {
            Log.w((String)TAG, (String)"Invalid arguments in writeBitmap()");
        }
        return result;
    }

    public int writeBytes(byte[] buffer, int srcOffset, int destOffset, int count) {
        int result = -1;
        if (!this.isDeactivated() && this.mFd.valid()) {
            result = SmartPlatformJni.nativeAshmemWriteBytes(this.mFd, this.mAddress, buffer, srcOffset, destOffset, count, false);
        } else {
            Log.w((String)TAG, (String)"Invalid arguments in writeBytes()");
        }
        return result;
    }

    public int readBytes(byte[] buffer, int srcOffset, int destOffset, int count) throws IOException {
        if (!this.isDeactivated()) {
            return SmartPlatformJni.nativeAshmemReadBytes(this.mFd, this.mAddress, buffer, srcOffset, destOffset, count);
        }
        Log.e((String)TAG, (String)("readBytes mAddress invalid = " + this.mAddress));
        return 0;
    }

    public void close() {
        if (!this.isDeactivated()) {
            try {
                SmartPlatformJni.nativeAshmemMunmap(this.mFd, this.mAddress, this.mSize);
                this.mAddress = 0L;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this.mFd.valid()) {
            SmartPlatformJni.nativeAshmemClose(this.mFd);
        }
    }

    public FileDescriptor getFileDescriptor() {
        return this.mFd;
    }

    public ParcelFileDescriptor getParcelFileDescriptor() {
        if (this.mPFd == null) {
            Log.e((String)TAG, (String)"Please check CarcorderMemoryFile methods, mPFd is null");
        }
        if (!this.mPFd.getFileDescriptor().valid()) {
            Log.w((String)TAG, (String)"mPFd's fd isn't valid");
        }
        Log.d((String)TAG, (String)("fd=" + this.mPFd.getFileDescriptor()));
        return this.mPFd;
    }

    public int size() {
        return this.mSize;
    }

    private boolean isDeactivated() {
        return this.mAddress == 0L;
    }
}

