package com.intergration.test.utils

import com.blankj.utilcode.util.LogUtils
import com.mediatek.smartplatform.RecordConfiguration
import com.mediatek.smartplatform.RecordSource
import com.mediatek.smartplatform.SpmCameraDevice
import com.mediatek.smartplatform.VideoInfoMap
import java.nio.ByteBuffer

const val DMS_PIC_WIDTH = 1280
const val DMS_PIC_HEIGHT = 720

const val DOT_PREFACE_DURATION = 5

const val VIDEO_FOLDER = "sdcard/waytous/alarm/"


fun SpmCameraDevice.recordVideo(prefix:String){
    val recordConfiguration = RecordConfiguration.get(RecordSource.GENERAL_CAMERA).apply {
        mLockFileNamePrefix = prefix
        mOutPutFilePath = VIDEO_FOLDER
        mVideoCycleDeleteFileNum = 3
    }
    recordConfiguration.mVideoCallback = object: SpmCameraDevice.VideoCallback {
        override fun onVideoTaken(videoInfo: VideoInfoMap?) {
            when(videoInfo?.getInt(VideoInfoMap.KEY_RECORDER_EVENT_TYPE)){
                SpmCameraDevice.VideoCallback.VIDEO_EVENT_SDCARD_FULL-> LogUtils.e("SDCard已满")
                SpmCameraDevice.VideoCallback.VIDEO_EVENT_RECORD_SDCARD_DAMAGED-> LogUtils.e("SDCard损坏")
                SpmCameraDevice.VideoCallback.VIDEO_EVENT_RECORD_RECORDING_ERROR-> LogUtils.e("录制视频过程中发生错误")
            }
            stopRecord(RecordSource.GENERAL_CAMERA)
        }

        override fun onVideoFrame(p0: ByteArray?, p1: Int, p2: Int, p3: String?, p4: Int) {
        }

    }
    startRecord(RecordSource.GENERAL_CAMERA,recordConfiguration)
}

fun ByteArray.toByteBuffer():ByteBuffer{
    val buffer = ByteBuffer.allocateDirect(size).also {
        it.put(this)
    }
    buffer.flip()
    return buffer
}