/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.MediaActionSound;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Size;
import android.util.SparseBooleanArray;
import android.view.Surface;
import com.mediatek.smartplatform.ADASInfo;
import com.mediatek.smartplatform.CameraSurfaceUsage;
import com.mediatek.smartplatform.ICameraDeviceListener;
import com.mediatek.smartplatform.ICarCamDeviceUser;
import com.mediatek.smartplatform.ISpmRecordListener;
import com.mediatek.smartplatform.ImageReaderEx;
import com.mediatek.smartplatform.PictureConfiguration;
import com.mediatek.smartplatform.PictureSequenceSource;
import com.mediatek.smartplatform.PreviewSource;
import com.mediatek.smartplatform.RecordConfiguration;
import com.mediatek.smartplatform.RecordSource;
import com.mediatek.smartplatform.SmartPlatformManager;
import com.mediatek.smartplatform.SmartPlatformMemoryFile;
import com.mediatek.smartplatform.SpmCamParameters;
import com.mediatek.smartplatform.SpmCameraDevice;
import com.mediatek.smartplatform.VideoInfoMap;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.List;

public class SpmCameraDeviceImpl
extends SpmCameraDevice
implements IBinder.DeathRecipient {
    private String TAG = "SpmCameraDeviceImpl";
    private static final boolean DEBUG = Build.IS_ENG || SystemProperties.getBoolean((String)"persist.vendor.log.spmsdk", (boolean)false);
    private static final boolean mPreSetPictureSurface = SystemProperties.getBoolean((String)"persist.vendor.spm.presetpic", (boolean)true);
    private ICarCamDeviceUser mRemoteDevice;
    private Object mRemoteDeviceLock = new Object();
    private SmartPlatformManager mManager;
    private Object mLock = new Object();
    private String mCameraId = null;
    private boolean mIsAvmDevice = false;
    private boolean mEnableRawSensorJpeg = false;
    private int mState = 0;
    private boolean mRelease = false;
    private SpmCameraDevice.ErrorCallback mErrorCallback = null;
    private SpmCameraDevice.AeStatusCallback mAeStatusCallback = null;
    private SpmCameraDevice.ADASCallback mADASCallback = null;
    private MediaActionSound mSound;
    private boolean mShutterSoundEnable = true;
    private final SparseBooleanArray mRecordSoundEnableArray = new SparseBooleanArray();
    private final SparseBooleanArray mSurfaceUsageArray = new SparseBooleanArray();
    private Size mPictureSize = null;
    private boolean isTakingPicture = false;
    private Object mTakingPictureLock = new Object();
    private Handler mMamagerHandler = null;
    private HandlerThread mEventThread = null;
    private EventHandler mEventHandler = null;
    public static final int CAMERA_STATUS_ERROR = 1;
    public static final int CAMERA_STATUS_SHUTTER = 2;
    public static final int CAMERA_STATUS_VIDEO = 3;
    public static final int CAMERA_STATUS_MOTION = 4;
    public static final int CAMERA_PICTURE_TAKEN = 5;
    public static final int RECORD_STATUS_CHANGED = 6;
    public static final int CAMERA_STATUS_AE = 7;
    public static final int CAMERA_ERROR_OCCURED = 8;
    public static final int CAMERA_ADAS_NOTIFY = 9;
    public static final int CAMERA_AVM_CALIBBRATION = 10;
    private CameraMetadataNative resultMetadata = null;
    private SpmCamDeviceListener mSpmCamDeviceListener = null;
    private SpmCamParameters mCurrentPara = null;
    private static final int EVENT_LOCK_VIDEO = 0;
    private static final int EVENT_SET_VIDEO_ROTATE_DURATION = 1;
    private static final int EVENT_SET_RECORDING_MUTE_AUDIO = 2;
    private static final int EVENT_SET_RECORDING_SDCARD_PATH = 3;
    private static final int EVENT_SET_MOTIO_DETECT = 4;
    private static final int EVENT_ENABLE_SHUTTER_SOUND = 5;
    private static final int EVENT_SET_BITRATE_DYN = 6;
    private static final int EVENT_SET_RECORD_MIC_CHANGED = 7;
    private static final int EVENT_ENABLE_RECORD_SOUND = 8;
    private static final int EVENT_FLUSH_CUR_REC_FILE = 9;
    private static final int EVENT_SET_RECORDING_LOCK_PATH = 10;
    private static final int EVENT_SET_RECORDING_ENCRYPT_MODE = 11;
    private static final int EVENT_SET_VIDEO_FRAME_MODE = 12;
    private static final int EVENT_CACHE_FRAME_START_RECORD = 13;
    private final ArrayMap<String, MediaRecorderListener> mRecorderListenerArray = new ArrayMap();
    private final ArrayMap<String, ImageReaderEx> mPictureSequenceArray = new ArrayMap();
    private ImageReaderEx mPictureTaken;
    public static final int RECORD_START_OK = 0;
    public static final int RECORD_START_ERROR_INVALID_RECORD_SOURCE = 1;
    public static final int RECORD_START_ERROR_SURFACE_USED = 2;
    public static final int RECORD_START_ERROR_PREPARE_FAIL = 3;
    public static final int RECORD_START_ERROR_REMOTE_FAIL = 4;
    public static final int DATA_TYPE_VIDEO = 501;
    public static final int DATA_TYPE_KEYPOINT = 502;
    public static final int DATA_TYPE_VIDEO_FRAME_YUV = 503;
    private Object mVideoCallbackLock = new Object();
    private Object mADASCallbackLock = new Object();
    private Object mAudioCallbackLock = new Object();
    private Object mRecordCbLock = new Object();
    private Object mAeStatusCallbackLock = new Object();
    private Object mDeviceErrorLock = new Object();
    private byte[] mVideoData = new byte[1];
    private byte[] mAudioData = new byte[1];
    private static final int EVENT_RECORDER_STATUS_CHANGE = 1;
    private static final int EVENT_RECORDER_VIDEO_FRAME = 2;
    private static final int EVENT_RECORDER_AUDIO_FRAME = 3;
    private SpmCameraDevice.CamPictureCallback mCamPictureCallback = null;
    private SpmCameraDevice.ShutterCallback mShutterCallback = null;

    public SpmCameraDeviceImpl(SmartPlatformManager manager, Handler handler, String cameraId) {
        this.mManager = manager;
        this.mMamagerHandler = handler;
        this.mCameraId = cameraId;
        this.TAG = this.TAG + "[" + this.mCameraId + "]";
        if (DEBUG) {
            Log.d((String)this.TAG, (String)("Instance, Camera id: " + this.mCameraId + "; CameraDevice: " + this));
        }
        this.mEventThread = new HandlerThread(this.TAG + "CameraDeviceEvent");
        this.mEventThread.start();
        this.mEventHandler = new EventHandler(this, this.mEventThread.getLooper());
        Message m = this.mEventHandler.obtainMessage(3);
        this.mEventHandler.sendMessage(m);
    }

    @Override
    public String getCameraId() {
        return this.mCameraId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int openCamera() {
        int ret = 0;
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            try {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                this.mRemoteDevice.open();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                ret = -1;
            }
            catch (ServiceSpecificException e) {
                e.printStackTrace();
                ret = -1;
            }
        }
        if (ret == 0) {
            this.mRelease = false;
        }
        return ret;
    }

    @Override
    public CameraCharacteristics getCameraCharacteristics() {
        CameraCharacteristics p = null;
        try {
            p = this.mManager.getCameraCharacteristics(this.mCameraId);
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"could not getCameraCharacteristics");
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRemoteDevice(ICarCamDeviceUser remoteDevice) {
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (remoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null");
                return;
            }
            this.mRemoteDevice = remoteDevice;
            IBinder remoteDeviceBinder = remoteDevice.asBinder();
            if (remoteDeviceBinder != null) {
                try {
                    remoteDeviceBinder.linkToDeath((IBinder.DeathRecipient)this, 0);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            try {
                this.mSpmCamDeviceListener = new SpmCamDeviceListener();
                this.mRemoteDevice.addListener(this.mSpmCamDeviceListener);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    void setAvmDeviceType() {
        this.mIsAvmDevice = true;
    }

    void enableRawSensorJpeg() {
        this.mEnableRawSensorJpeg = true;
    }

    public void binderDied() {
        Log.w((String)this.TAG, (String)("CameraDevice " + this.mCameraId + " died unexpectedly"));
        if (this.mRemoteDevice == null) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getState() {
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return -1;
            }
            try {
                return this.mRemoteDevice.getState(0);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(int state) {
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return;
            }
            try {
                this.mRemoteDevice.setState(0, state);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean checkState(int state) {
        int sState = this.getState();
        if (DEBUG) {
            Log.d((String)this.TAG, (String)("checkState, sState = " + sState + "state = " + state));
        }
        return (sState & state) == 0;
    }

    private void printParameter(String parameters) {
        if (DEBUG) {
            int maxLength = 1000;
            long length = parameters.length();
            if (length <= (long)maxLength) {
                Log.d((String)this.TAG, (String)parameters);
            } else {
                for (int i = 0; i < parameters.length(); i += maxLength) {
                    if (i + maxLength < parameters.length()) {
                        Log.d((String)this.TAG, (String)parameters.substring(i, i + maxLength));
                        continue;
                    }
                    Log.d((String)this.TAG, (String)parameters.substring(i, parameters.length()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setPreviewSurface(Surface surface, int previewSource) {
        Object object = this.mLock;
        synchronized (object) {
            int previewSurfaceId = PreviewSource.getSurfaceUsage(previewSource);
            if (!CameraSurfaceUsage.isValid(previewSurfaceId)) {
                Log.e((String)this.TAG, (String)"do not support this previewSource");
                return false;
            }
            int stateValue = CameraSurfaceUsage.getSurfaceState(previewSurfaceId);
            if (!this.checkState(stateValue) && surface != null) {
                Log.e((String)this.TAG, (String)("This camera usage(" + previewSurfaceId + ") has been used, please check again..."));
                return false;
            }
            Log.i((String)this.TAG, (String)("setPreviewSurface : " + surface + " previewSurfaceId: " + previewSurfaceId));
            if (!this.mIsAvmDevice && mPreSetPictureSurface) {
                if (surface == null) {
                    this.stopTakePicture(this.mPictureTaken, true);
                } else if (!this.mSurfaceUsageArray.get(15, false)) {
                    Log.i((String)this.TAG, (String)"no Picture surface, set default");
                    this.setPictureSize(null);
                }
            }
            this.mState = surface == null ? (this.mState &= ~stateValue) : (this.mState |= stateValue);
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return false;
                }
                this.setSurfaceDisplay(surface, previewSurfaceId, 1);
                this.setState(this.mState);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startPreview() {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"startPreview ");
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    this.mRemoteDevice.startPreview();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopPreview() {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"stopPreview ");
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    this.mRemoteDevice.stopPreview();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setSurfaceDisplay(Surface surface, int usage, int requestTemplate) {
        Log.i((String)this.TAG, (String)("setSurfaceDisplay: surface: " + surface + "  usage: " + usage));
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            int ret = 0;
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return -1;
            }
            try {
                ret = this.mRemoteDevice.setSurfaceDisplay(surface, usage);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpmCamParameters getParameters() {
        Log.v((String)this.TAG, (String)"getParameters");
        if (this.mRemoteDevice == null) {
            Log.e((String)this.TAG, (String)"remote Device is null, please open device.");
            return null;
        }
        if (this.mCurrentPara == null) {
            SpmCamParameters p = new SpmCamParameters();
            Log.i((String)this.TAG, (String)"new SpmCamParameters");
            CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
            if (DEBUG) {
                Log.d((String)this.TAG, (String)("cameraCharacteristics:" + cameraCharacteristics));
                if (cameraCharacteristics != null) {
                    cameraCharacteristics.getNativeCopy().dumpToLog();
                }
            }
            p.setCameraCharacteristics(cameraCharacteristics);
            this.mCurrentPara = p;
            Object object = this.mRemoteDeviceLock;
            synchronized (object) {
                try {
                    CameraMetadataNative requestMetadata = this.mRemoteDevice.createDefaultRequest(3);
                    p.setRequestMetadata(requestMetadata);
                }
                catch (Exception e) {
                    Log.e((String)this.TAG, (String)"get request metadata fail");
                    this.mCurrentPara = null;
                    e.printStackTrace();
                }
            }
        }
        return this.mCurrentPara;
    }

    @Override
    public void setParameters(SpmCamParameters params) {
        Log.v((String)this.TAG, (String)" setParameters ");
        if (this.mRemoteDevice == null) {
            Log.e((String)this.TAG, (String)"remote Device is null, please open device.");
            return;
        }
        this.mCurrentPara = params;
        if (!this.mIsAvmDevice) {
            this.updateRequestConfig(17, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startRecord(int recordSource, RecordConfiguration recordConfig) {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)("startRecord, recordSource = " + recordSource));
            int recordSurfaceId = RecordSource.getSurfaceUsage(recordSource);
            if (!CameraSurfaceUsage.isValid(recordSurfaceId)) {
                Log.e((String)this.TAG, (String)"do not support this recordSource");
                return 1;
            }
            int stateValue = CameraSurfaceUsage.getSurfaceState(recordSurfaceId);
            if (!this.checkState(stateValue)) {
                Log.e((String)this.TAG, (String)"This camera usage has been used, please check again...");
                return 2;
            }
            String recorderId = RecordSource.getRecordId(recordSource, this.mCameraId);
            if (recorderId == null) {
                Log.e((String)this.TAG, (String)"do not support this recordSource");
                return 1;
            }
            MediaRecorderListener recorderListener = (MediaRecorderListener)this.mRecorderListenerArray.get((Object)recorderId);
            if (null == recorderListener) {
                recorderListener = new MediaRecorderListener();
                this.mRecorderListenerArray.put((Object)recorderId, (Object)recorderListener);
            }
            SpmCamParameters para = this.getParameters();
            para.set("record-id", recorderId);
            para.setCameraId(this.mCameraId);
            para.setFromRecordConfig(recordConfig);
            String listenerName = RecordSource.isSubRecord(recordSource) ? "_SRL" : "_MRL";
            recorderListener.setInfo(listenerName, recordConfig.mVideoCallback, recordConfig.mAudioCallback, recordConfig.mRecordStatusCallback, recordConfig.mKeypointCallback, recordConfig.mVideoFdCallback);
            recorderListener.setRecorderSource(recordSource);
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    this.mRemoteDevice.addSpmRecordListener(recorderListener, recordSurfaceId);
                    this.mRemoteDevice.startRecord(para.flatten(), recordSurfaceId);
                    boolean recordSound = this.mRecordSoundEnableArray.get(recordSurfaceId, true);
                    if (recordSound) {
                        this.playSound(2);
                    }
                    this.mState |= stateValue;
                    this.setState(this.mState);
                }
                catch (RemoteException | ServiceSpecificException e) {
                    e.printStackTrace();
                    return 4;
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopRecord(int recordSource) {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)("stopRecord, recordSource = " + recordSource));
            int recordSurfaceId = RecordSource.getSurfaceUsage(recordSource);
            if (!CameraSurfaceUsage.isValid(recordSurfaceId)) {
                Log.e((String)this.TAG, (String)"do not support this recordSource");
                return 1;
            }
            int stateValue = CameraSurfaceUsage.getSurfaceState(recordSurfaceId);
            if (this.checkState(stateValue)) {
                Log.i((String)this.TAG, (String)("already stop: " + recordSource));
                return 0;
            }
            String recorderId = RecordSource.getRecordId(recordSource, this.mCameraId);
            if (recorderId == null) {
                Log.e((String)this.TAG, (String)"do not support this recordSource");
                return 1;
            }
            MediaRecorderListener recorderListener = (MediaRecorderListener)this.mRecorderListenerArray.get((Object)recorderId);
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    boolean recordSound = this.mRecordSoundEnableArray.get(recordSurfaceId, true);
                    if (recordSound) {
                        this.playSound(3);
                    }
                    this.mRemoteDevice.stopRecord(recorderId, recordSurfaceId);
                    if (recorderListener != null) {
                        this.mRemoteDevice.removeSpmRecordListener(recorderListener, recordSurfaceId);
                    }
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            this.mRecorderListenerArray.remove((Object)recorderId);
            this.mState &= ~stateValue;
            this.setState(this.mState);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CaptureRequest.Builder createCaptureRequest(int templateType) {
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return null;
            }
            CameraMetadataNative templatedRequest = null;
            try {
                templatedRequest = this.mRemoteDevice.createDefaultRequest(templateType);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            CaptureRequest.Builder builder = new CaptureRequest.Builder(templatedRequest, false, -1, this.getCameraId(), null);
            return builder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int submitRequest(boolean streaming) {
        Object object = this.mLock;
        synchronized (object) {
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    this.mRemoteDevice.submitRequest(streaming);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearRequest() {
        Object object = this.mLock;
        synchronized (object) {
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return -1;
                }
                try {
                    this.mRemoteDevice.clearRequest();
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRequest() {
        Object object = this.mLock;
        synchronized (object) {
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice == null) {
                    Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                    return;
                }
                if (this.mIsAvmDevice) {
                    Log.e((String)this.TAG, (String)"avm device no not support this API.");
                    return;
                }
                this.updateRequestConfig(17, 3);
                try {
                    this.mRemoteDevice.submitRequest(true);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRequestConfig(int usage, int requestTemplate) {
        try {
            CameraMetadataNative requestMetadata = this.mCurrentPara.getRequestMetadata();
            this.mCurrentPara.updateMetadata(requestMetadata, usage);
            Object object = this.mRemoteDeviceLock;
            synchronized (object) {
                this.mRemoteDevice.setRequestConfig(requestMetadata, usage);
            }
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)"set request config fail");
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPictureRequestConfig() {
        int pictureTemplate = 2;
        int recordState = CameraSurfaceUsage.getRecordState();
        if (!this.checkState(recordState)) {
            pictureTemplate = 4;
        }
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            try {
                CameraMetadataNative requestMetadata = this.mRemoteDevice.createDefaultRequest(pictureTemplate);
                this.mCurrentPara.updateMetadata(requestMetadata, 15);
                this.mRemoteDevice.setRequestConfig(requestMetadata, 15);
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)"setPictureRequestConfig fail");
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyRecordEvent(int eventId, int arg1, int arg2, String params, int recordSource) {
        Object object = this.mLock;
        synchronized (object) {
            int recordSurfaceId = RecordSource.getSurfaceUsage(recordSource);
            if (params == null) {
                params = "";
            }
            if (DEBUG) {
                Log.d((String)this.TAG, (String)("notifyRecordEvent, eventId: " + eventId + " arg1:" + arg1 + " arg2:" + arg2 + " param:(" + params + ")recorderId :" + recordSurfaceId));
            }
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return;
            }
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                try {
                    this.mRemoteDevice.notifyRecordEvent(recordSurfaceId, eventId, arg1, arg2, params);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void lockRecordingVideo(int duration, String protectedType, int recordSource) {
        this.notifyRecordEvent(0, 1, duration, protectedType, recordSource);
    }

    @Override
    public void unlockRecordingVideo(String filename, int recordSource) {
        this.notifyRecordEvent(0, 0, 0, filename, recordSource);
    }

    @Override
    public void setVideoRotateDuration(int duration_ms, int recordSource) {
        this.notifyRecordEvent(1, duration_ms, 0, null, recordSource);
    }

    @Override
    public void setVideoBitrateDyn(int bitrate, int bAdjust, int recordSource) {
        this.notifyRecordEvent(6, bitrate, bAdjust, null, recordSource);
    }

    @Override
    public void setRecordingMuteAudio(boolean isMuteAudio, int recordSource) {
        if (isMuteAudio) {
            this.notifyRecordEvent(2, 1, 0, null, recordSource);
        } else {
            this.notifyRecordEvent(2, 0, 0, null, recordSource);
        }
    }

    @Override
    public void setRecordMicChanged(boolean isMicChanged, int recordSource) {
        if (isMicChanged) {
            this.notifyRecordEvent(7, 1, 0, null, recordSource);
        } else {
            this.notifyRecordEvent(7, 0, 0, null, recordSource);
        }
    }

    @Override
    public void setProtectRecording(boolean ismotiondetect, boolean isrecordingstatus, int duration_ms, int recordSource) {
        if (ismotiondetect) {
            this.notifyRecordEvent(4, 1, isrecordingstatus ? 1 : 0, Integer.toString(duration_ms), recordSource);
        } else {
            this.notifyRecordEvent(4, 0, isrecordingstatus ? 1 : 0, Integer.toString(duration_ms), recordSource);
        }
    }

    @Override
    public void setRecordingSdcardPath(String path, int recordSource) {
        if (path == null) {
            Log.w((String)this.TAG, (String)("Invalid argument: path=" + path + " in setRecordingSdcardPath"));
            return;
        }
        this.notifyRecordEvent(3, 0, 0, path, recordSource);
    }

    @Override
    public void flushCurRecFile(int recordSource) {
        this.notifyRecordEvent(9, 0, 0, null, recordSource);
    }

    @Override
    public void setLockFilePath(String path, int recordSource) {
        if (path == null) {
            Log.w((String)this.TAG, (String)("Invalid argument: path=" + path + " in setLockFilepath"));
            return;
        }
        this.notifyRecordEvent(10, 0, 0, path, recordSource);
    }

    @Override
    public void enableEncryption(boolean enable, int recordSource) {
        this.notifyRecordEvent(11, enable ? 1 : 0, 0, null, recordSource);
    }

    @Override
    public void setVideoFrameMode(int mode, int recordSource) {
        if (1 != mode && 2 != mode) {
            this.notifyRecordEvent(12, mode, 0, null, recordSource);
        }
    }

    @Override
    public void startRecordFile(int mode, int recordSource) {
        this.notifyRecordEvent(13, mode, 0, null, recordSource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startPictureSequence(int source, PictureConfiguration config) {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)("startPictureSequence :" + source));
            String path = config.mPath;
            int imageFormat = config.mImageFormat;
            ImageReaderEx.ImageCallback cb = config.mImageCallback;
            int dataType = config.mDataType;
            boolean jpegHwEnc = config.mJpegHwEnc;
            int picWidth = config.mPicWidth;
            int picHeight = config.mPicHeight;
            Log.i((String)this.TAG, (String)("startPictureSequence,  path = " + path + "; imageFormat = " + imageFormat + "; type = " + dataType + "; jpegHwenc = " + jpegHwEnc));
            int pictureSurface = PictureSequenceSource.getSurfaceUsage(source);
            if (pictureSurface < 0) {
                Log.e((String)this.TAG, (String)("can not startPictureSequence, not support this source: " + pictureSurface));
                return -1;
            }
            String pictureSequenceId = PictureSequenceSource.getPictureSequenceId(source);
            int stateValue = CameraSurfaceUsage.getSurfaceState(pictureSurface);
            int extId = CameraSurfaceUsage.getSurfaceExId(pictureSurface);
            Log.i((String)this.TAG, (String)("startPictureSequence, pictureSurface id = " + pictureSurface + "; extId = " + extId));
            if (!this.checkState(stateValue)) {
                Log.e((String)this.TAG, (String)"can not startPictureSequence, already in State");
                return -1;
            }
            int pictureWidth = 1280;
            int pictureHeight = 720;
            ImageReaderEx mPictureSequence = new ImageReaderEx();
            if (picWidth > 0 && picHeight > 0) {
                pictureWidth = picWidth;
                pictureHeight = picHeight;
            }
            Log.i((String)this.TAG, (String)("startPictureSequence Picture Size (" + pictureWidth + "x" + pictureHeight + ")"));
            mPictureSequence.setImageCallback(cb);
            mPictureSequence.setImageDataCallback(config.mImageDataCallback);
            mPictureSequence.setOutImageFormat(imageFormat, dataType);
            mPictureSequence.setOutImageDir(path);
            if (imageFormat == 1 && dataType == 4) {
                imageFormat = 17;
                Log.i((String)this.TAG, (String)"camera output:IMAGE_FORMAT_NV21, fdpool output IMAGE_FORMAT_ARGB_8888");
            }
            mPictureSequence.init(pictureWidth, pictureHeight, imageFormat, "_" + this.mCameraId, this.mCameraId, true);
            if (jpegHwEnc && this.mManager != null && 0 == this.mManager.getJpegHwEncState()) {
                mPictureSequence.setJpegHwEnc(true);
                this.mManager.setJpegHwEncState(1);
            } else {
                if (jpegHwEnc) {
                    Log.w((String)this.TAG, (String)"jpeg hw enc used by another or not support, set jpeg sw enc");
                }
                mPictureSequence.setJpegHwEnc(false);
            }
            Surface mPictureSequenceSurface = mPictureSequence.getSurface();
            SpmCamParameters para = this.getParameters();
            if (extId >= 0 && CameraSurfaceUsage.IsExSurface(pictureSurface)) {
                para.setExtSurfaceSize(extId, pictureWidth, pictureHeight);
                para.setExtSurfaceFormat(extId, "yuv420p");
            }
            this.setParameters(para);
            this.setSurfaceDisplay(mPictureSequenceSurface, pictureSurface, 1);
            this.submitRequest(true);
            mPictureSequence.start();
            this.mPictureSequenceArray.put((Object)pictureSequenceId, (Object)mPictureSequence);
            this.mState |= stateValue;
            this.setState(this.mState);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopPictureSequence(int source) {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)(" stopPictureSequence: " + source));
            int pictureSurface = PictureSequenceSource.getSurfaceUsage(source);
            if (pictureSurface < 0) {
                Log.e((String)this.TAG, (String)("can not stopPictureSequence, not support this source or this source was already stopped: " + pictureSurface));
                return -1;
            }
            String pictureSequenceId = PictureSequenceSource.getPictureSequenceId(source);
            ImageReaderEx mPictureSequence = (ImageReaderEx)this.mPictureSequenceArray.get((Object)pictureSequenceId);
            int stateValue = CameraSurfaceUsage.getSurfaceState(pictureSurface);
            if (this.checkState(stateValue)) {
                Log.i((String)this.TAG, (String)("already stop: " + source));
                return 0;
            }
            try {
                this.setSurfaceDisplay(null, pictureSurface, 1);
                this.submitRequest(true);
                if (mPictureSequence != null) {
                    mPictureSequence.stop();
                }
            }
            catch (Exception e) {
                Log.e((String)this.TAG, (String)(" stop Picture Sequence error " + e));
            }
            finally {
                if (mPictureSequence != null && mPictureSequence.getJpegHwEnc() && this.mManager != null) {
                    this.mManager.setJpegHwEncState(0);
                }
                this.mPictureSequenceArray.remove((Object)pictureSequenceId);
            }
            this.mState &= ~stateValue;
            this.setState(this.mState);
            mPictureSequence = null;
            return 0;
        }
    }

    @Override
    public FileDescriptor enableShareBuffer(int source, boolean enableSharebuffer) {
        String pictureSequenceId = PictureSequenceSource.getPictureSequenceId(source);
        ImageReaderEx mPictureSequence = (ImageReaderEx)this.mPictureSequenceArray.get((Object)pictureSequenceId);
        if (mPictureSequence != null) {
            return mPictureSequence.enableShareBuffer(enableSharebuffer, false);
        }
        return null;
    }

    @Override
    public FileDescriptor enableShareBuffer(int source, boolean enableSharebuffer, boolean enableCallback) {
        String pictureSequenceId = PictureSequenceSource.getPictureSequenceId(source);
        ImageReaderEx mPictureSequence = (ImageReaderEx)this.mPictureSequenceArray.get((Object)pictureSequenceId);
        if (mPictureSequence != null) {
            return mPictureSequence.enableShareBuffer(enableSharebuffer, enableCallback);
        }
        return null;
    }

    @Override
    public int setDropStreamFrame(int streamType, int streamSource, int streamPolicy) {
        int usage = -1;
        switch (streamType) {
            case 0: {
                usage = PictureSequenceSource.getSurfaceUsage(streamSource);
                break;
            }
            case 1: {
                usage = RecordSource.getSurfaceUsage(streamSource);
                break;
            }
            case 2: {
                usage = PreviewSource.getSurfaceUsage(streamSource);
                break;
            }
            default: {
                Log.e((String)this.TAG, (String)("setDropStreamFrame: streamType error" + streamType));
                return -1;
            }
        }
        SpmCamParameters para = this.getParameters();
        para.setDropStreamFrame(streamPolicy, usage);
        this.updateRequest();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean release() {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"release ");
            if (this.mRelease) {
                Log.w((String)this.TAG, (String)"already release, skip this release");
                return true;
            }
            if (this.mEventHandler != null) {
                Message m = this.mEventHandler.obtainMessage(4);
                this.mEventHandler.sendMessage(m);
            }
            Object object2 = this.mRemoteDeviceLock;
            synchronized (object2) {
                if (this.mRemoteDevice != null) {
                    try {
                        this.mRemoteDevice.removeListener(this.mSpmCamDeviceListener);
                        this.mRemoteDevice.release();
                        IBinder remoteDeviceBinder = this.mRemoteDevice.asBinder();
                        if (remoteDeviceBinder != null) {
                            remoteDeviceBinder.unlinkToDeath((IBinder.DeathRecipient)this, 0);
                        }
                        this.mRemoteDevice = null;
                    }
                    catch (RemoteException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.mEventThread != null) {
                this.mEventThread.quitSafely();
                this.mEventHandler = null;
                this.mEventThread = null;
            }
            this.mRelease = true;
            this.mSpmCamDeviceListener = null;
            this.mManager = null;
            this.mMamagerHandler = null;
            this.mErrorCallback = null;
            this.mADASCallback = null;
            this.mAeStatusCallback = null;
            this.mADASCallbackLock = null;
            this.mAeStatusCallbackLock = null;
            this.mAudioCallbackLock = null;
            this.mAudioData = null;
            return true;
        }
    }

    private Size returnLargestSize(Size[] sizes) {
        Size largestSize = null;
        int area = 0;
        for (int j = 0; j < sizes.length; ++j) {
            if (DEBUG) {
                Log.d((String)this.TAG, (String)("support size " + sizes[j]));
            }
            if (sizes[j].getHeight() * sizes[j].getWidth() <= area) continue;
            area = sizes[j].getHeight() * sizes[j].getWidth();
            largestSize = sizes[j];
        }
        return largestSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPictureSurface(Size pictureSize) {
        Object object = this.mLock;
        synchronized (object) {
            int ret = this.setPictureSize(pictureSize);
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int clearPictureSurface() {
        Object object = this.mLock;
        synchronized (object) {
            this.stopTakePicture(this.mPictureTaken, true);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setPictureSize(Size pictureSize) {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"setPictureSurface");
            int ret = 0;
            int stateValue = CameraSurfaceUsage.getSurfaceState(15);
            if (!this.checkState(stateValue)) {
                Log.i((String)this.TAG, (String)"already in State, clear old Picture surface");
                this.stopTakePicture(this.mPictureTaken, true);
            }
            int pictureFormat = this.mEnableRawSensorJpeg && !this.mCurrentPara.isWatermarkEnable(15) ? 256 : 842094169;
            if (pictureSize == null && this.mPictureSize == null) {
                CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics();
                StreamConfigurationMap map = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
                int[] formats = map.getOutputFormats();
                for (int i = 0; i < formats.length; ++i) {
                    if (formats[i] != pictureFormat) continue;
                    this.mPictureSize = this.returnLargestSize(map.getOutputSizes(formats[i]));
                    break;
                }
                if (this.mPictureSize == null) {
                    this.mPictureSize = new Size(1280, 720);
                    Log.i((String)this.TAG, (String)("setPictureSurface set default size: " + this.mPictureSize));
                } else {
                    Log.i((String)this.TAG, (String)("setPictureSurface size use largestsize" + this.mPictureSize + ", inFormat = " + pictureFormat));
                }
            } else if (pictureSize != null) {
                this.mPictureSize = new Size(pictureSize.getWidth(), pictureSize.getHeight());
                Log.i((String)this.TAG, (String)("setPictureSize size use appset" + pictureSize + ", inFormat = " + pictureFormat));
            } else {
                Log.i((String)this.TAG, (String)("setPictureSize size use previous" + this.mPictureSize + ", inFormat = " + pictureFormat));
            }
            int pictureWidth = this.mPictureSize.getWidth();
            int pictureHeight = this.mPictureSize.getHeight();
            this.mPictureTaken = new ImageReaderEx();
            this.mPictureTaken.init(pictureWidth, pictureHeight, pictureFormat, "_" + this.mCameraId, this.mCameraId, false);
            Surface mPictureTakenSurface = this.mPictureTaken.getSurface();
            ret = this.setSurfaceDisplay(mPictureTakenSurface, 15, 0);
            this.submitRequest(true);
            this.mSurfaceUsageArray.put(15, true);
            this.mState |= stateValue;
            this.setState(this.mState);
            return ret;
        }
    }

    @Override
    public int takePicture(String fileName, SpmCameraDevice.ShutterCallback shutter, SpmCameraDevice.CamPictureCallback jpeg) {
        return this.takePicture(fileName, shutter, jpeg, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takePicture(String fileName, SpmCameraDevice.ShutterCallback shutter, SpmCameraDevice.CamPictureCallback jpeg, Size pictureSize) {
        Log.i((String)this.TAG, (String)"takePicture");
        Object object = this.mTakingPictureLock;
        synchronized (object) {
            if (this.isTakingPicture) {
                Log.i((String)this.TAG, (String)"already taking picture, please wait...");
                return -1;
            }
        }
        object = this.mLock;
        synchronized (object) {
            this.mShutterCallback = shutter;
            this.mCamPictureCallback = jpeg;
        }
        if (!this.mSurfaceUsageArray.get(15, false)) {
            int ret = this.setPictureSize(pictureSize);
            if (ret != 0) {
                Log.e((String)this.TAG, (String)"can not takePicture, already in State");
                this.mCamPictureCallback.onPictureTaken(-1, this.mCameraId, null);
                return -1;
            }
        } else {
            Log.i((String)this.TAG, (String)"use default pictureSize or the size in setPictureSize");
        }
        this.mPictureTaken.setCameraDeviceHandler(this.mEventHandler);
        this.mPictureTaken.setCamPictureCallback(jpeg);
        this.mPictureTaken.setOutImageFormat(256, 1);
        this.mPictureTaken.setOutImageName(fileName);
        this.mPictureTaken.setJpegHwEnc(false);
        this.setPictureRequestConfig();
        Object object2 = this.mRemoteDeviceLock;
        synchronized (object2) {
            try {
                this.mRemoteDevice.takePicture(fileName);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        this.mPictureTaken.start();
        this.setTakePictureTimeoutMessage(jpeg);
        object2 = this.mTakingPictureLock;
        synchronized (object2) {
            this.isTakingPicture = true;
        }
        if (this.mShutterSoundEnable) {
            this.playSound(0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int takePicture(List<String> filePath, Size pictureSize, int source, int quality) {
        Log.i((String)this.TAG, (String)"takePicture");
        int ret = -1;
        if (1 != source && 7 != source && 2 != source && 3 != source && 4 != source && 5 != source) {
            Log.e((String)this.TAG, (String)("can not capture wrong source:" + source));
            return -1;
        }
        if (quality < 0 || quality > 100) {
            Log.e((String)this.TAG, (String)("can not capture wrong quality:" + quality));
            return -1;
        }
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return -1;
            }
            try {
                ret = this.mRemoteDevice.capture(filePath, pictureSize.getWidth(), pictureSize.getHeight(), source, quality);
                if (this.mShutterSoundEnable) {
                    this.playSound(0);
                }
                if (ret == 0) {
                    return 0;
                }
                return -1;
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopTakePicture(ImageReaderEx pictureTaken, boolean release) {
        Log.i((String)this.TAG, (String)("stopTakePicture, release: " + release));
        Object object = this.mTakingPictureLock;
        synchronized (object) {
            this.isTakingPicture = false;
        }
        if (release && pictureTaken != null) {
            pictureTaken.stop();
            this.mPictureTaken = null;
            this.mSurfaceUsageArray.put(15, false);
            this.setSurfaceDisplay(null, 15, 1);
            this.submitRequest(true);
            int stateValue = CameraSurfaceUsage.getSurfaceState(15);
            this.mState &= ~stateValue;
            this.setState(this.mState);
        }
    }

    private void setTakePictureTimeoutMessage(SpmCameraDevice.CamPictureCallback callback) {
        if (DEBUG) {
            Log.i((String)this.TAG, (String)"set takePicture timeout ");
        }
        Message m = this.mEventHandler.obtainMessage(5, callback);
        this.mEventHandler.sendMessageDelayed(m, this.mTakePictureTimeoutMs);
    }

    private void removeTakePictureTimeoutMessage() {
        if (DEBUG) {
            Log.i((String)this.TAG, (String)"remove takePicture timeout ");
        }
        this.mEventHandler.removeMessages(5);
    }

    private void takePictureFail(final SpmCameraDevice.CamPictureCallback callback) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)"take Picture timeout");
                if (callback != null) {
                    callback.onPictureTaken(-1, SpmCameraDeviceImpl.this.mCameraId, null);
                }
                Object object = SpmCameraDeviceImpl.this.mTakingPictureLock;
                synchronized (object) {
                    SpmCameraDeviceImpl.this.isTakingPicture = false;
                }
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setErrorCallback(SpmCameraDevice.ErrorCallback callback) {
        Log.i((String)this.TAG, (String)"setErrorCallback");
        Object object = this.mDeviceErrorLock;
        synchronized (object) {
            this.mErrorCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAeStatusCallback(SpmCameraDevice.AeStatusCallback callback) {
        Object object = this.mAeStatusCallbackLock;
        synchronized (object) {
            this.mAeStatusCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queryAeBlock() {
        try {
            CameraMetadataNative requestMetadata = this.mCurrentPara.getRequestMetadata();
            this.mCurrentPara.updateMetadata(requestMetadata, 0);
            this.mCurrentPara.mapAeBlockMode(requestMetadata);
            Object object = this.mRemoteDeviceLock;
            synchronized (object) {
                this.mRemoteDevice.queryAeBlock(requestMetadata);
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateWatermark(boolean enable, String watermark) {
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return;
            }
            try {
                this.mRemoteDevice.updateWatermark(enable, watermark);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResultMetadata() {
        Object object = this.mAeStatusCallbackLock;
        synchronized (object) {
            if (this.mAeStatusCallback != null) {
                int[] value = this.mCurrentPara.getResultAeBlockValue();
                this.mAeStatusCallback.onStatusCallbackArray(value, 25);
                if (DEBUG) {
                    Log.d((String)this.TAG, (String)("AeStatusCallback:  " + value));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Surface getADASSurface() throws RemoteException {
        Log.i((String)this.TAG, (String)"getADASSurface");
        Surface input = null;
        Object object = this.mRemoteDeviceLock;
        synchronized (object) {
            if (this.mRemoteDevice == null) {
                Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                return null;
            }
            try {
                input = this.mRemoteDevice.getADASSurface();
            }
            catch (RemoteException e) {
                e.printStackTrace();
                throw e;
            }
        }
        return input;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setADASCallback(SpmCameraDevice.ADASCallback callback) {
        Object object = this.mADASCallbackLock;
        synchronized (object) {
            this.mADASCallback = callback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int startADAS() {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"startADAS");
            int adasState = CameraSurfaceUsage.getSurfaceState(16);
            if (!this.checkState(adasState)) {
                Log.e((String)this.TAG, (String)"can not startADAS");
                return -1;
            }
            try {
                Object object2 = this.mRemoteDeviceLock;
                synchronized (object2) {
                    if (this.mRemoteDevice == null) {
                        Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                        return -1;
                    }
                    this.setSurfaceDisplay(this.getADASSurface(), 16, 1);
                    this.mRemoteDevice.startADAS();
                    this.mState |= adasState;
                    this.setState(this.mState);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int stopADAS() {
        Object object = this.mLock;
        synchronized (object) {
            Log.i((String)this.TAG, (String)"stopADAS");
            try {
                int adasState = CameraSurfaceUsage.getSurfaceState(16);
                Object object2 = this.mRemoteDeviceLock;
                synchronized (object2) {
                    if (this.mRemoteDevice == null) {
                        Log.e((String)this.TAG, (String)"remote Device is null, this device maybe release already !!! ");
                        return -1;
                    }
                    this.setSurfaceDisplay(null, 16, 1);
                    this.mRemoteDevice.stopADAS();
                    this.mState &= ~adasState;
                    this.setState(this.mState);
                }
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
            return 0;
        }
    }

    @Override
    public void enableShutterSound(boolean shutter) {
        Log.i((String)this.TAG, (String)("enableShutterSound:" + shutter));
        this.mShutterSoundEnable = shutter;
    }

    @Override
    public void enableRecordSound(boolean enable, int recordSource) {
        Log.i((String)this.TAG, (String)("enableRecordSound:" + enable + ", recordSource : " + recordSource));
        int recordSurfaceId = RecordSource.getSurfaceUsage(recordSource);
        this.mRecordSoundEnableArray.put(recordSurfaceId, enable);
    }

    private void initSound() {
        this.mSound = new MediaActionSound();
        this.mSound.load(2);
        this.mSound.load(3);
        this.mSound.load(1);
        this.mSound.load(0);
    }

    private void releaseSound() {
        if (this.mSound != null) {
            this.mSound.release();
            this.mSound = null;
        }
    }

    private synchronized void playSound(int action) {
        if (this.mSound == null) {
            Log.e((String)this.TAG, (String)"[play] mSound is null");
            return;
        }
        switch (action) {
            case 1: {
                this.mSound.play(1);
                break;
            }
            case 2: {
                this.mSound.play(2);
                break;
            }
            case 3: {
                this.mSound.play(3);
                break;
            }
            case 0: {
                this.mSound.play(0);
                break;
            }
            default: {
                Log.w((String)this.TAG, (String)("Unrecognized action:" + action));
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mRemoteDevice != null) {
            this.mRemoteDevice.removeListener(this.mSpmCamDeviceListener);
            this.mRemoteDevice.release();
        }
    }

    static /* synthetic */ byte[] access$2202(SpmCameraDeviceImpl x0, byte[] x1) {
        x0.mVideoData = x1;
        return x1;
    }

    static /* synthetic */ byte[] access$2402(SpmCameraDeviceImpl x0, byte[] x1) {
        x0.mAudioData = x1;
        return x1;
    }

    private class MediaRecorderListener
    extends ISpmRecordListener.Stub {
        private String mName;
        private SpmCameraDevice.VideoCallback mVideoCallback;
        private SpmCameraDevice.AudioCallback mAudioCallback;
        private SpmCameraDevice.RecordStatusCallback mRecordStatusCallback;
        private SpmCameraDevice.KeypointCallback mKeypointCallback;
        private SpmCameraDevice.VideoFdCallback mVideoFdCallback;
        private int mRecorderSource;
        private int mRecorderType;

        private MediaRecorderListener() {
        }

        @Override
        public void onStatusChanged(int event, int arg1, String arg2, int arg3) throws RemoteException {
            if (DEBUG) {
                Log.d((String)SpmCameraDeviceImpl.this.TAG, (String)("onStatusChanged is invoked: event " + event + ", arg1 " + arg1 + ", arg2 " + arg2 + ", arg3 " + arg3));
            }
            this.onRecorderStatusChanged(event, arg1, arg2, arg3);
        }

        @Override
        public void onVideoFrame(ParcelFileDescriptor fd, int dataType, int size) throws RemoteException {
            this.onRecorderVideoFrame(fd, dataType, size);
        }

        @Override
        public void onAudioFrame(ParcelFileDescriptor fd, int dataType, int size) throws RemoteException {
            this.onRecorderAudioFrame(fd, dataType, size);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRecorderStatusChanged(int event, int arg1, String arg2, int arg3) {
            if (DEBUG) {
                Log.d((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)("onRecorderStatusChanged is invoked: event " + event + ", arg1 " + arg1 + ", arg2 " + arg2 + ", arg3 " + arg3));
            }
            switch (event) {
                case 3: {
                    Object object = SpmCameraDeviceImpl.this.mRecordCbLock;
                    synchronized (object) {
                        if (this.mVideoCallback != null) {
                            VideoInfoMap videoInfoMap = new VideoInfoMap();
                            videoInfoMap.unflatten(arg2);
                            videoInfoMap.set("camera_id", SpmCameraDeviceImpl.this.mCameraId);
                            videoInfoMap.set("event_type", arg1);
                            videoInfoMap.set("recorder_source", this.mRecorderSource);
                            this.mVideoCallback.onVideoTaken(videoInfoMap);
                        } else {
                            Log.w((String)SpmCameraDeviceImpl.this.TAG, (String)"mVideoCallback is null ");
                        }
                        break;
                    }
                }
                case 2: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    Object object = SpmCameraDeviceImpl.this.mRecordCbLock;
                    synchronized (object) {
                        if (this.mRecordStatusCallback != null) {
                            this.mRecordStatusCallback.onRecordStatusChanged(arg1, SpmCameraDeviceImpl.this.mCameraId, this.mRecorderSource);
                        }
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void onRecorderVideoFrame(ParcelFileDescriptor fd, int dataType, int size) {
            Object object = SpmCameraDeviceImpl.this.mVideoCallbackLock;
            // MONITORENTER : object
            if (DEBUG) {
                Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)("fd = " + fd + " ,dataType = " + dataType + ", size = " + size + ", preview length = " + SpmCameraDeviceImpl.this.mVideoData.length));
            }
            try {
                switch (dataType) {
                    case 502: {
                        if (this.mKeypointCallback == null) {
                            Log.w((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)"mKeypointCallback is null");
                            return;
                        }
                        SpmCameraDeviceImpl.access$2202(SpmCameraDeviceImpl.this, new byte[size]);
                        if (size != this.readAshmemBytes(fd, size, SpmCameraDeviceImpl.this.mVideoData)) return;
                        this.mKeypointCallback.onKeypointFrame(SpmCameraDeviceImpl.this.mVideoData, dataType, size, SpmCameraDeviceImpl.this.mCameraId, this.mRecorderSource);
                        return;
                    }
                    default: {
                        if (this.mVideoFdCallback != null) {
                            this.mVideoFdCallback.onVideoFdFrame(fd, dataType, size, SpmCameraDeviceImpl.this.mCameraId, this.mRecorderSource);
                            return;
                        }
                        if (this.mVideoCallback != null) {
                            SpmCameraDeviceImpl.access$2202(SpmCameraDeviceImpl.this, new byte[size]);
                            if (size == this.readAshmemBytes(fd, size, SpmCameraDeviceImpl.this.mVideoData)) {
                                this.mVideoCallback.onVideoFrame(SpmCameraDeviceImpl.this.mVideoData, dataType, size, SpmCameraDeviceImpl.this.mCameraId, this.mRecorderSource);
                                return;
                            }
                            Log.e((String)SpmCameraDeviceImpl.this.TAG, (String)" readAshmemBytes fail ");
                            return;
                        }
                        Log.w((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)"mVideoCallback is null");
                        return;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Log.e((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)"Recorder Video Frame failed");
                return;
            }
            finally {
                this.closeFd(fd);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRecorderAudioFrame(ParcelFileDescriptor fd, int dataType, int size) {
            Object object = SpmCameraDeviceImpl.this.mAudioCallbackLock;
            synchronized (object) {
                if (DEBUG) {
                    Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)("fd = " + fd + " ,dataType = " + dataType + ", size = " + size + ", preview length = " + SpmCameraDeviceImpl.this.mAudioData.length));
                }
                try {
                    if (this.mAudioCallback != null) {
                        SpmCameraDeviceImpl.access$2402(SpmCameraDeviceImpl.this, new byte[size]);
                        if (size == this.readAshmemBytes(fd, size, SpmCameraDeviceImpl.this.mAudioData)) {
                            this.mAudioCallback.onAudioFrame(SpmCameraDeviceImpl.this.mAudioData, dataType, size, SpmCameraDeviceImpl.this.mCameraId, this.mRecorderSource);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.e((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)"Recorder Audio Frame failed");
                }
                finally {
                    this.closeFd(fd);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int readAshmemBytes(ParcelFileDescriptor fd, int size, byte[] data) {
            SmartPlatformMemoryFile client = null;
            int length = 0;
            try {
                client = new SmartPlatformMemoryFile(fd.getFileDescriptor(), size);
                if (client != null) {
                    length = client.readBytes(data, 0, 0, size);
                } else {
                    Log.w((String)(SpmCameraDeviceImpl.this.TAG + this.mName), (String)"ashmem client is null");
                }
                this.closeMemoryFile(client);
                client = null;
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                    this.closeMemoryFile(client);
                    client = null;
                }
                catch (Throwable throwable) {
                    this.closeMemoryFile(client);
                    client = null;
                    throw throwable;
                }
            }
            return length;
        }

        private void closeFd(ParcelFileDescriptor fd) {
            try {
                if (fd != null) {
                    fd.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private void closeMemoryFile(SmartPlatformMemoryFile client) {
            try {
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void setInfo(String name, SpmCameraDevice.VideoCallback videoCallback, SpmCameraDevice.AudioCallback audioCallback, SpmCameraDevice.RecordStatusCallback recordStatusCallback, SpmCameraDevice.KeypointCallback keypointCallback, SpmCameraDevice.VideoFdCallback videoFdCallback) {
            this.mName = name;
            this.mVideoCallback = videoCallback;
            this.mAudioCallback = audioCallback;
            this.mRecordStatusCallback = recordStatusCallback;
            this.mKeypointCallback = keypointCallback;
            this.mVideoFdCallback = videoFdCallback;
        }

        public void setRecorderSource(int recordSource) {
            this.mRecorderSource = recordSource;
        }

        public void setRecorderType(int recordType) {
            this.mRecorderType = recordType;
        }
    }

    private class SpmCamDeviceListener
    extends ICameraDeviceListener.Stub {
        private SpmCamDeviceListener() {
        }

        @Override
        public void onStatusChanged(int event, int arg1, String arg2, int arg3) throws RemoteException {
        }

        @Override
        public void onMiscDataCallback(int fd, int datatype, int size) throws RemoteException {
        }

        @Override
        public void onVideoFrame(int fd, int dataType, int size) throws RemoteException {
        }

        @Override
        public void onAudioFrame(int fd, int dataType, int size) throws RemoteException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onADASCallback(ADASInfo info) throws RemoteException {
            Object object = SpmCameraDeviceImpl.this.mADASCallbackLock;
            synchronized (object) {
                if (SpmCameraDeviceImpl.this.mADASCallback != null) {
                    SpmCameraDeviceImpl.this.mADASCallback.onADASCallback(info);
                }
            }
        }

        @Override
        public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalResults) throws RemoteException {
            Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)"onResultReceived ");
            SpmCameraDeviceImpl.this.resultMetadata = new CameraMetadataNative(result);
            if (SpmCameraDeviceImpl.this.mCurrentPara != null) {
                SpmCameraDeviceImpl.this.mCurrentPara.setResultMetadata(SpmCameraDeviceImpl.this.resultMetadata);
            }
            if (SpmCameraDeviceImpl.this.mEventHandler != null) {
                Message m = SpmCameraDeviceImpl.this.mEventHandler.obtainMessage(2);
                SpmCameraDeviceImpl.this.mEventHandler.sendMessage(m);
            }
            if (DEBUG) {
                SpmCameraDeviceImpl.this.resultMetadata.dumpToLog();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) {
            Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)("onDeviceError : " + errorCode));
            Object object = SpmCameraDeviceImpl.this.mDeviceErrorLock;
            synchronized (object) {
                if (SpmCameraDeviceImpl.this.mErrorCallback != null) {
                    SpmCameraDeviceImpl.this.mErrorCallback.onError(errorCode, SpmCameraDeviceImpl.this.mCameraId, SpmCameraDeviceImpl.this);
                } else {
                    Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)"mErrorCallback is null");
                    if (errorCode == 0) {
                        Message msg = Message.obtain((Handler)SpmCameraDeviceImpl.this.mMamagerHandler, (int)1, (Object)SpmCameraDeviceImpl.this.mCameraId);
                        SpmCameraDeviceImpl.this.mMamagerHandler.sendMessage(msg);
                    }
                }
            }
        }
    }

    private class EventHandler
    extends Handler {
        private SpmCameraDeviceImpl mCameraDevice;

        public EventHandler(SpmCameraDeviceImpl cd, Looper looper) {
            super(looper);
            this.mCameraDevice = cd;
        }

        public void handleMessage(Message msg) {
            if (DEBUG) {
                Log.i((String)SpmCameraDeviceImpl.this.TAG, (String)("handleMessage: " + msg.what));
            }
            switch (msg.what) {
                case 1: {
                    ImageReaderEx pictureTaken = (ImageReaderEx)msg.obj;
                    boolean needRelease = true;
                    if (mPreSetPictureSurface) {
                        needRelease = false;
                    }
                    this.mCameraDevice.stopTakePicture(pictureTaken, needRelease);
                    return;
                }
                case 2: {
                    this.mCameraDevice.handleResultMetadata();
                    return;
                }
                case 3: {
                    SpmCameraDeviceImpl.this.initSound();
                    return;
                }
                case 4: {
                    SpmCameraDeviceImpl.this.releaseSound();
                    return;
                }
                case 5: {
                    SpmCameraDevice.CamPictureCallback callback = (SpmCameraDevice.CamPictureCallback)msg.obj;
                    SpmCameraDeviceImpl.this.takePictureFail(callback);
                    return;
                }
                case 6: {
                    SpmCameraDeviceImpl.this.removeTakePictureTimeoutMessage();
                    return;
                }
            }
            Log.e((String)SpmCameraDeviceImpl.this.TAG, (String)("Unknow message type " + msg.what));
        }
    }
}

