/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.util.Log;
import com.mediatek.smartplatform.SmartPlatformManager;

public class IpodProxy {
    private static final String TAG = "IpodProxy";
    private static SmartPlatformManager mSmartPlatformManager;
    private static IpodProxy mIpodProxy;
    public static final int RESULT_SUCCESS = 0;
    public static final int RESULT_PARAMS_SAVED = 1;
    public static final int RESULT_PARAMS_REPLACED = 2;
    public static final int RESULT_FAIL = -1;
    public static final int RESULT_EXCEPTION = -2;
    private static final String DO_SHUTDOWN = "do_shutdown";
    private static final String SET_REBOOT_TIME_SLOT = "set_reboot_time_slot";
    private static final String SET_REBOOT_CONTROL = "set_reboot_control";
    private static final String EXIT_IPOD = "exit_ipod";

    private IpodProxy() {
    }

    public static synchronized IpodProxy getInstance(SmartPlatformManager smartPlatformManager) {
        if (smartPlatformManager == null) {
            Log.e((String)TAG, (String)"param carcorderManager is null.");
            return null;
        }
        if (mIpodProxy == null) {
            mIpodProxy = new IpodProxy();
        }
        mSmartPlatformManager = smartPlatformManager;
        return mIpodProxy;
    }

    public int doShutdown(String reason, boolean isShutdown) {
        try {
            ProxyParameter param = new ProxyParameter();
            param.writeString(reason);
            param.writeBoolean(isShutdown);
            return mSmartPlatformManager.postIpodCommand(DO_SHUTDOWN, param.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int setRebootTimeSlot(int slotTime) {
        try {
            ProxyParameter param = new ProxyParameter();
            param.writeInt(slotTime);
            return mSmartPlatformManager.postIpodCommand(SET_REBOOT_TIME_SLOT, param.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int setRebootControl(int flag) {
        try {
            ProxyParameter param = new ProxyParameter();
            param.writeInt(flag);
            return mSmartPlatformManager.postIpodCommand(SET_REBOOT_CONTROL, param.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    public int exitIpod(int reason) {
        try {
            ProxyParameter param = new ProxyParameter();
            param.writeInt(reason);
            return mSmartPlatformManager.postIpodCommand(EXIT_IPOD, param.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return -2;
        }
    }

    private class ProxyParameter {
        private static final String PARAM_TYPE_END = "0";
        private static final String PARAM_TYPE_INT = "1";
        private static final String PARAM_TYPE_LONG = "2";
        private static final String PARAM_TYPE_FLOAT = "3";
        private static final String PARAM_TYPE_DOUBLE = "4";
        private static final String PARAM_TYPE_STRING = "5";
        private StringBuilder params = new StringBuilder(128);

        private ProxyParameter() {
        }

        public void writeBoolean(boolean param) {
            if (param) {
                this.writeInt(1);
            } else {
                this.writeInt(0);
            }
        }

        public void writeInt(int param) {
            this.write(PARAM_TYPE_INT, Integer.toString(param));
        }

        public void writeLong(long param) {
            this.write(PARAM_TYPE_LONG, Long.toString(param));
        }

        public void writeFolat(float param) {
            this.write(PARAM_TYPE_FLOAT, Float.toString(param));
        }

        public void writeDouble(double param) {
            this.write(PARAM_TYPE_DOUBLE, Double.toString(param));
        }

        public void writeString(String param) {
            this.write(PARAM_TYPE_STRING, param);
        }

        public void write(String type, String param) {
            this.params.append(type);
            this.params.append("=");
            this.params.append(param);
            this.params.append(";");
        }

        public String toString() {
            return this.params.toString() + PARAM_TYPE_END;
        }
    }
}

