/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.Log;
import android.view.Surface;
import com.mediatek.smartplatform.Image;
import com.mediatek.smartplatform.ImageDataCallbackInfo;
import com.mediatek.smartplatform.ImageReader;
import com.mediatek.smartplatform.ImageUtils;
import com.mediatek.smartplatform.SpmCameraDevice;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class ImageReaderEx {
    private static String TAG = "ImageReaderEx";
    private static final boolean VERBOSE = Log.isLoggable((String)TAG, (int)2);
    private static final boolean DEBUG = Log.isLoggable((String)TAG, (int)3);
    private static final boolean DUMP = SystemProperties.getBoolean((String)"persist.vendor.spm_ir", (boolean)false);
    private static final boolean DUMP_JPEG = SystemProperties.getBoolean((String)"persist.vendor.spm_ire", (boolean)false);
    private static final boolean DUMP_BUFFER = SystemProperties.getBoolean((String)"persist.vendor.spm_dbb", (boolean)false);
    private static final boolean DUMP_IMAGE_SELF = SystemProperties.getBoolean((String)"persist.vendor.spm_dis", (boolean)false);
    private static final boolean USE_HW_JPG_ENC = SystemProperties.getBoolean((String)"persist.vendor.spm_hwjpg", (boolean)true);
    private static final boolean DEBUG_ONE = SystemProperties.getBoolean((String)"persist.vendor.spm_ire_one", (boolean)false);
    private static final int MAX_NUM_IMAGES = 5;
    private static final long WAIT_FOR_IMAGE_TIMEOUT_MS = 1000L;
    private ImageReader mReader;
    private Surface mReaderSurface;
    private HandlerThread mHandlerThread;
    private Handler mHandler;
    private ImageListener mImageListener;
    private HandlerThread mLoopThread = null;
    private ProcessHandler mLoopHandler = null;
    private HandlerThread mDeleteThread = null;
    private DeleteHandler mDeleteHandler = null;
    private String mCandidataDeleteDir = null;
    private File mMediaStorageDir = null;
    private int mImageNum = 0;
    private Object mImageNumLock = new Object();
    private int mOutImageFormat = 1;
    private int mOutDataType = 2;
    private int mCamImageFormat = 35;
    private String mOutImageDir = null;
    private File mOutImageDirF = null;
    private String mOutImageName = null;
    private ImageCallback mImageCallback = null;
    private SpmCameraDevice.ImageDataCallback mImageDataCallback = null;
    private boolean mStopping = false;
    private String mCameraId;
    private int mMaxSaveImagNum = 100;
    private int mSaveImagNum = 0;
    private boolean mJpegEncHw = true;
    private boolean mSequence = true;
    private boolean hasPicture = false;
    private SpmCameraDevice.CamPictureCallback mCamPictureCallback = null;
    private Handler mCameraDeviceHandler = null;
    private static final boolean mCallbackUseJpeg = SystemProperties.getBoolean((String)"persist.vendor.spm_cb_jpeg", (boolean)false);
    private static final int SUCCEEDED = 0;
    private static final int FAILED = -1;
    private static final int MESSAGE_DELETE_DIR = 1;
    private static final int COLOR_FormatI420 = 1;
    private static final int COLOR_FormatNV21 = 2;

    private int getInitSurfaceFormat(int outImageFormat) {
        int format = 35;
        switch (outImageFormat) {
            case 17: 
            case 35: {
                format = 35;
                break;
            }
            case 256: {
                if (this.canUseJpeg()) {
                    format = 256;
                    break;
                }
                if (this.mSequence) {
                    format = 35;
                    break;
                }
                format = 842094169;
                break;
            }
            case 842094169: {
                format = 842094169;
                break;
            }
            case 3: {
                format = 3;
                break;
            }
            case 20: {
                format = 20;
                break;
            }
            case 1: {
                format = 1;
                break;
            }
            default: {
                Log.e((String)TAG, (String)"error outImageFormat format");
            }
        }
        return format;
    }

    public void init(int width, int height, int format, String name, String cameraId, boolean sequence) {
        this.mHandlerThread = new HandlerThread(TAG + name);
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mImageListener = new ImageListener();
        this.mCameraId = cameraId;
        this.mSequence = sequence;
        this.mCamImageFormat = this.getInitSurfaceFormat(format);
        Log.i((String)TAG, (String)("createImageReader: width = " + width + ", height = " + height + ", format = " + this.mCamImageFormat));
        this.createImageReader(width, height, this.mCamImageFormat, 5, this.mImageListener, this.mHandler);
        if (DUMP || DUMP_JPEG || DUMP_BUFFER) {
            this.mMediaStorageDir = new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), "imageReader");
            Log.i((String)TAG, (String)("dump file path: " + this.mMediaStorageDir.getPath()));
            if (!this.mMediaStorageDir.exists() && !this.mMediaStorageDir.mkdirs()) {
                Log.e((String)TAG, (String)"failed to create dump directory");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void close() {
        Log.i((String)TAG, (String)"close...");
        this.mStopping = true;
        try {
            Object object = this.mImageNumLock;
            synchronized (object) {
                while (this.mImageNum != 0 && this.mLoopThread != null && !DEBUG_ONE) {
                    Log.i((String)TAG, (String)"wait ...");
                    this.mImageNumLock.wait();
                }
            }
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)" wait InterruptedException ");
        }
        this.closeImageReader();
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quitSafely();
            this.mHandler = null;
            this.mHandlerThread = null;
        }
        if (this.mLoopThread != null) {
            this.mLoopThread.quitSafely();
            this.mLoopThread = null;
            this.mLoopHandler = null;
        }
        if (this.mDeleteThread != null) {
            this.mDeleteThread.quitSafely();
            this.mDeleteThread = null;
        }
        this.mDeleteHandler = null;
        this.mCameraDeviceHandler = null;
    }

    int start() {
        if (this.mOutDataType == 1 && this.mSequence) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
            this.createDir(timeStamp);
        }
        if (this.mLoopThread == null) {
            this.mLoopThread = new HandlerThread(TAG + "_loop_" + this.mCameraId);
            this.mLoopThread.start();
            this.mLoopHandler = new ProcessHandler(this.mLoopThread.getLooper());
        }
        if (this.mSequence && this.mDeleteThread == null) {
            this.mDeleteThread = new HandlerThread(TAG + "_delete_" + this.mCameraId);
            this.mDeleteThread.start();
            this.mDeleteHandler = new DeleteHandler(this.mDeleteThread.getLooper());
        }
        return 0;
    }

    private boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = this.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    int createDir(String time) {
        this.mOutImageDirF = this.mOutImageDir != null ? new File(this.mOutImageDir + File.separator + time) : new File(Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DCIM), File.separator + time);
        if (!this.mOutImageDirF.exists() && !this.mOutImageDirF.mkdirs()) {
            Log.e((String)TAG, (String)("failed to create directory" + this.mOutImageDirF));
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void process() {
        Image image = null;
        try {
            Object object = this.mImageNumLock;
            synchronized (object) {
                if (this.mImageNum < 1) {
                    Log.i((String)TAG, (String)"no image in queue.");
                    return;
                }
            }
            image = this.mImageListener.getImage(1000L);
            if (image == null) {
                if (this.mLoopHandler == null) return;
                this.mLoopHandler.sendEmptyMessage(0);
                return;
            }
            if (this.mStopping) return;
            if (this.mSequence) {
                this.processImage(image);
                return;
            }
            this.processCamPicture(image);
            return;
        }
        catch (InterruptedException e) {
            Log.e((String)TAG, (String)" getImage InterruptedException ");
            return;
        }
        finally {
            if (image != null) {
                image.close();
                Object object = this.mImageNumLock;
                synchronized (object) {
                    --this.mImageNum;
                    this.mImageNumLock.notifyAll();
                    if (DEBUG) {
                        Log.i((String)TAG, (String)(" mImageNum -- " + this.mImageNum));
                    }
                }
            }
        }
    }

    private int processCamPicture(Image image) {
        String fileName;
        byte[] jpegBuf;
        if (this.mCamPictureCallback == null) {
            Log.w((String)TAG, (String)"no picturecallback, please set CamPictureCallback...");
        }
        if (this.mCameraDeviceHandler != null) {
            this.mCameraDeviceHandler.obtainMessage(6, (Object)this).sendToTarget();
        }
        if (this.mCamImageFormat != 256) {
            jpegBuf = this.compressToJpeg(image, false);
        } else {
            Image.Plane plane0 = image.getPlanes()[0];
            ByteBuffer buffer = plane0.getBuffer();
            if (buffer.hasArray()) {
                jpegBuf = buffer.array();
            } else {
                jpegBuf = new byte[buffer.capacity()];
                buffer.get(jpegBuf);
            }
        }
        int status = 0;
        if (this.mOutImageName != null) {
            fileName = this.mOutImageName;
        } else {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
            String fileExtension = ".jpeg";
            status = this.createDir(timeStamp);
            fileName = this.mOutImageDirF.getPath() + File.separator + "IMG_" + timeStamp + fileExtension;
        }
        if (this.mCamPictureCallback != null) {
            this.mCamPictureCallback.onPictureTaken(0, this.mCameraId, fileName);
        }
        Log.i((String)TAG, (String)("save picture:" + fileName));
        status = status == 0 && ImageReaderEx.dumpFile(fileName, jpegBuf) == 0 ? 1 : -1;
        if (this.mCamPictureCallback != null) {
            this.mCamPictureCallback.onPictureTaken(status, this.mCameraId, fileName);
        }
        if (this.mCameraDeviceHandler != null) {
            this.mCameraDeviceHandler.obtainMessage(1, (Object)this).sendToTarget();
        }
        return 0;
    }

    private int processImage(Image image) {
        byte[] data = null;
        long dataTimeStamp = SystemClock.currentTimeMicro() / 1000L - SystemClock.uptimeMillis() + image.getTimestamp() / 1000000L;
        switch (this.mOutDataType) {
            case 0: {
                data = this.getData(image);
                this.imageRaw(data, image.getWidth(), image.getHeight(), dataTimeStamp);
                break;
            }
            case 1: {
                data = this.getData(image);
                this.imageFile(data, dataTimeStamp);
                break;
            }
            case 2: {
                this.imageBuffer(image, image.getWidth(), image.getHeight(), dataTimeStamp);
                break;
            }
            case 3: {
                this.imageSelf(image, image.getWidth(), image.getHeight(), dataTimeStamp);
                break;
            }
            case 4: {
                this.imageFd(image, dataTimeStamp);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"error DataType format");
            }
        }
        return 0;
    }

    private byte[] getData(Image image) {
        byte[] data = null;
        switch (this.mOutImageFormat) {
            case 35: {
                data = this.getDataFromImage(image);
                break;
            }
            case 1: 
            case 3: 
            case 17: 
            case 20: 
            case 842094169: {
                data = this.getDataFromImageNoTrans(image);
                break;
            }
            case 256: {
                if (this.canUseJpeg()) {
                    data = this.getDataFromImageNoTrans(image);
                    break;
                }
                data = this.compressToJpeg(image, this.mJpegEncHw);
                break;
            }
            default: {
                Log.e((String)TAG, (String)"error OutImageFormat format");
            }
        }
        return data;
    }

    private int imageRaw(byte[] data, int width, int height, long dataTimeStamp) {
        if (this.mImageCallback != null) {
            this.mImageCallback.onImageAvailable(this.mCameraId, this.mOutImageFormat, 0, data, null);
        } else if (this.mImageDataCallback != null) {
            ImageDataCallbackInfo info = new ImageDataCallbackInfo(this.mCameraId, this.mOutImageFormat, 0, this.mOutDataType);
            info.setData(data);
            info.setHeight(height);
            info.setWidth(width);
            info.setTimeStamp(dataTimeStamp);
            this.mImageDataCallback.onImageAvailable(info);
        }
        if (DUMP) {
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
            String fileExtension = this.getFileExtension(this.mOutImageFormat);
            String fileName = this.mMediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + fileExtension;
            Log.d((String)TAG, (String)("dump file: " + fileName));
            ImageReaderEx.dumpFile(fileName, data);
        }
        return 0;
    }

    private String getFileExtension(int imageFormat) {
        String fileExtension = ".raw";
        switch (imageFormat) {
            case 35: {
                fileExtension = ".yuv420";
                break;
            }
            case 256: {
                fileExtension = ".jpeg";
                break;
            }
            case 17: {
                fileExtension = ".nv21";
                break;
            }
            case 842094169: {
                fileExtension = ".yv12";
                break;
            }
            case 3: {
                fileExtension = ".rgb888";
                break;
            }
            case 20: {
                fileExtension = ".yuy2";
                break;
            }
            case 1: {
                fileExtension = ".argb8888";
                break;
            }
            default: {
                Log.e((String)TAG, (String)"error imageFormat format");
            }
        }
        return fileExtension;
    }

    private int imageFile(byte[] data, long dataTimeStamp) {
        int status = 0;
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
        String fileExtension = this.getFileExtension(this.mOutImageFormat);
        String fileName = this.mOutImageDirF.getPath() + File.separator + "IMG_" + timeStamp + fileExtension;
        if (DUMP) {
            if (this.mSaveImagNum++ > this.mMaxSaveImagNum) {
                if (this.mCandidataDeleteDir != null && this.mDeleteHandler != null) {
                    this.mDeleteHandler.obtainMessage(1, this.mCandidataDeleteDir).sendToTarget();
                }
                this.mCandidataDeleteDir = this.mOutImageDirF.getAbsolutePath();
                status = this.createDir(timeStamp);
                this.mSaveImagNum = 0;
            }
            status = ImageReaderEx.dumpFile(fileName, data);
        }
        status = status == 0 ? 0 : -1;
        if (this.mImageCallback != null) {
            this.mImageCallback.onImageAvailable(this.mCameraId, this.mOutImageFormat, status, null, fileName);
        } else if (this.mImageDataCallback != null) {
            ImageDataCallbackInfo info = new ImageDataCallbackInfo(this.mCameraId, this.mOutImageFormat, status, this.mOutDataType);
            info.setPath(fileName);
            info.setTimeStamp(dataTimeStamp);
            this.mImageDataCallback.onImageAvailable(info);
        }
        return 0;
    }

    private int imageBuffer(Image image, int width, int height, long dataTimeStamp) {
        if (this.mImageDataCallback != null) {
            ByteBuffer buffer = image.getByteBuffer();
            ImageDataCallbackInfo info = new ImageDataCallbackInfo(this.mCameraId, this.mOutImageFormat, 0, this.mOutDataType);
            info.setBuffer(buffer);
            info.setHeight(height);
            info.setWidth(width);
            info.setTimeStamp(dataTimeStamp);
            this.mImageDataCallback.onImageAvailable(info);
        }
        if (DUMP_BUFFER) {
            ByteBuffer buffer = image.getByteBuffer();
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            buffer.rewind();
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
            String fileExtension = this.getFileExtension(this.mOutImageFormat);
            String fileName = this.mMediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + fileExtension;
            ImageReaderEx.dumpFile(fileName, buf);
        }
        return 0;
    }

    private int imageSelf(Image image, int width, int height, long dataTimeStamp) {
        if (this.mImageDataCallback != null) {
            ImageDataCallbackInfo info = new ImageDataCallbackInfo(this.mCameraId, this.mOutImageFormat, 0, this.mOutDataType);
            info.setImage(image);
            info.setHeight(height);
            info.setWidth(width);
            info.setTimeStamp(dataTimeStamp);
            this.mImageDataCallback.onImageAvailable(info);
        }
        if (DUMP_BUFFER) {
            ByteBuffer buffer = image.getByteBuffer();
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            buffer.rewind();
            String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(new Date());
            String fileExtension = this.getFileExtension(this.mOutImageFormat);
            String fileName = this.mMediaStorageDir.getPath() + File.separator + "IMG_" + timeStamp + fileExtension;
            ImageReaderEx.dumpFile(fileName, buf);
        }
        return 0;
    }

    private int imageFd(Image image, long dataTimeStamp) {
        FileDescriptor fd = image.getFileDescriptor();
        if (this.mImageDataCallback != null) {
            ImageDataCallbackInfo info = new ImageDataCallbackInfo(this.mCameraId, this.mOutImageFormat, 0, this.mOutDataType);
            info.setFileDescriptor(fd);
            info.setHeight(image.getHeight());
            info.setWidth(image.getWidth());
            info.setTimeStamp(dataTimeStamp);
            this.mImageDataCallback.onImageAvailable(info);
        }
        return 0;
    }

    int stop() {
        this.close();
        return 0;
    }

    void setImageCallback(ImageCallback callback) {
        this.mImageCallback = callback;
    }

    void setImageDataCallback(SpmCameraDevice.ImageDataCallback callback) {
        this.mImageDataCallback = callback;
    }

    void setCamPictureCallback(SpmCameraDevice.CamPictureCallback callback) {
        this.mCamPictureCallback = callback;
    }

    private boolean isSupportFormat(int format) {
        switch (format) {
            case 1: 
            case 3: 
            case 17: 
            case 20: 
            case 35: 
            case 256: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    void setOutImageFormat(int imageFormat, int dataType) {
        Log.i((String)TAG, (String)("imageFormat = " + imageFormat + "; dataType = " + dataType));
        if (this.mReader != null) {
            Log.e((String)TAG, (String)"setOutImageFormat must be called before init, do nothing & return");
            return;
        }
        this.mOutImageFormat = imageFormat;
        if (!this.isSupportFormat(imageFormat)) {
            Log.e((String)TAG, (String)("do not support format " + imageFormat + " , set default yuv_420_888 " + 35));
            this.mOutImageFormat = 35;
        }
        this.mOutDataType = dataType;
    }

    void setJpegHwEnc(boolean hw) {
        Log.i((String)TAG, (String)("setJpegEnc hw= " + hw));
        this.mJpegEncHw = hw;
    }

    boolean getJpegHwEnc() {
        return this.mJpegEncHw;
    }

    void setOutImageDir(String dir) {
        Log.i((String)TAG, (String)("OutImageDir = " + dir));
        this.mOutImageDir = dir;
    }

    void setOutImageName(String fileName) {
        Log.i((String)TAG, (String)("mOutImageName = " + fileName));
        this.mOutImageName = fileName;
    }

    void setCameraDeviceHandler(Handler handler) {
        this.mCameraDeviceHandler = handler;
    }

    public void createImageReader(int width, int height, int format, int maxNumImages, ImageReader.OnImageAvailableListener listener, Handler handler) {
        this.closeImageReader();
        this.mReader = ImageReader.newInstance(width, height, format, maxNumImages);
        this.mReaderSurface = this.mReader.getSurface();
        this.mReader.setOnImageAvailableListener(listener, handler);
        if (this.mOutDataType == 4) {
            this.mReader.setupFdPool(this.mOutImageFormat);
        }
        if (VERBOSE) {
            Log.v((String)TAG, (String)String.format("Created ImageReader size (%dx%d), format %d", width, height, format));
        }
    }

    public Surface getSurface() {
        return this.mReaderSurface;
    }

    public void closeImageReader() {
        if (this.mReader != null) {
            try {
                Image image = this.mReader.acquireLatestImage();
                if (image != null) {
                    image.close();
                }
            }
            catch (IllegalStateException e) {
                Log.i((String)TAG, (String)"close image, IllegalStateException, has no pending image");
            }
            finally {
                this.mReader.close();
                this.mReader = null;
            }
        }
    }

    public FileDescriptor enableShareBuffer(boolean enableSharebuffer, boolean enableCallback) {
        if (this.mReader != null) {
            int yuvType = -1;
            switch (this.mCamImageFormat) {
                case 17: 
                case 35: {
                    yuvType = 3;
                    break;
                }
                case 842094169: {
                    yuvType = 1;
                    break;
                }
                case 20: {
                    yuvType = 7;
                    break;
                }
                default: {
                    Log.e((String)TAG, (String)("enableShareBuffer: error mCamImageFormat format" + this.mCamImageFormat));
                    return null;
                }
            }
            int size = this.mReader.getWidth() * this.mReader.getHeight() * ImageFormat.getBitsPerPixel((int)this.mCamImageFormat) / 8;
            int numPlanes = ImageUtils.getNumPlanesForFormat(this.mCamImageFormat);
            if (enableSharebuffer) {
                this.mReader.makeCallbackAndSharebufferCoexist(enableCallback);
            }
            return this.mReader.enableShareBuffer(enableSharebuffer, size, yuvType, numPlanes);
        }
        return null;
    }

    private byte[] getDataFromImage(Image image) {
        if (image == null) {
            Log.e((String)TAG, (String)"Invalid image:");
            return null;
        }
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        byte[] data = null;
        Image.Plane[] planes = image.getPlanes();
        if (planes == null || planes.length <= 0) {
            Log.e((String)TAG, (String)"Fail to get image planes");
            return null;
        }
        if (!this.checkAndroidImageFormat(image)) {
            return null;
        }
        ByteBuffer buffer = null;
        int offset = 0;
        data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        if (VERBOSE) {
            Log.v((String)TAG, (String)("get data from " + planes.length + " planes"));
        }
        for (int i = 0; i < planes.length; ++i) {
            int shift = i == 0 ? 0 : 1;
            buffer = planes[i].getBuffer();
            if (buffer == null) {
                Log.e((String)TAG, (String)"Fail to get bytebuffer from plane");
                return null;
            }
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            if (pixelStride <= 0) {
                Log.e((String)TAG, (String)("pixel stride " + pixelStride + " is invalid"));
                return null;
            }
            if (VERBOSE) {
                Log.v((String)TAG, (String)("pixelStride " + pixelStride));
                Log.v((String)TAG, (String)("rowStride " + rowStride));
                Log.v((String)TAG, (String)("width " + width));
                Log.v((String)TAG, (String)("height " + height));
            }
            int w = crop.width() >> shift;
            int h = crop.height() >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            if (rowStride < w) {
                Log.e((String)TAG, (String)("rowStride " + rowStride + " should be >= width " + w));
                return null;
            }
            for (int row = 0; row < h; ++row) {
                int length;
                int bytesPerPixel = ImageFormat.getBitsPerPixel((int)format) / 8;
                if (pixelStride == bytesPerPixel) {
                    length = w * bytesPerPixel;
                    buffer.get(data, offset, length);
                    offset += length;
                } else {
                    length = (w - 1) * pixelStride + bytesPerPixel;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[offset++] = rowData[col * pixelStride];
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
            if (!VERBOSE) continue;
            Log.v((String)TAG, (String)("Finished reading data from plane " + i));
        }
        return data;
    }

    private boolean checkAndroidImageFormat(Image image) {
        int format = image.getFormat();
        Image.Plane[] planes = image.getPlanes();
        boolean ret = false;
        switch (format) {
            case 17: 
            case 35: 
            case 842094169: {
                if (planes.length != 3) {
                    Log.e((String)TAG, (String)("YUV420 format Images should have 3 planes, but palnes = " + planes.length));
                    break;
                }
                ret = true;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("Unsupported Image Format: " + format));
            }
        }
        return ret;
    }

    private static int dumpFile(String fileName, byte[] data) {
        if (fileName == null || data == null) {
            Log.e((String)TAG, (String)"fileName and data must not be null");
            return -1;
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("output will be saved as " + fileName));
        }
        try (FileOutputStream outStream = new FileOutputStream(fileName);){
            outStream.write(data);
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"failed writing data to file");
            return -1;
        }
        return 0;
    }

    private void compressToJpeg(String fileName, Image image, boolean useHw) {
        FileOutputStream outStream;
        Log.i((String)TAG, (String)(" compressToJpeg: " + fileName));
        if (fileName == null || image == null) {
            Log.e((String)TAG, (String)"compressToJpeg, fileName and data must not be null");
            return;
        }
        try {
            Log.v((String)TAG, (String)("output will be saved as " + fileName));
            outStream = new FileOutputStream(fileName);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to create debug output file " + fileName, ioe);
        }
        Rect rect = image.getCropRect();
        YuvImage yuvImage = new YuvImage(this.getDataFromImage(image, 2), 17, rect.width(), rect.height(), null);
        if (!useHw) {
            yuvImage.compressToJpeg(rect, 100, (OutputStream)outStream);
        }
    }

    private byte[] compressToJpeg(Image image, boolean useHw) {
        ByteArrayOutputStream outStream;
        if (image == null) {
            Log.e((String)TAG, (String)"compressToJpeg, data must not be null");
            return null;
        }
        try {
            outStream = new ByteArrayOutputStream();
        }
        catch (Exception ioe) {
            throw new RuntimeException("Unable to create ByteArrayOutputStream ", ioe);
        }
        Rect rect = image.getCropRect();
        YuvImage yuvImage = new YuvImage(this.getDataFromImage(image, 2), 17, rect.width(), rect.height(), null);
        if (!useHw) {
            yuvImage.compressToJpeg(rect, 100, (OutputStream)outStream);
        }
        return outStream.toByteArray();
    }

    private boolean isImageFormatSupported(Image image) {
        int format = image.getFormat();
        switch (format) {
            case 17: 
            case 35: 
            case 842094169: {
                return true;
            }
        }
        return false;
    }

    private byte[] getDataFromImage(Image image, int colorFormat) {
        if (colorFormat != 1 && colorFormat != 2) {
            throw new IllegalArgumentException("only support COLOR_FormatI420 and COLOR_FormatNV21");
        }
        if (!this.isImageFormatSupported(image)) {
            throw new RuntimeException("can't convert Image to byte array, format " + image.getFormat());
        }
        Rect crop = image.getCropRect();
        int format = image.getFormat();
        int width = crop.width();
        int height = crop.height();
        Image.Plane[] planes = image.getPlanes();
        byte[] data = new byte[width * height * ImageFormat.getBitsPerPixel((int)format) / 8];
        byte[] rowData = new byte[planes[0].getRowStride()];
        if (VERBOSE) {
            Log.v((String)TAG, (String)("get data from " + planes.length + " planes"));
        }
        int channelOffset = 0;
        int outputStride = 1;
        for (int i = 0; i < planes.length; ++i) {
            switch (i) {
                case 0: {
                    channelOffset = 0;
                    outputStride = 1;
                    break;
                }
                case 1: {
                    if (colorFormat == 1) {
                        channelOffset = width * height;
                        outputStride = 1;
                        break;
                    }
                    if (colorFormat != 2) break;
                    channelOffset = width * height + 1;
                    outputStride = 2;
                    break;
                }
                case 2: {
                    if (colorFormat == 1) {
                        channelOffset = (int)((double)(width * height) * 1.25);
                        outputStride = 1;
                        break;
                    }
                    if (colorFormat != 2) break;
                    channelOffset = width * height;
                    outputStride = 2;
                }
            }
            ByteBuffer buffer = planes[i].getBuffer();
            int rowStride = planes[i].getRowStride();
            int pixelStride = planes[i].getPixelStride();
            if (VERBOSE) {
                Log.v((String)TAG, (String)("pixelStride " + pixelStride));
                Log.v((String)TAG, (String)("rowStride " + rowStride));
                Log.v((String)TAG, (String)("width " + width));
                Log.v((String)TAG, (String)("height " + height));
                Log.v((String)TAG, (String)("buffer size " + buffer.remaining()));
            }
            int shift = i == 0 ? 0 : 1;
            int w = width >> shift;
            int h = height >> shift;
            buffer.position(rowStride * (crop.top >> shift) + pixelStride * (crop.left >> shift));
            for (int row = 0; row < h; ++row) {
                int length;
                if (pixelStride == 1 && outputStride == 1) {
                    length = w;
                    buffer.get(data, channelOffset, length);
                    channelOffset += length;
                } else {
                    length = (w - 1) * pixelStride + 1;
                    buffer.get(rowData, 0, length);
                    for (int col = 0; col < w; ++col) {
                        data[channelOffset] = rowData[col * pixelStride];
                        channelOffset += outputStride;
                    }
                }
                if (row >= h - 1) continue;
                buffer.position(buffer.position() + rowStride - length);
            }
            if (!VERBOSE) continue;
            Log.v((String)TAG, (String)("Finished reading data from plane " + i));
        }
        return data;
    }

    private byte[] getDataFromImageNoTrans(Image image) {
        ByteBuffer buffer = image.getByteBuffer();
        buffer.rewind();
        byte[] buf = new byte[buffer.remaining()];
        buffer.get(buf);
        buffer.rewind();
        return buf;
    }

    private boolean canUseJpeg() {
        return mCallbackUseJpeg && this.mSequence || !mCallbackUseJpeg && !this.mSequence;
    }

    private int getSize() {
        double bytesPerPixel = 0.0;
        int padding = 0;
        int format = this.mReader.getFormat();
        switch (format) {
            case 3: {
                bytesPerPixel = 3.0;
                break;
            }
            case 17: 
            case 35: 
            case 842094169: {
                bytesPerPixel = 1.5;
                break;
            }
            case 20: {
                bytesPerPixel = 2.0;
                break;
            }
            case 1: {
                bytesPerPixel = 4.0;
                break;
            }
            default: {
                Log.e((String)TAG, (String)("unknow format " + format));
                return -1;
            }
        }
        return (int)((double)(this.mReader.getWidth() * this.mReader.getHeight()) * bytesPerPixel) + padding;
    }

    protected void finalize() throws Throwable {
        Log.i((String)TAG, (String)(" finalize: " + this));
        super.finalize();
    }

    private class ImageListener
    implements ImageReader.OnImageAvailableListener {
        private final LinkedBlockingQueue<Image> mQueue = new LinkedBlockingQueue();

        private ImageListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onImageAvailable(ImageReader reader) {
            try {
                if (DEBUG) {
                    Log.i((String)TAG, (String)("onImageAvailable: mImageNum = " + ImageReaderEx.this.mImageNum));
                }
                if (ImageReaderEx.this.mStopping) {
                    Log.i((String)TAG, (String)"stopping , skip get image......");
                    return;
                }
                Object object = ImageReaderEx.this.mImageNumLock;
                synchronized (object) {
                    if (ImageReaderEx.this.mImageNum >= 5) {
                        Log.i((String)TAG, (String)(" skip get Image, mImageNum = " + ImageReaderEx.this.mImageNum + " ; max = " + 5));
                        ImageReaderEx.this.mImageNumLock.wait();
                    }
                }
                Image image = reader.acquireNextImage();
                if (image == null) {
                    Log.e((String)TAG, (String)"can not acquireNextImage");
                    return;
                }
                this.mQueue.put(image);
                Object object2 = ImageReaderEx.this.mImageNumLock;
                synchronized (object2) {
                    ImageReaderEx.this.mImageNum++;
                    ImageReaderEx.this.hasPicture = true;
                }
                if (ImageReaderEx.this.mLoopHandler != null) {
                    ImageReaderEx.this.mLoopHandler.sendEmptyMessage(0);
                }
            }
            catch (InterruptedException e) {
                throw new UnsupportedOperationException("Can't handle InterruptedException in onImageAvailable");
            }
        }

        public Image getImage(long timeout) throws InterruptedException {
            if (ImageReaderEx.this.mStopping) {
                Log.i((String)TAG, (String)"stopping , skip get image......");
                return null;
            }
            Image image = this.mQueue.poll(timeout, TimeUnit.MILLISECONDS);
            if (image == null) {
                Log.e((String)TAG, (String)("Wait for an image timed out in " + timeout));
            }
            return image;
        }
    }

    private final class ProcessHandler
    extends Handler {
        public ProcessHandler(Looper looper) {
            super(looper, null, true);
        }

        public void handleMessage(Message msg) {
            if (DEBUG_ONE && ImageReaderEx.this.mSaveImagNum > 0) {
                Log.d((String)TAG, (String)"debug one, skip......");
                return;
            }
            ImageReaderEx.this.process();
        }
    }

    private final class DeleteHandler
    extends Handler {
        public DeleteHandler(Looper looper) {
            super(looper, null, true);
        }

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    String dir = (String)msg.obj;
                    Log.i((String)TAG, (String)("delete dir: " + dir + "; Candidata Delete Dir :" + ImageReaderEx.this.mCandidataDeleteDir + "; current save dir: " + ImageReaderEx.this.mOutImageDirF.getAbsolutePath()));
                    ImageReaderEx.this.deleteDir(new File(dir));
                    break;
                }
            }
        }
    }

    public static interface ImageCallback {
        public static final int IMAGE_FORMAT_YUV_420_888 = 35;
        public static final int IMAGE_FORMAT_JPEG = 256;
        public static final int IMAGE_FORMAT_NV21 = 17;
        public static final int IMAGE_FORMAT_YV12 = 842094169;
        public static final int IMAGE_FORMAT_RGB_888 = 3;
        public static final int IMAGE_FORMAT_YUY2 = 20;
        public static final int IMAGE_FORMAT_ARGB_8888 = 1;
        public static final int IMAGE_DATA_RAW = 0;
        public static final int IMAGE_DATA_FILE = 1;
        public static final int IMAGE_STATUS_SUCCEEDED = 0;
        public static final int IMAGE_STATUS_FAILED = -1;

        public void onImageAvailable(String var1, int var2, int var3, byte[] var4, String var5);
    }
}

