/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.impl.CaptureResultExtras;
import android.hardware.camera2.impl.PhysicalCaptureResultInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.mediatek.smartplatform.ADASInfo;

public interface ICameraDeviceListener
extends IInterface {
    public void onStatusChanged(int var1, int var2, String var3, int var4) throws RemoteException;

    public void onADASCallback(ADASInfo var1) throws RemoteException;

    public void onVideoFrame(int var1, int var2, int var3) throws RemoteException;

    public void onAudioFrame(int var1, int var2, int var3) throws RemoteException;

    public void onMiscDataCallback(int var1, int var2, int var3) throws RemoteException;

    public void onDeviceError(int var1, CaptureResultExtras var2) throws RemoteException;

    public void onResultReceived(CameraMetadataNative var1, CaptureResultExtras var2, PhysicalCaptureResultInfo[] var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ICameraDeviceListener {
        private static final String DESCRIPTOR = "com.mediatek.smartplatform.ICameraDeviceListener";
        static final int TRANSACTION_onStatusChanged = 1;
        static final int TRANSACTION_onADASCallback = 2;
        static final int TRANSACTION_onVideoFrame = 3;
        static final int TRANSACTION_onAudioFrame = 4;
        static final int TRANSACTION_onMiscDataCallback = 5;
        static final int TRANSACTION_onDeviceError = 6;
        static final int TRANSACTION_onResultReceived = 7;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ICameraDeviceListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ICameraDeviceListener) {
                return (ICameraDeviceListener)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    this.onStatusChanged(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    ADASInfo _arg0 = 0 != data.readInt() ? (ADASInfo)ADASInfo.CREATOR.createFromParcel(data) : null;
                    this.onADASCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onVideoFrame(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onAudioFrame(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onMiscDataCallback(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    CaptureResultExtras _arg1 = 0 != data.readInt() ? (CaptureResultExtras)CaptureResultExtras.CREATOR.createFromParcel(data) : null;
                    this.onDeviceError(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    CameraMetadataNative _arg0 = 0 != data.readInt() ? (CameraMetadataNative)CameraMetadataNative.CREATOR.createFromParcel(data) : null;
                    CaptureResultExtras _arg1 = 0 != data.readInt() ? (CaptureResultExtras)CaptureResultExtras.CREATOR.createFromParcel(data) : null;
                    PhysicalCaptureResultInfo[] _arg2 = (PhysicalCaptureResultInfo[])data.createTypedArray(PhysicalCaptureResultInfo.CREATOR);
                    this.onResultReceived(_arg0, _arg1, _arg2);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ICameraDeviceListener impl) {
            if (Proxy.sDefaultImpl == null && impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ICameraDeviceListener getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ICameraDeviceListener {
            private IBinder mRemote;
            public static ICameraDeviceListener sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChanged(int status, int arg1, String arg2, int arg3) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(status);
                    _data.writeInt(arg1);
                    _data.writeString(arg2);
                    _data.writeInt(arg3);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStatusChanged(status, arg1, arg2, arg3);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onADASCallback(ADASInfo info) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (info != null) {
                        _data.writeInt(1);
                        info.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onADASCallback(info);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onVideoFrame(int fd, int dataType, int size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fd);
                    _data.writeInt(dataType);
                    _data.writeInt(size);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onVideoFrame(fd, dataType, size);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAudioFrame(int fd, int dataType, int size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fd);
                    _data.writeInt(dataType);
                    _data.writeInt(size);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAudioFrame(fd, dataType, size);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onMiscDataCallback(int fd, int datatype, int size) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(fd);
                    _data.writeInt(datatype);
                    _data.writeInt(size);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onMiscDataCallback(fd, datatype, size);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    if (resultExtras != null) {
                        _data.writeInt(1);
                        resultExtras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDeviceError(errorCode, resultExtras);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalCaptureResultInfos) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (result != null) {
                        _data.writeInt(1);
                        result.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (resultExtras != null) {
                        _data.writeInt(1);
                        resultExtras.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedArray((Parcelable[])physicalCaptureResultInfos, 0);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onResultReceived(result, resultExtras, physicalCaptureResultInfos);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ICameraDeviceListener {
        @Override
        public void onStatusChanged(int status, int arg1, String arg2, int arg3) throws RemoteException {
        }

        @Override
        public void onADASCallback(ADASInfo info) throws RemoteException {
        }

        @Override
        public void onVideoFrame(int fd, int dataType, int size) throws RemoteException {
        }

        @Override
        public void onAudioFrame(int fd, int dataType, int size) throws RemoteException {
        }

        @Override
        public void onMiscDataCallback(int fd, int datatype, int size) throws RemoteException {
        }

        @Override
        public void onDeviceError(int errorCode, CaptureResultExtras resultExtras) throws RemoteException {
        }

        @Override
        public void onResultReceived(CameraMetadataNative result, CaptureResultExtras resultExtras, PhysicalCaptureResultInfo[] physicalCaptureResultInfos) throws RemoteException {
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

