/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.os.Build;
import android.os.RemoteException;
import android.os.SystemProperties;
import android.util.Log;
import com.mediatek.smartplatform.SimpleCommand;
import com.mediatek.smartplatform.SmartPlatformManager;
import java.util.HashSet;

public class CarEventProxy {
    private static final String TAG = "CarEventProxy";
    private static final boolean DEBUG = Build.IS_ENG || SystemProperties.getBoolean((String)"persist.vendor.log.spmsdk", (boolean)false);
    private static SmartPlatformManager mSmartPlatformManager;
    private static CarEventProxy mCarEventProxy;
    private HashSet<CarReverseCallback> mCarReverseCallbacks = new HashSet();
    private HashSet<CarEngineChangedCallback> mCarEngineChangedCallbacks = new HashSet();
    private HashSet<CarCustomizationCallback> mCarCustomizationCallbacks = new HashSet();
    private Object mLock = new Object();
    public static final int CAR_STATE_UNKNOWN = -1;
    public static final int CAR_MOTION_REVERSE = 0;
    public static final int CAR_MOTION_NORMAL = 1;
    public static final int CAR_ENGINE_FLAMEOUT = 0;
    public static final int CAR_ENGINE_WORKING = 1;
    private static final int COMMAND_QUERY_CAR_STATUS = 1;
    private static final int COMMAND_QUERY_CAR_MOTION_STATE = 2;
    private static final int COMMAND_QUERY_CAR_ENGINE_STATE = 3;
    private static final int COMMAND_SET_ACC_OFF_BEHAVIOR = 4;
    private static final int COMMAND_QUERY_CUSTOMIZATION1_STATE = 4096;
    private static final int COMMAND_QUERY_CUSTOMIZATION2_STATE = 8192;
    public static final int EVENT_CAR_REVERSE = 1;
    public static final int EVENT_COLLISION = 2;
    public static final int EVENT_CAR_ENGINE_CHANGED = 3;
    public static final int EVENT_CAR_CUSTOMIZATION1 = 1000;
    public static final int EVENT_CAR_CUSTOMIZATION2 = 2000;

    private CarEventProxy() {
    }

    public static synchronized CarEventProxy getInstance(SmartPlatformManager smartPlatformManager) {
        if (smartPlatformManager == null) {
            Log.e((String)TAG, (String)"param carcorderManager is null.");
            return null;
        }
        if (mCarEventProxy == null) {
            mCarEventProxy = new CarEventProxy();
        }
        mSmartPlatformManager = smartPlatformManager;
        return mCarEventProxy;
    }

    public void queryCarStatus() {
        SimpleCommand cmd = new SimpleCommand(true, 1, -1, -1);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public int queryCarMotionState() {
        SimpleCommand cmd = new SimpleCommand(true, 2, -1, 0);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
            return cmd.getResultInt();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int queryCarEngineState() {
        SimpleCommand cmd = new SimpleCommand(true, 3, -1, 0);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
            return cmd.getResultInt();
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setDefaultAccOffBehavior(boolean enable) {
        SimpleCommand cmd = new SimpleCommand(false, 4, enable ? 1 : 0, -1);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void queryCustomization1State() {
        SimpleCommand cmd = new SimpleCommand(true, 4096, -1, -1);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void queryCustomization2State() {
        SimpleCommand cmd = new SimpleCommand(true, 8192, -1, -1);
        try {
            mSmartPlatformManager.sendCareventCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarReverseCallback(CarReverseCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarReverseCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCarReverseCallback(CarReverseCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarReverseCallbacks.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarEngineChangedCallback(CarEngineChangedCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarEngineChangedCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCarEngineChangedCallback(CarEngineChangedCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarEngineChangedCallbacks.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCarCustomizationCallback(CarCustomizationCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarCustomizationCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCustomizationCallback(CarCustomizationCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCarCustomizationCallbacks.remove(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handEvent(int event, int arg1, int arg2) {
        if (DEBUG) {
            Log.d((String)TAG, (String)(" handEvent : " + event + ", arg1 = " + arg1 + ", arg2 = " + arg2));
        }
        switch (event) {
            case 1: {
                int status = -1;
                block11 : switch (arg2) {
                    case 2: {
                        switch (arg1) {
                            case 0: {
                                status = 3;
                                break block11;
                            }
                            case 1: {
                                status = 0;
                                break block11;
                            }
                        }
                        Log.e((String)TAG, (String)"unknown car reverse status of GPIO");
                        break;
                    }
                    case 1: {
                        status = arg1;
                        break;
                    }
                    default: {
                        Log.e((String)TAG, (String)"unknonw car status source......");
                    }
                }
                Object object = this.mLock;
                synchronized (object) {
                    for (CarReverseCallback callback : this.mCarReverseCallbacks) {
                        if (callback == null) continue;
                        callback.onReverse(status, arg2);
                    }
                    break;
                }
            }
            case 3: {
                Object object = this.mLock;
                synchronized (object) {
                    for (CarEngineChangedCallback callback : this.mCarEngineChangedCallbacks) {
                        if (callback == null) continue;
                        callback.onEngineChanged(arg1);
                    }
                    break;
                }
            }
            case 1000: 
            case 2000: {
                Object object = this.mLock;
                synchronized (object) {
                    for (CarCustomizationCallback callback : this.mCarCustomizationCallbacks) {
                        if (callback == null) continue;
                        callback.onCustomizationChanged(event, arg1);
                    }
                    break;
                }
            }
        }
    }

    public static interface CarCustomizationCallback {
        public void onCustomizationChanged(int var1, int var2);
    }

    public static interface CarEngineChangedCallback {
        public static final int CAR_ENGINE_FLAMEOUT = 0;
        public static final int CAR_ENGINE_WORKING = 1;

        public void onEngineChanged(int var1);
    }

    public static interface CarReverseCallback {
        public static final int CAR_STATUS_UNKNOWN = -1;
        public static final int CAR_STATUS_NORMAL = 0;
        public static final int CAR_STATUS_LEFT = 1;
        public static final int CAR_STATUS_RIGHT = 2;
        public static final int CAR_STATUS_REVERSE = 3;
        public static final int CAR_STATUS_SOURCE_AVM = 1;
        public static final int CAR_STATUS_SOURCE_GPIO = 2;

        public void onReverse(int var1, int var2);
    }
}

