/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.media.CamcorderProfile;
import com.mediatek.smartplatform.RecordSource;
import com.mediatek.smartplatform.SpmCameraDevice;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class RecordConfiguration {
    private static final String TAG = "RecordConfiguration";
    public CamcorderProfile mCamcorderProfile;
    public String mOutPutFilePath;
    public String mOutPutFileName;
    public SpmCameraDevice.VideoCallback mVideoCallback;
    public SpmCameraDevice.AudioCallback mAudioCallback;
    public SpmCameraDevice.RecordStatusCallback mRecordStatusCallback;
    public SpmCameraDevice.KeypointCallback mKeypointCallback;
    public SpmCameraDevice.VideoFdCallback mVideoFdCallback;
    public int mVideoFrameMode;
    public int mAudioSource;
    public int mKeypointSpanLimit;
    public boolean mRecordingMuteAudio;
    public int mVideoCbFrameRate;
    public String mLockFilePath;
    public String mLockFileNamePrefix;
    public int mVideoRotateSize;
    public int mVideoRotateDuration;
    public boolean mEnableRecordStartRing;
    public int mVideoBitRateMin;
    public int mVideoBitRateMax;
    public int mVideoCycleDeleteFileNum;
    @ReduceRecordingFps
    public int mReduceRecordingFps;
    public boolean mEnableEncryption;
    public boolean mEnableNotifyEncryptType;
    public boolean mEnableMPEG4Recover;
    public int mSDCardSpeedLimit;
    public boolean mEnableMmapType;
    public boolean mDisableCircularDelete;
    public boolean mEnableSubStreamShareAudio;

    private RecordConfiguration() {
    }

    public static RecordConfiguration get(int recordSource) {
        RecordConfiguration config = new RecordConfiguration();
        if (RecordSource.isAvmRecord(recordSource)) {
            config.mCamcorderProfile = CamcorderProfile.get((int)5);
            config.mCamcorderProfile.videoFrameRate = 25;
            config.mCamcorderProfile.videoBitRate = 6000000;
        } else {
            config.mCamcorderProfile = RecordSource.isSubRecord(recordSource) ? CamcorderProfile.get((int)4) : CamcorderProfile.get((int)6);
        }
        config.mVideoRotateDuration = 60000;
        return config;
    }

    public static @interface OutputFormat {
        public static final int MPEG_4 = 2;
        public static final int MPEG2TS = 8;
    }

    public static @interface ReduceRecordingFps {
        public static final int FULL = 1;
        public static final int HALF = 2;
        public static final int THIRTY_PERCENT = 3;
        public static final int QUARTER = 4;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VideoFrameMode {
        public static final int VIDEO_FRAME_MODE_DISABLE = 0;
        public static final int VIDEO_FRAME_MODE_SOURCE = 1;
        public static final int VIDEO_FRAME_MODE_PACKET = 2;
        public static final int VIDEO_FRAME_MODE_DUAL_SOURCE = 3;
        public static final int VIDEO_FRAME_MODE_DUAL_PACKET = 4;
        public static final int VIDEO_FRAME_MODE_CACHE_FRAME = 5;
    }
}

