/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.text.TextUtils;
import android.util.Log;
import java.util.LinkedHashMap;

public class VideoInfoMap {
    public static final String KEY_RECORDER_EVENT_TYPE = "event_type";
    public static final String KEY_RECORDER_CAMERA_ID = "camera_id";
    public static final String KEY_RECORDER_RECORDER_SOURCE = "recorder_source";
    public static final String KEY_RECORDER_COMMNENT = "comment";
    public static final String KEY_RECORDER_FILE_PATH = "file_path";
    public static final String KEY_RECORDER_START_TIME = "start_time";
    public static final String KEY_RECORDER_END_TIME = "end_time";
    public static final String KEY_RECORDER_DURATION = "duration";
    public static final String KEY_RECORDER_ENCRYPT_TYPE = "encrypt_type";
    private LinkedHashMap<String, Object> mMap = new LinkedHashMap(128);
    private String TAG = "VideoInfoMap";

    VideoInfoMap() {
    }

    public Object get(String key) {
        return this.mMap.get(key);
    }

    public String getString(String key) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key));
            return null;
        }
        return String.valueOf(value);
    }

    public String getString(String key, String defaultValue) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key + " return defaultValue:" + defaultValue));
            return defaultValue;
        }
        return String.valueOf(value);
    }

    public int getInt(String key) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key));
            return -1;
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            Log.e((String)this.TAG, (String)("invalid Key:" + key + " value:" + value));
            return -1;
        }
    }

    public int getInt(String key, int defaultValue) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key + " return defaultValue:" + defaultValue));
            return defaultValue;
        }
        try {
            return Integer.parseInt(String.valueOf(value));
        }
        catch (NumberFormatException e) {
            Log.e((String)this.TAG, (String)("invalid Key:" + key + " value:" + value + " return defaultValue:" + defaultValue));
            return defaultValue;
        }
    }

    public long getLong(String key) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key));
            return -1L;
        }
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("invalid Key:" + key + " value:" + value));
            return -1L;
        }
    }

    public long getLong(String key, long defaultValue) {
        Object value = this.mMap.get(key);
        if (value == null) {
            Log.e((String)this.TAG, (String)("has no Key:" + key + " return defaultValue:" + defaultValue));
            return -1L;
        }
        try {
            return Long.parseLong(String.valueOf(value));
        }
        catch (Exception e) {
            Log.e((String)this.TAG, (String)("invalid Key:" + key + " value:" + value + " return defaultValue:" + defaultValue));
            return defaultValue;
        }
    }

    public String toString() {
        return this.mMap.toString();
    }

    void unflatten(String flattened) {
        this.mMap.clear();
        TextUtils.SimpleStringSplitter splitter = new TextUtils.SimpleStringSplitter(';');
        splitter.setString(flattened);
        for (String kv : splitter) {
            int pos = kv.indexOf(61);
            if (pos == -1) continue;
            String k = kv.substring(0, pos);
            String v = kv.substring(pos + 1);
            this.mMap.put(k, v);
        }
    }

    String flatten() {
        StringBuilder flattened = new StringBuilder(128);
        for (String k : this.mMap.keySet()) {
            flattened.append(k);
            flattened.append("=");
            flattened.append(this.mMap.get(k));
            flattened.append(";");
        }
        flattened.deleteCharAt(flattened.length() - 1);
        return flattened.toString();
    }

    void remove(String key) {
        this.mMap.remove(key);
    }

    private void put(String key, Object value) {
        this.mMap.remove(key);
        this.mMap.put(key, value);
    }

    void set(String key, Object value) {
        if (key == null || value == null) {
            Log.e((String)this.TAG, (String)("key or value is null, key:" + key + ", value:" + value));
            return;
        }
        if (key.indexOf(61) != -1 || key.indexOf(59) != -1 || key.indexOf(0) != -1) {
            Log.e((String)this.TAG, (String)("Key \"" + key + "\" contains invalid character (= or ; or \\0)"));
            return;
        }
        if (String.valueOf(value).indexOf(61) != -1 || String.valueOf(value).indexOf(59) != -1 || String.valueOf(value).indexOf(0) != -1) {
            Log.e((String)this.TAG, (String)("Value \"" + value + "\" contains invalid character (= or ; or \\0)"));
            return;
        }
        this.put(key, value);
    }
}

