/*
 * Decompiled with CFR 0.152.
 */
package com.mediatek.smartplatform;

import android.os.RemoteException;
import android.util.Log;
import com.mediatek.smartplatform.SimpleCommand;
import com.mediatek.smartplatform.SmartPlatformManager;
import java.util.HashSet;

public class CollisionProxy {
    private static final String TAG = "CollisionProxy";
    private static SmartPlatformManager mSmartPlatformManager;
    private static CollisionProxy mCollisionProxy;
    private HashSet<CollisionCallback> mCollisionCallbacks = new HashSet();
    private Object mLock = new Object();
    private static final int COLLISION = 0;
    private static final int COLLISION_ENABLE_CALLBACK = 1;
    private static final int COLLISION_DISABLE_CALLBACK = 2;
    private static final int COLLISION_SET_NORMAL_STATUS = 3;
    private static final int COLLISION_SET_SUSPEND_STATUS = 4;
    private static final int COLLISION_SET_NORMAL_SENSITY = 5;
    private static final int COLLISION_SET_SUSPEND_SENSITY = 6;
    private static final int COLLISION_GET_NORMAL_STATUS = 7;
    private static final int COLLISION_GET_SUSPEND_STATUS = 8;
    private static final int COLLISION_GET_NORMAL_SENSITY = 9;
    private static final int COLLISION_GET_SUSPEND_SENSITY = 10;
    private static final int COLLISION_SET_NORMAL_THRESHOLD = 11;
    private static final int COLLISION_GET_NORMAL_THRESHOLD = 12;
    private static final int COLLISION_SET_SUSPEND_THRESHOLD = 13;
    private static final int COLLISION_GET_SUSPEND_THRESHOLD = 14;
    private static final int COLLISION_SET_NORMAL_GSENSOR_EVENTRATE = 15;
    private static final int COLLISION_GET_NORMAL_GSENSOR_EVENTRATE = 16;
    private static final int COLLISION_ENTER_IPOD_OFF = 17;
    private static final int COLLISION_ENTER_IPOD_BOOT = 18;

    private CollisionProxy() {
    }

    public static synchronized CollisionProxy getInstance(SmartPlatformManager smartPlatformManager) {
        if (smartPlatformManager == null) {
            Log.e((String)TAG, (String)"param carcorderManager is null.");
            return null;
        }
        if (mCollisionProxy == null) {
            mCollisionProxy = new CollisionProxy();
        }
        mSmartPlatformManager = smartPlatformManager;
        return mCollisionProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollisionCallback(CollisionCallback callback) {
        SimpleCommand cmd = new SimpleCommand(false, 1, -1, -1);
        if (this.mCollisionCallbacks.isEmpty()) {
            try {
                mSmartPlatformManager.sendCollisionCommand(cmd);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCollisionCallbacks.add(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollisionCallback(CollisionCallback callback) {
        Object object = this.mLock;
        synchronized (object) {
            if (callback != null) {
                this.mCollisionCallbacks.remove(callback);
            }
        }
        SimpleCommand cmd = new SimpleCommand(false, 2, -1, -1);
        if (this.mCollisionCallbacks.isEmpty()) {
            try {
                mSmartPlatformManager.sendCollisionCommand(cmd);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public void setNormalCollision(boolean fgEnable) {
        SimpleCommand cmd = new SimpleCommand(false, 3, fgEnable ? 1 : 0, -1);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setSuspendCollision(boolean fgEnable) {
        SimpleCommand cmd = new SimpleCommand(false, 4, fgEnable ? 1 : 0, -1);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setNormalCollisionSensity(int level) {
        SimpleCommand cmd = new SimpleCommand(false, 5, level, -1);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public void setSuspendCollisionSensity(int level) {
        SimpleCommand cmd = new SimpleCommand(false, 6, level, -1);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public boolean getNormalCollision() {
        int status = 0;
        SimpleCommand cmd = new SimpleCommand(true, 7, -1, 0);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        status = cmd.getResultInt();
        return status == 1;
    }

    public boolean getSuspendCollision() {
        int status = 0;
        SimpleCommand cmd = new SimpleCommand(true, 8, -1, 0);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        status = cmd.getResultInt();
        return status == 1;
    }

    public int getNormalCollisionSensity() {
        int sensity = 0;
        SimpleCommand cmd = new SimpleCommand(true, 9, -1, 0);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        sensity = cmd.getResultInt();
        return sensity;
    }

    public int getSuspendCollisionSensity() {
        int sensity = 0;
        SimpleCommand cmd = new SimpleCommand(true, 10, -1, 0);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        sensity = cmd.getResultInt();
        return sensity;
    }

    public int setCollisionThreshold(float x, float y, float z, int level) {
        int status = -1;
        try {
            String params = Float.toString(x) + "," + Float.toString(y) + "," + Float.toString(z) + "," + Integer.toString(level);
            SimpleCommand cmd = new SimpleCommand(false, 11, params, 0);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            status = cmd.getResultInt();
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        return status;
    }

    public float[] getCollisionThreshold() {
        try {
            SimpleCommand cmd = new SimpleCommand(true, 12, -1, 1);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            String params = cmd.getResultString();
            if (params == null || params.equals("")) {
                Log.e((String)TAG, (String)"params is null or empty");
                return null;
            }
            String[] str = params.split(",");
            if (str.length != 4) {
                Log.e((String)TAG, (String)("str.length(" + str.length + ") is bad value."));
                return null;
            }
            float[] result = new float[]{Float.parseFloat(str[0]), Float.parseFloat(str[1]), Float.parseFloat(str[2])};
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int setGsensorThreshold(int threshold) {
        try {
            int status = -1;
            String params = Integer.toString(threshold);
            SimpleCommand cmd = new SimpleCommand(false, 13, params, 0);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            status = cmd.getResultInt();
            return status;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getGsensorThreshold() {
        try {
            SimpleCommand cmd = new SimpleCommand(true, 14, -1, 1);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            String params = cmd.getResultString();
            if (params == null || params.equals("")) {
                Log.e((String)TAG, (String)"getGsensorThreshold params is null or empty");
                return -1;
            }
            return Integer.parseInt(params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int setGsensorEventRate(int delayMs) {
        try {
            String params = Integer.toString(delayMs);
            SimpleCommand cmd = new SimpleCommand(false, 15, params, 0);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            int status = cmd.getResultInt();
            return status;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int getGsensorEventRate() {
        try {
            SimpleCommand cmd = new SimpleCommand(true, 16, -1, 1);
            mSmartPlatformManager.sendCollisionCommand(cmd);
            String params = cmd.getResultString();
            if (params == null || params.equals("")) {
                Log.e((String)TAG, (String)"getGsensorEventRate params is null or empty");
                return -1;
            }
            return Integer.parseInt(params);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCollison(int COLLISION, int status) {
        Object object = this.mLock;
        synchronized (object) {
            for (CollisionCallback callback : this.mCollisionCallbacks) {
                if (callback == null) continue;
                callback.onCollison(COLLISION, status);
            }
        }
    }

    public void setIPOStandby(boolean on) {
        SimpleCommand cmd = on ? new SimpleCommand(false, 17, on ? 1 : 0, -1) : new SimpleCommand(false, 18, on ? 1 : 0, -1);
        try {
            mSmartPlatformManager.sendCollisionCommand(cmd);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static interface CollisionCallback {
        public static final int COLLISION_UNRELIABLE = 0;
        public static final int COLLISION_LOW = 1;
        public static final int COLLISION_MEDIUM = 2;
        public static final int COLLISION_HIGH = 3;

        public void onCollison(int var1, int var2);
    }

    public final class CollisionPara {
        public static final int THRESHOLD = 0;
        public static final int SENSITY = 1;
        public static final int EVENTRATE = 2;

        private CollisionPara() {
        }
    }

    public final class CollisionType {
        public static final int COLLISION_NORMAL = 0;
        public static final int COllision_SUSPEND = 1;

        private CollisionType() {
        }
    }
}

